/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.helper;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.heroes.common.ability.Ability;
import fiskfille.heroes.common.data.SHEntityData;
import fiskfille.heroes.common.helper.DecimalParser;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.hero.Hero;
import fiskfille.heroes.common.network.PacketSetTemperature;
import fiskfille.heroes.common.network.SHNetworkManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class TemperatureHelper {
    public static final DecimalParser decimalParser = new DecimalParser("#.###");
    public static final float DEFAULT_BODY_TEMPERATURE = 36.0f;

    public static float getCurrentBiomeTemperature(EntityLivingBase entity) {
        return TemperatureHelper.getCurrentBiomeTemperature(entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v);
    }

    public static float getCurrentBiomeTemperature(World world, int x, int y, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        float f = biome.func_150564_a(x, y, z);
        return f * 70.0f / 2.0f - 10.0f;
    }

    public static float getCurrentBodyTemperature(EntityLivingBase entity) {
        return TemperatureHelper.getTemperature(entity);
    }

    @SideOnly(value=Side.CLIENT)
    public static int getTemperatureForGui() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        float temp = TemperatureHelper.getCurrentBodyTemperature((EntityLivingBase)player);
        if (temp != 36.0f) {
            float diff = temp - 36.0f;
            int amount = 7 - (int)(7.0f * Math.min(temp / 36.0f, 1.0f));
            if (diff < 0.0f) {
                amount *= -1;
            }
            return MathHelper.func_76125_a((int)amount, (int)-7, (int)7);
        }
        return 0;
    }

    public static void updateTemperature(EntityLivingBase entity) {
        float temp;
        float newTemp = temp = TemperatureHelper.getCurrentBodyTemperature(entity);
        if (temp > 36.0f) {
            newTemp -= 0.01f;
        } else if (temp < 36.0f) {
            newTemp += 0.01f;
        }
        if (newTemp < 0.0f) {
            newTemp = 0.0f;
        }
        newTemp = decimalParser.parse(newTemp);
        TemperatureHelper.setTemperatureWithoutNotify(entity, newTemp);
    }

    public static boolean shouldFreeze(EntityLivingBase entity) {
        return TemperatureHelper.getCurrentBodyTemperature(entity) < 36.0f;
    }

    public static void setTemperatureWithoutNotify(EntityLivingBase entity, float temperature) {
        EntityPlayer player;
        Hero hero;
        float prevTemperature = SHEntityData.getData((EntityLivingBase)entity).temperature;
        if (entity instanceof EntityPlayer && (hero = SHHelper.getHero(player = (EntityPlayer)entity)) != null && hero.hasAbility(Ability.coldResistance) && temperature < prevTemperature) {
            temperature = prevTemperature - (prevTemperature - temperature) / 2.0f;
        }
        SHEntityData.getData((EntityLivingBase)entity).temperature = temperature;
    }

    public static void setTemperature(EntityLivingBase entity, float temperature) {
        if (TemperatureHelper.getTemperature(entity) != temperature) {
            if (entity.field_70170_p.field_72995_K) {
                SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketSetTemperature(entity, temperature));
            } else {
                SHNetworkManager.networkWrapper.sendToDimension((IMessage)new PacketSetTemperature(entity, temperature), entity.field_71093_bK);
            }
            TemperatureHelper.setTemperatureWithoutNotify(entity, temperature);
        }
    }

    public static float getTemperature(EntityLivingBase entity) {
        return SHEntityData.getData((EntityLivingBase)entity).temperature;
    }
}

