/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.network;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import fiskfille.heroes.SuperHeroes;
import fiskfille.heroes.common.data.DataManager;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;

public class PacketSetCollectedSuits
implements IMessage {
    public int id;
    public List<Item> suits;

    public PacketSetCollectedSuits() {
    }

    public PacketSetCollectedSuits(EntityPlayer entity, List<Item> list) {
        this.id = entity.func_145782_y();
        this.suits = list;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.suits = Lists.newArrayList();
        int i = buf.readInt();
        for (int j = 0; j < i; ++j) {
            Item item = (Item)Item.field_150901_e.func_82594_a(ByteBufUtils.readUTF8String((ByteBuf)buf));
            if (item == null) continue;
            this.suits.add(item);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.suits.size());
        for (int i = 0; i < this.suits.size(); ++i) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)Item.field_150901_e.func_148750_c((Object)this.suits.get(i)));
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSetCollectedSuits, IMessage> {
        public IMessage onMessage(PacketSetCollectedSuits message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                EntityPlayer player = SuperHeroes.proxy.getPlayer();
                Entity entity = player.field_70170_p.func_73045_a(message.id);
                if (entity instanceof EntityPlayer) {
                    DataManager.setCollectedSuitsWithoutNotify((EntityPlayer)entity, message.suits);
                }
            } else {
                Entity entity;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (player != null && (entity = player.field_70170_p.func_73045_a(message.id)) instanceof EntityPlayer) {
                    DataManager.setCollectedSuits((EntityPlayer)entity, message.suits);
                }
            }
            return null;
        }
    }
}

