package app.boot.events.com.oath.micro.server;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.oath.micro.server.auto.discovery.RestResource;
import com.oath.micro.server.events.RequestEvents;
import com.google.common.eventbus.EventBus;

@Component
@Path("/status")
public class EventStatusResource implements RestResource {

	private final EventBus bus;
	
	@Autowired
	public EventStatusResource(EventBus bus ){
		this.bus = bus;
	}

	@GET
	@Produces("text/plain")
	@Path("/ping")
	public String ping() {
		bus.post(RequestEvents.start("get", "1"));
		try {
			return "ok";
		} finally {
			bus.post(RequestEvents.finish("get", "1"));
		}
	}
}
