'mypiano_chung a program by NGUYEN.Chung (freeware 2020)
'#Include Once "gui_chung.bi"
'#Include Once "fbgfx.bi"
#Include Once "bass.bi"
#Include Once "file.bi"

Dim Shared As hstream _sample(128)
Dim Shared As hfx _revsample(128),_chosample(128),_eqsample(128)
Dim Shared As BASS_DX8_REVERB _revparam(128),_revparam0(128)
Dim Shared As BASS_DX8_CHORUS _choparam(128),_choparam0(128)
Dim Shared As BASS_DX8_PARAMEQ _eqparam(128),_eqparam0(128)

Dim Shared As hstream _fsample(128)
Dim Shared As hfx _frevsample(128),_fchosample(128),_feqsample(128)
Dim Shared As BASS_DX8_REVERB _frevparam(128),_frevparam0(128)
Dim Shared As BASS_DX8_CHORUS _fchoparam(128),_fchoparam0(128)
Dim Shared As BASS_DX8_PARAMEQ _feqparam(128),_feqparam0(128)

Declare Sub mypiano_init Cdecl Alias "mypiano_init" (test As Integer=1)
Declare Sub mymidiOutShortMsg Cdecl Alias "mymidioutshortmsg" (UserArg As Integer,MidiMsgvalue As Integer)
Declare Sub mymidiOutShortMsg2 Cdecl Alias "mymidioutshortmsg2" (UserArg As Integer,MidiMsgvalue As Integer)
Declare Sub mypiano_testnote Cdecl Alias "mypiano_testnote" ()
Declare Sub mypiano_sustain Cdecl Alias "mypiano_sustain" (tsustain As Integer)
Declare Sub mypiano_close Cdecl Alias "mypiano_close" ()

Function _max2(ByVal i As Integer,ByVal j As Integer)As Integer
	If i>=j Then Return i Else Return j
End Function
Function _min2(ByVal i As Integer,ByVal j As Integer)As Integer
	If i<=j Then Return i Else Return j
End Function
Function _max(ByVal i As Double,ByVal j As Double)As Double 
	If i>=j Then Return i Else Return j
End Function
Function _min(ByVal i As double,ByVal j As double)As Double
	If i<=j Then Return i Else Return j
End Function
Dim Shared As Integer ipiano=1
Declare Sub mysetcho(i As Integer)
Declare Sub myseteq(i As Integer)
Declare Sub mysetfcho(i As Integer)
Declare Sub mysetfeq(i As Integer)
Sub mypiano_init Cdecl Alias "mypiano_init" (test As Integer=1) Export 
Dim As ZString * 400 zurl0="piano/piano"+Str(24)+".mp3"
Dim As Integer i,j,k 

If ipiano=0 Then 
   BASS_Init(-1, 44100, 0,0,0)
Else
   BASS_Init(-1, 48000, 0,0,0)
EndIf 
'auxvar=BASS_getvolume()
'auxvar2=BASS_getConfig(BASS_CONFIG_GVOL_STREAM)
BASS_SetConfig(BASS_CONFIG_GVOL_STREAM,10000*0.03)
BASS_SetConfig(BASS_CONFIG_DEV_BUFFER,40)'msbufferlength
'auxvar=BASS_getConfig(BASS_CONFIG_DEV_BUFFER)

For i=24-3 To 108 Step 1
	
	j=Int((i+4)/6+0.001)*6
	If i=50 Then j-=6
   Dim As ZString * 400 zurl="piano/piano"+Str(j)+".mp3"
   If ipiano=1 Then
   	If (j Mod 12)=0 Then 
   		zurl="kawai/c"+Str(Int(j/12-0.999))+"vl.mp3"
   	Else 
   		zurl="kawai/f#"+Str(Int(j/12-0.999))+"vl.mp3"
   	EndIf
   EndIf
   If ipiano=2 Then
   	If (j Mod 12)=0 Then 
   		zurl="kawai/c"+Str(Int(j/12-0.999))+"vh.mp3"
   	Else 
   		zurl="kawai/f#"+Str(Int(j/12-0.999))+"vh.mp3"
   	EndIf
   EndIf
   If FileExists(zurl) Then 
     	 _sample(i)=BASS_StreamCreateFile(0, @zurl, 0, 0, 0)'BASS_SAMPLE_LOOP)
     	 If _sample(i)<>0 Then 
     	 	Dim As single freq=44100.0
     	 	Var ret=BASS_ChannelgetAttribute(_sample(i), BASS_ATTRIB_freq, @freq )
     	 	Var i12=12.001
     	 	If i<30 Then
     	 		i12=12.2
     	 	ElseIf i<36 Then
     	 		i12=12.1
     	 	ElseIf i<48 Then
     	 		i12=12.1
     	 	ElseIf i<52 Then
     	 		i12=12.064
     	 	ElseIf i<56 Then
     	 		i12=12.08
     	 	ElseIf i<72 Then
     	 		i12=12.08
     	 	ElseIf i<84 Then
     	 		i12=12.1
     	 	ElseIf i<96 Then
     	 		i12=12.08
     	 	ElseIf i<108 Then
     	 		i12=12.08
     	 	EndIf
     	 	If ret<>0 Then ret=BASS_ChannelsetAttribute(_sample(i), BASS_ATTRIB_freq, freq*2^((i-j)/i12))
     	 	_revsample(i)=BASS_ChannelSetFX(_sample(i),BASS_FX_DX8_REVERB,1)
     	 	ret=BASS_FXGetParameters(_revsample(i),@_revparam(i))
     	 	ret=BASS_FXGetParameters(_revsample(i),@_revparam0(i))
     	 	_chosample(i)=BASS_ChannelSetFX(_sample(i),BASS_FX_DX8_CHORUS,2)
     	 	ret=BASS_FXGetParameters(_chosample(i),@_choparam(i))
     	 	ret=BASS_FXGetParameters(_chosample(i),@_choparam0(i))
     	 	mysetcho(i)
    	 	_eqsample(i)=BASS_ChannelSetFX(_sample(i),BASS_FX_DX8_PARAMEQ,3)
     	 	ret=BASS_FXGetParameters(_eqsample(i),@_eqparam(i))
     	 	ret=BASS_FXGetParameters(_eqsample(i),@_eqparam0(i))
     	 	myseteq(i)
         If ipiano=0 Then ret=BASS_ChannelSetAttribute(_sample(i),BASS_ATTRIB_PAN,(i-(24-3+108)/2)/(150))
     	 EndIf

       If ((i Mod 12)=0 And test=1)Or i=108 Then 
        'guinotice("ok")
        BASS_ChannelPlay(_sample(i),0)
        Sleep 280
        BASS_Channelpause(_sample(i))
        BASS_ChannelSetposition(_sample(i),0,BASS_POS_BYTE)
       EndIf  
   EndIf     
   Dim As ZString * 400 fzurl="piano/pianoforte"+Str(j)+".mp3"
   If ipiano=1 Then
   	If (j Mod 12)=0 Then 
   		fzurl="kawai/c"+Str(Int(j/12-0.999))+"vh.mp3"
   	Else 
   		fzurl="kawai/f#"+Str(Int(j/12-0.999))+"vh.mp3"
   	EndIf
   EndIf
   If FileExists(fzurl) Then 
     	 _fsample(i)=BASS_StreamCreateFile(0, @fzurl, 0, 0, 0)'BASS_SAMPLE_LOOP)
     	 If _fsample(i)<>0 Then 
     	 	Dim As single freq=44100.0
     	 	Var ret=BASS_ChannelgetAttribute(_fsample(i), BASS_ATTRIB_freq, @freq )
     	 	Var i12=12.001
     	 	If i<30 Then
     	 		i12=12.2
     	 	ElseIf i<36 Then
     	 		i12=12.1
     	 	ElseIf i<48 Then
     	 		i12=12.1
     	 	ElseIf i<52 Then
     	 		i12=12.064
     	 	ElseIf i<56 Then
     	 		i12=12.08
     	 	ElseIf i<72 Then
     	 		i12=12.08
     	 	ElseIf i<84 Then
     	 		i12=12.1
     	 	ElseIf i<96 Then
     	 		i12=12.08
     	 	ElseIf i<108 Then
     	 		i12=12.08
     	 	EndIf
     	 	If ret<>0 Then ret=BASS_ChannelsetAttribute(_fsample(i), BASS_ATTRIB_freq, freq*2^((i-j)/i12))
     	 	_frevsample(i)=BASS_ChannelSetFX(_fsample(i),BASS_FX_DX8_REVERB,1)
     	 	ret=BASS_FXGetParameters(_frevsample(i),@_frevparam(i))
     	 	ret=BASS_FXGetParameters(_frevsample(i),@_frevparam0(i))
     	 	_fchosample(i)=BASS_ChannelSetFX(_fsample(i),BASS_FX_DX8_CHORUS,2)
     	 	ret=BASS_FXGetParameters(_fchosample(i),@_fchoparam(i))
     	 	ret=BASS_FXGetParameters(_fchosample(i),@_fchoparam0(i))
     	 	mysetcho(i)
    	 	_feqsample(i)=BASS_ChannelSetFX(_fsample(i),BASS_FX_DX8_PARAMEQ,3)
     	 	ret=BASS_FXGetParameters(_feqsample(i),@_feqparam(i))
     	 	ret=BASS_FXGetParameters(_feqsample(i),@_feqparam0(i))
     	 	myseteq(i)
         If ipiano=0 Then ret=BASS_ChannelSetAttribute(_fsample(i),BASS_ATTRIB_PAN,(i-(24-3+108)/2)/(150))
         If ipiano=2 Then ret=BASS_ChannelSetAttribute(_fsample(i),BASS_ATTRIB_PAN,(i-(24-3+108)/2)/(150))
     	 EndIf

       If 0 Then'((i Mod 12)=0 And test=1)Or i=108 Then 
        'guinotice("ok")
        BASS_ChannelPlay(_fsample(i),0)
        Sleep 280
        BASS_Channelpause(_fsample(i))
        BASS_ChannelSetposition(_fsample(i),0,BASS_POS_BYTE)
       EndIf  
   EndIf     
   
   'guiscan
   'If guitestkey(vk_escape) Then Exit For 

Next i
BASS_SetConfig(BASS_CONFIG_GVOL_STREAM,10000*0.99)
End Sub 

Dim Shared As Integer _mypianolock
Sub _getlock()
Dim As Integer i,j
For i=1 To 100
  For j=1 To 100	
	If _mypianolock=0 Then 
		_mypianolock=1:Exit Sub
	EndIf
	Sleep 0
  Next j	
  Sleep 1
Next
_mypianolock=1
End Sub
Sub _getlock2()
Dim As Integer i,j
For i=1 To 100
  For j=1 To 100	
	If _mypianolock=0 Then 
		_mypianolock=1:Exit Sub
	EndIf
	Sleep 0
  Next j	
  Sleep 1
Next
_mypianolock=1
End Sub
Sub _getlock3()
Dim As Integer i,j
For i=1 To 100
  For j=1 To 100	
	If _mypianolock=0 Then 
		_mypianolock=1:Exit Sub
	EndIf
	Sleep 0
  Next j	
  Sleep 1
Next
_mypianolock=1
End Sub
Sub _freelock()
	_mypianolock=0
End Sub
Sub _freelock2()
	_mypianolock=0
End Sub
Sub _freelock3()
	_mypianolock=0
End Sub
Dim Shared As Integer _noteon(256),_tsustain,_nnote,_tsustain0,_nnote0,_nnote2
Dim Shared As Single _notevelo(256),mypianovol=1,mypianochorus=1,mypianoreverb=1,mypianoeq=1,mypianotreverb=1
Dim Shared As Double _timenoteon(256),_timenoteoff(256),_timenoteoff2(256),_trelease=0.120,_tattack=0.150
Dim Shared As Single _freqcho(128),_freqeq(128),mypianotchorus=1,_avgvelo,_avgvelo2,_notevelo2(256),mypianokvelo=1
Dim Shared As Single mypianoattack=1,_avgvelo20,_davgvelo2,_davgvelo20,mypianodelay=1,_avgvelo0,_davgvelo0
Dim Shared As Single _kavgvelo20,_kavgvelo2,_avgvelo00,_davgvelo00
Sub mysetcho(i As Integer)
'    float fWetDryMix;
'    float fDepth;
'    float fFeedback;
'    float fFrequency;
'    DWORD lWaveform;
'    float fDelay;
'    DWORD lPhase
If _freqcho(i)<0.1 Then 
   _freqcho(i)=440*(2^((i-60)/12))'*(2-i/100)
   _notevelo(i)=125
EndIf
'auxvar=_notevelo(i)
_avgvelo+=(_notevelo(i)-_avgvelo)*0.03
'auxvar2=_avgvelo
Var kvelo=_max(1,1+(_notevelo(i)-_avgvelo+20)*0.04*mypianokvelo)
Var kcho=_max(0,_min(100,(_notevelo(i)-70)*0.5*mypianochorus))
_choparam(i).fwetdrymix=kcho
_choparam(i).fdepth=_max(0,_min(100,(_notevelo(i)-70)*0.19*(mypianochorus+(mypianotchorus*kvelo-1))))
_choparam(i).ffeedback=kcho
Var ret=BASS_FXSetParameters(_chosample(i),@_choparam(i))
'_fchoparam(i).fwetdrymix=kcho
'_fchoparam(i).fdepth=_max(0,_min(100,(_notevelo(i)-70)*0.19*(mypianochorus+(mypianotchorus*kvelo-1))))
'_fchoparam(i).ffeedback=kcho
Var fret=BASS_FXSetParameters(_fchosample(i),@_choparam(i))
	
End Sub
Dim Shared As Single _noteveloeq(256)
Sub myseteq(i As Integer)
'    float fCenter;
'    float fBandwidth;
'    float fGain;
If _freqeq(i)<0.001 Then 
   _freqeq(i)=440*(2^((i-60)/12))*3'*(2-i/100)
   if _freqeq(i)>44100*0.3 Then _freqeq(i)=44100*0.3
   _noteveloeq(i)=127
EndIf
If _tsustain=1 And _noteveloeq(i)>1 Then _noteveloeq(i)=127
Var keq=_max(0,_min(24,(_noteveloeq(i)-114+4.5*mypianoeq)*2.2))
'auxvar=_noteveloeq(i)
/'If keq>0.001 Then
 auxvar=_noteveloeq(i)
 auxvar2=keq
 auxvar3=_nnote
 auxvar4+=1
EndIf'/   
_eqparam(i).fcenter=_max(5000,_freqeq(i))
_eqparam(i).fbandwidth=6
_eqparam(i).fgain=keq
Var ret=BASS_FXSetParameters(_eqsample(i),@_eqparam(i))
'_feqparam(i).fcenter=_max(5000,_freqeq(i))
'_feqparam(i).fbandwidth=6
'_feqparam(i).fgain=keq
Var fret=BASS_FXSetParameters(_feqsample(i),@_eqparam(i))
	
End Sub
Dim Shared As Single _avgnnote
Sub mysetrev()
Dim As Integer i,j,k,ret
_nnote0=_nnote
_avgnnote+=(_nnote-_avgnnote)*0.03
'auxvar=_nnote
'auxvar2=_avgnnote
Var nnote2=_max(0,_nnote2+(10-_avgnnote)*mypianoreverb*0.25)
Var krev=(1+nnote2*2)/(2+nnote2)
If _tsustain=1 Then krev=(1+161)/(2+80)
Var krev1=mypianoreverb
If krev1<0.001 Then krev1=0.001
Var krevdb=(krev-2)*12/(krev1)
If krevdb<-60 Then krevdb=-60
Var gaindb=-3
If _tsustain=1 Then
   gaindb=-0.02
EndIf    
':krevdb=_min(-0.1,krevdb+3)
'    float fInGain;
'    float fReverbMix;
'    float fReverbTime;
'    float fHighFreqRTRatio;
For i=24-3 To 108
	If _noteon(i)>0 Or _timenoteoff(i)>1 Or _timenoteoff2(i)>1 Then
		'_revparam(i).fHighFreqRTRatio=0.001
		_revparam(i).fingain=gaindb
		_revparam(i).fReverbTime=_revparam0(i).fReverbTime*mypianotreverb
		_revparam(i).fReverbMix=krevdb'+_revparam0(i).fReverbMix
		ret=BASS_FXSetParameters(_revsample(i),@_revparam(i))
	EndIf
Next
End Sub
Dim Shared As Single _bassvelo(256),mypianobass=1
Sub _initbassvelo()
Dim As Integer i,j,k
Var i60=70
For i=10 To 108
	_bassvelo(i)=0.72*(mypianobass/2+0.15)+(1-mypianobass/2-0.15)*0.999
	If i<i60 Then _bassvelo(i)*=((120-i)/(120-i60))^((mypianobass-1)*1.5)
Next
For i=10 To 20
	'_bassvelo(i)=_bassvelo(20)
Next
'auxvar2=_bassvelo(24)
'auxvar3=mypianobass'_bassvelo(48)
End Sub
_initbassvelo()
Dim Shared As Integer _terror,mypianoauto=1,mypianomix2
Dim Shared As Single mypianomix=2.65
Dim Shared As Single mypianovelo=1
Sub mymidiOutShortMsg Cdecl Alias "mymidioutshortmsg" (UserArg As Integer,MidiMsgvalue As Integer) Export 
'noteonmsg.value=144+canalout+note*256+veloout*256*256
'noteoffmsg.value=128+canalout+note*256+0*256*256
If _mypianolock=1 Then _getlock()
_mypianolock=1
Var midimsg=midimsgvalue
Var code240=midimsg And 240
Var canal=midimsg And 15
Var note=(midimsg Shr 8)And 255
Var velo=0.0:velo=(midimsg Shr 16)And 255
Var dt=Timer 
Var i=note
If code240=176 then 'control
   if note=64 then 'sustain
   	If velo<63 Then
   		_tsustain=0
   	Else 
   		_tsustain=1
   	EndIf
   EndIf 
   _mypianolock=0'_freelock()
   Exit Sub 
EndIf 
If canal=9 Then _mypianolock=0:Exit Sub'drum
If i<24-3 Or i>108 Then
	_terror=1
   _mypianolock=0:Exit Sub
EndIf    
If code240=144 And velo>0 Then
	_noteon(i)+=1
	Var notevelo0=_notevelo(i)
	If _noteon(i)>=2 Then
		_noteon(i)=1
		velo=_max(velo,(_notevelo(i)*0.5))
	Else
		_nnote+=1
		If _nnote<10 Then mysetrev()
	EndIf
	'_avgvelo00+=(velo-_avgvelo00)*0.04
	'_davgvelo00+=(Abs(velo-_avgvelo00)-_davgvelo00)*0.04
	'_kavgvelo20+=(_davgvelo20/(_davgvelo20+0.01+_davgvelo00)-_kavgvelo20)*0.02
	Var i20=-6+12*mypianovelo
	Var i108=108-i20
	Var i39=39+i20
	velo*=0.82
	velo+=_nnote*mypianokvelo*3'*_kavgvelo20
	_avgvelo20+=(velo-_avgvelo20)*0.04
	velo=velo*i108/(1+_avgvelo20)
	_davgvelo20+=(Abs(velo-i108)-_davgvelo20)*0.04
	'auxvar=velo
	'auxvar2=_davgvelo20
	If mypianoauto=1 Then velo=i108+i39*(velo-i108)/(0.3+_davgvelo20)
	velo=(127.1*velo)/(19.5+velo)
   velo=_max(1,_min(127,(velo)))
   'auxvar3=velo
   'auxvar4=_nnote
	_notevelo(i)=velo
	Var dt0=_timenoteon(i)
	_timenoteon(i)=dt
	_timenoteoff(i)=0
	_timenoteoff2(i)=0
	mysetcho(i)
	_noteveloeq(i)=velo
	myseteq(i)
	Var kvol=(mypianovol*_notevelo(i)/127)*0.82
	If kvol>1 Then kvol=1
	Var tattack=(1-kvol)*_tattack*1000*mypianoattack*mypianokvelo
	Var kvol0=(mypianovol*notevelo0/127)*0.82*_max(0,1-(dt-dt0-0.05)*0.1)
	If kvol0>1 Then kvol0=1
   If kvol0>=kvol Or kvol<0.001 Or _tsustain=1 Then
   	tattack=0
   Else
   	tattack*=(kvol-kvol0)/kvol
   EndIf
   kvol=_max(0,_min(1,kvol*_bassvelo(i)))
   If ipiano=0 Then kvol=_max(0,_min(1,0.6*kvol*_bassvelo(i)))
   Var kmix=_max(0,_min(1,(1-kvol)*mypianomix))
   If ipiano=1 Then kmix=_max(0,_min(1,(1-kvol)*mypianomix*0.6))
   If ipiano=2 Then kmix=_max(0,_min(1,(1-kvol)*mypianomix*0.8))
   If mypianomix>6 Then kmix=1
   'Var ret=BASS_ChannelsetAttribute(_sample(i),BASS_ATTRIB_VOL,kvol)
   Var ret=BASS_ChannelSlideAttribute(_sample(i),BASS_ATTRIB_VOL,kvol*kmix,tattack)
   BASS_ChannelSetposition(_sample(i),0,BASS_POS_BYTE)
   BASS_ChannelPlay(_sample(i),0)
   If mypianomix<6 Then 
      Var fret=BASS_ChannelSlideAttribute(_fsample(i),BASS_ATTRIB_VOL,kvol*(1-kmix*kmix),tattack)
      BASS_ChannelSetposition(_fsample(i),0,BASS_POS_BYTE)
      BASS_ChannelPlay(_fsample(i),0)
   EndIf    
   _mypianolock=0'_freelock()
   Exit Sub 		
EndIf
If code240=128 Or (code240=144 And velo=0) Then
	If _noteon(i)<=0 Then _mypianolock=0:Exit Sub 
   _noteon(i)-=1
	If _noteon(i)<=0 Then
		_timenoteoff(i)=dt
   	_timenoteoff2(i)=0
		_nnote-=1
      'Var ret=BASS_ChannelSlideAttribute(_sample(i),BASS_ATTRIB_VOL,0,_trelease+0.25)
		If _nnote<10 Then mysetrev()
	EndIf
	_mypianolock=0'_freelock()
	Exit Sub 
EndIf
_mypianolock=0 '_freelock() 	
End Sub
Sub mymidiOutShortMsg2 Cdecl Alias "mymidioutshortmsg2" (UserArg As Integer,MidiMsgvalue As Integer) Export 
'noteonmsg.value=144+canalout+note*256+veloout*256*256
'noteoffmsg.value=128+canalout+note*256+0*256*256
If _mypianolock=1 Then _getlock2()
_mypianolock=1
Var midimsg=midimsgvalue
Var code240=midimsg And 240
Var canal=midimsg And 15
Var note=(midimsg Shr 8)And 255
Var velo=0.0:velo=(midimsg Shr 16)And 255
Var dt=Timer 
Var i=note
If code240=176 then 'control
   if note=64 then 'sustain
   	If velo<63 Then
   		_tsustain=0
   	Else 
   		_tsustain=1
   	EndIf
   EndIf
   _mypianolock=0 '_freelock2()
   Exit Sub 
EndIf 
If canal=9 Then _mypianolock=0:Exit Sub'drum
If i<24-3 Or i>108 Then 
   _terror=1
   _mypianolock=0:Exit Sub
EndIf    
If code240=144 And velo>0.1 Then
	_noteon(i)+=1
	Var notevelo0=_notevelo2(i)
	If _noteon(i)>=2 Then
		_noteon(i)=_min2(3,_noteon(i))'1
		velo=_max(velo,(_notevelo2(i)*0.5))
	Else
		_nnote+=1
		If _nnote<10 Then mysetrev()
	EndIf
	'_avgvelo0+=(velo-_avgvelo0)*0.04
	'_davgvelo0+=(Abs(velo-_avgvelo0)-_davgvelo0)*0.04
	'_kavgvelo2+=(_davgvelo2/(_davgvelo2+0.01+_davgvelo0)-_kavgvelo2)*0.02
	Var i20=-6+12*mypianovelo
	Var i108=108-i20
	Var i39=39+i20
	velo+=_nnote*mypianokvelo*3'*_kavgvelo2
	_notevelo2(i)=velo
	_avgvelo2+=(velo-_avgvelo2)*0.04
	velo=velo*i108/(1+_avgvelo2)
	_davgvelo2+=(Abs(velo-i108)-_davgvelo2)*0.04
	'auxvar=velo
	'auxvar2=_davgvelo2
	If mypianoauto=1 Then velo=i108+i39*(velo-i108)/(0.3+_davgvelo2)
   'velo=i108+i39*(velo-i108)*(i108/max(30,velo))/(0.3+_davgvelo2) 	
	'velo=(127*velo)/(19+velo)
	velo=(127.1*velo)/(19.5+velo)
   velo=_max(1,_min(127,(velo)))
   'auxvar3=velo
   'velo=_max(1,_min(127,(velo+105-_avgvelo2)))
   'velo=_max(1,_min(127,127*0.3+0.7*(velo+105-_avgvelo2)))
	_notevelo(i)=velo
	Var dt0=_timenoteon(i)
	_timenoteon(i)=dt
	_timenoteoff(i)=0
	_timenoteoff2(i)=0
	mysetcho(i)
	_noteveloeq(i)=velo
	myseteq(i)
	Var kvol=mypianovol*_notevelo(i)/127
	If kvol>1 Then kvol=1
	Var tattack=(1-kvol)*_tattack*1000*mypianoattack*mypianokvelo
	Var kvol0=(mypianovol*notevelo0/127)*_max(0,1-(dt-dt0-0.05)*0.1)
	If kvol0>1 Then kvol0=1
   If kvol0>=kvol Or kvol<0.001 Or _tsustain=1 Then
   	tattack=0
   Else
   	tattack*=(kvol-kvol0)/kvol
   EndIf 	
   kvol=_max(0,_min(1,kvol*_bassvelo(i)))
   If ipiano=0 Then kvol=_max(0,_min(1,0.6*kvol*_bassvelo(i)))
   Var kmix=_max(0,_min(1,(1-kvol)*mypianomix))
   If ipiano=1 Then kmix=_max(0,_min(1,(1-kvol)*mypianomix*0.6))
   If ipiano=2 Then kmix=_max(0,_min(1,(1-kvol)*mypianomix*0.8))
   If mypianomix>6 Then kmix=1
   'Var ret=BASS_ChannelsetAttribute(_sample(i),BASS_ATTRIB_VOL,kvol)
   Var ret=BASS_ChannelSlideAttribute(_sample(i),BASS_ATTRIB_VOL,kvol*kmix,tattack)
   BASS_ChannelSetposition(_sample(i),0,BASS_POS_BYTE)
   BASS_ChannelPlay(_sample(i),0)
   If mypianomix<6 Then 
     Var fret=BASS_ChannelSlideAttribute(_fsample(i),BASS_ATTRIB_VOL,kvol*(1-kmix*kmix),tattack)
     BASS_ChannelSetposition(_fsample(i),0,BASS_POS_BYTE)
     BASS_ChannelPlay(_fsample(i),0)
   EndIf   
   _mypianolock=0 '_freelock2()
   Exit Sub 		
EndIf
If code240=128 Or (code240=144 And velo<0.1) Then
	If _noteon(i)<=0 Then _mypianolock=0:Exit Sub 
   _noteon(i)-=1
	If _noteon(i)<=0 Then
   	_timenoteoff(i)=0
		_timenoteoff2(i)=dt
		'_nnote-=1
		'If _nnote<10 Then mysetrev()
	EndIf
	_mypianolock=0 '_freelock2()
	Exit Sub 
EndIf
_mypianolock=0 '_freelock2() 	
End Sub
Sub mypiano_sustain Cdecl Alias "mypiano_sustain" (tsustain As Integer) Export
	_tsustain=tsustain
End Sub 
Dim Shared As Double _timetestnote,_timesustain,_tdelay=0.07,_tdelay0=0.07
Sub _settdelay()
 Var tt=3.0
 If _nnote>10 Then tt=2
 If _nnote>20 Then tt=1.3
 If _nnote>30 Then tt=0.65
 If _nnote>40 Then tt=0.35
 'If tasknoteoff=1 Then tasknoteoff=0:tt=0
 If _nnote<0.1 Then tt=0
 Var kreso=0.8+(_nnote)/(4+_nnote)
 tt*=kreso
 'kvelo=(kreso-0.8)*0.2+0.9
 'If imidiout>=0 Then tt*=kdelay*0.01'0.527
 Var delay=0.300
 'tt+=delay
 'tt*=ktime
 _tdelay=(tt*_tdelay0+0.100*mypianotreverb)*mypianodelay
End Sub
Sub mypiano_testnote Cdecl Alias "mypiano_testnote" () Export 
Dim As Integer i,j,k
If Timer<_timetestnote+0.05 Then Exit Sub
Var dt=Timer 
_trelease=0.120'0.180
If _tsustain>=1 Then _trelease=9
Var kdt=_max(0.0001,_min(1.0,1-(dt-_timetestnote)/_trelease))
_timetestnote=dt
Var _nnote20=0,_nnote22=0
For i=24-3 To 108
	If _noteon(i)>0 Then _nnote20+=1:_nnote22+=1
	If _noteon(i)>4 Then _noteon(i)=4
	If _timenoteon(i)<dt-10 Then
      _noteon(i)=0
      If _timenoteoff(i)<1 Then _timenoteoff(i)=dt:_timenoteoff2(i)=0 
	EndIf 
	If _noteon(i)<=0 And _timenoteoff(i)>1 Then
		If _timenoteoff(i)<dt-_trelease-0.25 Or _notevelo(i)<2 Then
			_timenoteoff(i)=0
      	_timenoteoff2(i)=0
         BASS_Channelpause(_sample(i))        
         BASS_Channelpause(_fsample(i))        
		Else 
	      _notevelo(i)*=kdt
	      Var kvol=mypianovol*_notevelo(i)/127
	      If kvol>1 Then kvol=1
         kvol=max(0,_min(1,kvol*_bassvelo(i)))
         Var kmix=_max(0,_min(1,(1-kvol)*mypianomix))
         If mypianomix>6 Then kmix=1
         Var ret=BASS_ChannelsetAttribute(_sample(i),BASS_ATTRIB_VOL,kvol*kmix)
         If mypianomix<6 Then
            Var fret=BASS_ChannelsetAttribute(_fsample(i),BASS_ATTRIB_VOL,kvol*(1-kmix))
         EndIf    
		EndIf
	EndIf
	If _noteon(i)<=0 And _timenoteoff2(i)>1 Then
		_nnote22+=1
		If dt>_timenoteoff2(i)+_tdelay Then
			_timenoteoff(i)=dt
      	_timenoteoff2(i)=0
         'Var ret=BASS_ChannelSlideAttribute(_sample(i),BASS_ATTRIB_VOL,0,_trelease+0.25)
      EndIf    
	EndIf
	If _noteveloeq(i)>1 Then
		If dt>_timenoteon(i)+0.3 Then
			_noteveloeq(i)=0
			myseteq(i)
		EndIf
	EndIf
Next
If _nnote20<>_nnote Or _tsustain<>_tsustain0 Or _nnote0<>_nnote Or _nnote22<>_nnote2 Then
	_nnote=_nnote20
	_nnote2=_nnote22
	_nnote0=_nnote
	_tsustain0=_tsustain
	mysetrev()
   _settdelay()
EndIf
If _tsustain=0 Then'Or _nnote>0 Then 
	_timesustain=Timer
ElseIf Timer>_timesustain+10 Then
	_tsustain=0
EndIf
End Sub
Sub mypiano_close Cdecl Alias "mypiano_close" () Export 
Dim As Integer i,j,k
For i=1 To 127
	If _sample(i)<>0 Then BASS_streamFree(_sample(i))
	If _fsample(i)<>0 Then BASS_streamFree(_fsample(i))
Next

BASS_free()

End Sub
