# Contributing to RSUITE

Rsuite also wants to get help from the community while providing the developer service.

This article describes how you can help rsuite do a better job and contribute to your own strength.

## Bug reports

We uniformly collect bugs and state management through ' Github Issues'. If you find a bug, you can notify us by 'Github issues'.

## Feature requests

If you have a demand that is rsuite, you can tell us that we will assess the rationality of the requirements and implement your functionality in the appropriate version.
You can also participate in our development, submit Pull Request.

## Pull Request

We will seriously review every Pull request and will incorporate your code if it meets our code requirements.

You need to follow these procedures:

* Fork the project, clone your fork.

```bash
git clone https://github.com/<your-username>/rsuite.git
# Navigate to the newly cloned directory
cd rsuite
```

* Install project dependencies, executing at the project root:

```bash
npm install
```

-Next you can start, add your code, either fix a bug or create a new feature.

-To ensure functional stability, you need to write test cases and pass the test to execute the following command:

```bash
npm run test
```

-To ensure the unified style of your code, you need to pay attention to code specifications and execute the following commands:

```bash
npm run lint
```

* Open a Pull Request.

Finally, thank you for your participation.
