# Extensions

In the product development process, components that meet the specified business scenarios, such as Charts, Frame, are often required. These components are not included in the `rsuite` library, but we extend them on the React Suite UI and can be used as needed.

---

| Name                                           | Preview                        | Description                                                                                       |
| ---------------------------------------------- | ------------------------------ | ------------------------------------------------------------------------------------------------- |
| [@rsuite/charts][charts]                       | [View][charts-docs]            | A set of charts based on `rsuite` and `echarts`.                                                  |
| [@rsuite/schema-form][schema-form]             | [View][schema-form-docs]       | Form generation and validation based on `schema-typed` and `rsuite`.                              |
| [@rsuite/responsive-nav][nav]                  | [View][nav-docs]               | A responsive navigation component.                                                                |
| [@rsuite/react-frame][frame]                   | [View][frame-docs]             | Management system layout framework based on `rsuite` UI.                                          |
| [@rsuite/multi-date-picker][multi-date-picker] | [View][multi-date-picker-docs] | A date picker that can select multiple dates.                                                     |
| [@rsuite/document-nav][document-nav]           | [View][document-nav-docs]      | Document navigation is automatically generated based on the HTML title (h1-h6) tag.               |
| [rsuite-color-picker][color-picker]            | [View][color-picker-docs]      | Package a color picker extension that can select color for rsuite. [@cXiaof][color-picker-author] |

[schema-form]: https://github.com/rsuite/schema-form
[schema-form-docs]: https://rsuite.github.io/schema-form/
[charts]: https://github.com/rsuite/charts
[charts-docs]: https://charts.rsuitejs.com/
[nav]: https://github.com/rsuite/responsive-nav
[nav-docs]: https://rsuite.github.io/responsive-nav/
[frame]: https://github.com/rsuite/react-frame
[frame-docs]: https://rsuite.github.io/react-frame/
[multi-date-picker]: https://github.com/rsuite/multi-date-picker
[multi-date-picker-docs]: https://rsuite.github.io/multi-date-picker
[document-nav]: https://github.com/rsuite/document-nav
[document-nav-docs]: https://rsuite.github.io/document-nav/
[color-picker]: https://github.com/cXiaof/rsuite-color-picker
[color-picker-docs]: https://cxiaof.github.io/rsuite-color-picker/assets/
[color-picker-author]: https://github.com/cXiaof
