# 扩展

在产品开发过程中，往往需要一些符合指定业务场景的组件，比如 Charts，Frame。 在 `rsuite` 库中并不包含这些组件， 但是我们在 React Suite UI 基础上扩展了这些组件，可以根据需求使用。

---

| 名称                                           | 预览                           | 描述                                                                                  |
| ---------------------------------------------- | ------------------------------ | ------------------------------------------------------------------------------------- |
| [@rsuite/charts][charts]                       | [View][charts-docs]            | 基于 `rsuite` UI 与 `ECharts` 的一套图表组件。                                        |
| [@rsuite/schema-form][schema-form]             | [View][schema-form-docs]       | 基于 `schema-typed` 和 `rsuite` 的表单生成与校验。                                    |
| [@rsuite/responsive-nav][nav]                  | [View][nav-docs]               | 基于 `rsuite` Nav 增强功能的响应式导航组件。                                          |
| [@rsuite/react-frame][frame]                   | [View][frame-docs]             | 基于 `rsuite` UI 的管理后端布局框架。                                                 |
| [@rsuite/multi-date-picker][multi-date-picker] | [View][multi-date-picker-docs] | 一个可以选择多个日期的日期选择器。                                                    |
| [@rsuite/document-nav][document-nav]           | [View][document-nav-docs]      | 基于 HTML 标题（h1-h6）标签自动生成文档导航。                                         |
| [rsuite-color-picker][color-picker]            | [View][color-picker-docs]      | 一个颜色选择器 `ColorPicker`, 可以在 `rsuite` 中使用。 [@cXiaof][color-picker-author] |

[schema-form]: https://github.com/rsuite/schema-form
[schema-form-docs]: https://rsuite.github.io/schema-form/
[charts]: https://github.com/rsuite/charts
[charts-docs]: https://charts.rsuitejs.com/
[nav]: https://github.com/rsuite/responsive-nav
[nav-docs]: https://rsuite.github.io/responsive-nav/
[frame]: https://github.com/rsuite/react-frame
[frame-docs]: https://rsuite.github.io/react-frame/
[multi-date-picker]: https://github.com/rsuite/multi-date-picker
[multi-date-picker-docs]: https://rsuite.github.io/multi-date-picker
[document-nav]: https://github.com/rsuite/document-nav
[document-nav-docs]: https://rsuite.github.io/document-nav/
[color-picker]: https://github.com/cXiaof/rsuite-color-picker
[color-picker-docs]: https://cxiaof.github.io/rsuite-color-picker/assets/
[color-picker-author]: https://github.com/cXiaof
