## Installing Plugins

1. [Download the ZIP file with the Measure](https://github.com/utom/sketch-measure/archive/master.zip) and unzip;
2. Open the `Sketch Measure.sketchplugin`;



##Toolbar

A bunch of accessible features collected and represented with clear icons help you deliver accurate design specs right at your hand.


Run `Plugin` > `Sketch Measure` > `Toolbar` or use `⌃` + `⇧` + `B`.

![Toolbar](http://utom.design/measure/docs/toolbar.png)

## Resolution Setup

To set design resolution for each document.

![Setup UI](http://utom.design/measure/docs/setup.png)

##Mark Overlay

Sometimes you may need to mark an overlay to highlight a layer, this can be done easily in Sketch Measure.

1. Select one or more any layers in Sketch;
2. Click the `overlay` button in the **Toolbar** or use `⌃` +` ⇧` + `1`;



##Mark Sizes

Mark width and height label for some layers;

1. Select one or more any layers in sketch;

2. Click the `sizes` button in the **Toolbar** or use `⌃` + `⇧` + `2`;

   > If you want to mark width or height separately.
   >
   > Hold down the `⌥` key and click the `sizes` button.


![Mark sizes UI](http://utom.design/measure/docs/mark-sizes.png)


##Mark Spacings

Spacing between any layer and the artboard.

1. Select one layer in the artboard or select two any layers;

2. Click the `spacings` button in the **Toolbar** or use `⌃` + `⇧` + `3`; 

   > If you want to show margin top, right, bottom or left separately.
   >
   > Hold down the `⌥` key and click the `spacings` button.

![Mark spacings UI](http://utom.design/measure/docs/mark-spacings.png)



##Mark Properties

Mark shape layer or text layer info, such as, fill color, border color and stroke, opacity, text font family, etc.

1. Select one or more any layers in sketch;

2. Click the `properties` button in the **Toolbar** or use `⌃` + `⇧` + `4`;

   > If you want to mark any properties separately.
   >
   > Hold down the `⌥` key and click the `properties` button.

![Mark properties UI](http://utom.design/measure/docs/mark-properties.png)



##Mark Note

Mark some notes in artboard, and show in `Spec Export` viewer.

![Mark note](http://utom.design/measure/docs/mark-note.png)

1. Insert text layer, and type something;
2. Select the text layer;
3. Click the `note` button in the **Toolbar** or use `⌃` + `⇧` + `5`;




##Make Exportable
Quickly set slice presets for the layer you'd like to export. also when you set your design resolution as `dp/sp` unit, can be exporting slices as Android assets by ` Spec Export`.

![Mark spacings UI](http://utom.design/measure/docs/android-assets.png)

1. Select one or more any layers in sketch;

2. Click the `knife` button in the **Toolbar** or use `⌃` + `⇧` + `s`;

   > If you want to create slice layer.
   >
   > Hold down the `⌥` key and click the `knife` button.


![Make-exportable layer](http://utom.design/measure/docs/make-exportable.gif?resize=w720,h405)

![Create slice layer](http://utom.design/measure/docs/create-slice-layer.gif?resize=w720,h405)

## Color Names

Set color names and export `.xml`  for developer.

1. Click the `drop` button in the **Toolbar** or use `⌃` + `⇧` +` c`;

2. Select one or more shape layers or text layers in sketch;

3. Click the `add` button in the `Manage colors` UI dialog;

   > If you want to edit color name.
   >
   > Double-click the color item of list in UI dialog;

![Color names UI](http://utom.design/measure/docs/color-names.png)



## Spec Export

Automatically generating html page with one click, inspect all the design details including CSS Styles on it offline.

1. Select some artboards in sketch;

2. Click the `export` button in the **Toolbar** or use `⌃` + `⇧` + `e`;

   > if you want to create one artboard by one HTML file, please uncheck the "Advanced mode" option.

![Spec export UI](http://utom.design/measure/docs/spec-export.png)

## Spec Viewer

You can use Safari 9+ and Google Chrome to view it, it's based on HTML 5, CSS 3 and Javascript. 

- Select a layer and hover other layer to measure and get margin; 
- Click color area in the Inspector to change color format;
- Use `⌘` + `+` and `⌘` + ` -` to zoom the canvas;
- Hold down `spacebar` on keyboard, and mouse drag canvas to scroll canvas;
- Toggle note switch to show and hide the notes;

[View the demo →](http://utom.design/news/)

![Spec viewer UI](http://utom.design/measure/docs/spec-viewer.png)
