#include <stdio.h>

#define Z_OK              0
#define Z_STREAM_END      1
#define Z_NEED_DICT       2
#define Z_ERRNO         (-1)
#define Z_STREAM_ERROR  (-2)
#define Z_DATA_ERROR    (-3)
#define Z_MEM_ERROR     (-4)
#define Z_BUF_ERROR     (-5)
#define Z_VERSION_ERROR (-6)

#define Z_NO_FLUSH        0
#define Z_PARTIAL_FLUSH   1
#define Z_SYNC_FLUSH      2
#define Z_FULL_FLUSH      3
#define Z_FINISH          4
#define Z_BLOCK           5
#define Z_TREES           6

#define Z_BINARY          0
#define Z_TEXT            1
#define Z_ASCII           Z_TEXT
#define Z_UNKNOWN         2

#define ZLIB_COMPAT       "1.2.8"

#ifdef _MSC_VER
#ifdef Z_SOURCE
#define Z_EXPORT __declspec(dllexport)
#else
#define Z_EXPORT __declspec(dllimport)
#endif
#else
#define Z_EXPORT
#endif

#ifdef __cplusplus
extern "C" {
#endif

struct state;

typedef void* (*alloc_func)(void*, unsigned int, unsigned int);
typedef void (*free_func)(void*, void*);

/* Struct should be binary compatible with the zlib stream. */
typedef struct d7zs {
    const unsigned char* next_in;
    unsigned int avail_in;
    unsigned long total_in;

    unsigned char* next_out;
    unsigned int avail_out;
    unsigned long total_out;

    const char* msg;
    struct state* state;

    alloc_func zalloc;
    free_func zfree;
    void* opaque;

    int data_type;
    unsigned long adler;
    unsigned long reserved;
} d7zs;

typedef d7zs* d7zsp;

extern Z_EXPORT unsigned long crc32(unsigned long crc, const unsigned char* buf, unsigned int len);
extern Z_EXPORT unsigned long adler32(unsigned long adler, const unsigned char* buf, unsigned int len);

extern Z_EXPORT int deflateInit_(d7zs* stream, int level, const char *version, int size);
extern Z_EXPORT int deflateInit2_(d7zs* stream, int level, int method, int window, int mem, int strategy, const char *version, int size);
extern Z_EXPORT int deflate(d7zs* stream, int flush);
extern Z_EXPORT int deflateEnd(d7zs* stream);
extern Z_EXPORT int deflateReset(d7zs* stream);

extern Z_EXPORT int inflateInit_(d7zs* stream, const char *version, int size);
extern Z_EXPORT int inflateInit2_(d7zs* stream, int window, const char *version, int size);
extern Z_EXPORT int inflate(d7zs* stream, int flush);
extern Z_EXPORT int inflateEnd(d7zs* stream);
extern Z_EXPORT int inflateReset(d7zs* stream);
extern Z_EXPORT int inflateReset2(d7zs* stream, int window);

extern Z_EXPORT const char* zlibVersion();

typedef struct gzFile_s *gzFile;
extern Z_EXPORT gzFile gzopen(const char* path, const char* mode);
extern Z_EXPORT int gzputs(gzFile file, const char* s);
extern Z_EXPORT char * gzgets(gzFile file, char* buf, int len);
extern Z_EXPORT int gzrewind(gzFile file);
extern Z_EXPORT int gzeof(gzFile file);
extern Z_EXPORT int gzclose(gzFile file);

#define deflateInit(strm, level) \
        deflateInit_((strm), (level), ZLIB_COMPAT, (int)sizeof(d7zs))

#define inflateInit(strm) \
        inflateInit_((strm), ZLIB_COMPAT, (int)sizeof(d7zs))

#define deflateInit2(strm, level, method, window, memLevel, strategy) \
        deflateInit2_((strm), (level), (method), (window) ,(memLevel), (strategy), ZLIB_COMPAT, (int)sizeof(d7zs))

#define inflateInit2(strm, window) \
        inflateInit2_((strm), (window), ZLIB_COMPAT, (int)sizeof(d7zs))

#ifdef __cplusplus
}
#endif
