/*
 * Copyright (C) 2013  Rolf Timmermans
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#define Z_SOURCE
#include <d7z.h>

/* Delegate to the d7z implementation. */
#include "deflate7z.h"

/* These are the values that are valid for d7z. Refer to zlib.h for their
   meanings. Method, window and strategy must be set to these values by the
   client. Memlevel is ignored. */
#define D7Z_METHOD    8
#define D7Z_WINDOW   15
#define D7Z_MEMLEVEL  9
#define D7Z_SRATEGY   0

#define D7Z "d7z"

static const char compat[] = ZLIB_COMPAT;

extern const char* zlibVersion() {
    return ZLIB_COMPAT "-" D7Z;
}

extern int deflateInit_(d7zs* stream, int level, const char *version, int size) {
    return deflateInit2_(stream, level, D7Z_METHOD, D7Z_WINDOW, D7Z_MEMLEVEL, D7Z_SRATEGY, version, size);
}

extern int deflateInit2_(d7zs* stream, int level, int method, int window, int mem, int strategy, const char *version, int size) {
    /* Return error if zlib compatibility is not guaranteed. */
    if (version == NULL || version[0] != compat[0] || size != sizeof(d7zs)) {
        return Z_VERSION_ERROR;
    }

    /* Ignore memory level and window. */
    (void)(mem);
    (void)(window);

    /* Verify that the client calls with the correct settings. */
    if (method != D7Z_METHOD || strategy != D7Z_SRATEGY) return Z_STREAM_ERROR;

    /* Parameters are verified, just delegate to d7z now. */
    return d7z_deflateInit(stream, level);
}

extern int deflate(d7zs* stream, int flush) {
    return d7z_deflate(stream, flush);
}

extern int deflateEnd(d7zs* stream) {
    return d7z_deflateEnd(stream);
}

extern int deflateReset(d7zs* stream) {
    return d7z_deflateReset(stream);
}
