/*
 * Copyright (C) 2013  Rolf Timmermans
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "dynstream.h"

HRESULT CDynStream::Read(void* data, UInt32 length, UInt32* processed) {
    if (processed) *processed = 0;
    if (length == 0) return S_OK;
    if (readpos > size) return E_FAIL;

    size_t rem = size - readpos;
    if (rem > length) rem = (size_t)length;
    memcpy(data, (Byte*)buffer + readpos, rem);
    readpos += rem;
    if (processed) *processed = (UInt32)rem;

    return S_OK;
}

HRESULT CDynStream::Write(const void* data, UInt32 length, UInt32* processed) {
    if (processed) *processed = 0;
    if (length == 0) return S_OK;

    Byte* buf = Expand(length);
    if (!buf) return E_OUTOFMEMORY;
    memcpy(buf, data, length);
    size += length;

    if (processed) *processed = length;
    return S_OK;
}

Byte* CDynStream::Expand(size_t add) {
    add += size;
    if (add < size) return NULL;
    if (!buffer.EnsureCapacity(add)) return NULL;
    return (Byte*)buffer + size;
}
