#include <stdio.h>
#include <stdint.h>

#include "7zip/CPP/7zip/Common/StreamObjects.h"

class CDynStream: public ISequentialInStream, public ISequentialOutStream, public CMyUnknownImp {
    CByteDynBuffer buffer;
    size_t size;
    size_t readpos;

    Byte* Expand(size_t add);

public:
    CDynStream(): size(0), readpos(0) { }
    ~CDynStream() { buffer.Free(); }

    size_t GetSize() const { return size; }
    bool Eof() const { return size == readpos; }

    MY_UNKNOWN_IMP2(ISequentialInStream, ISequentialOutStream)

    STDMETHOD(Read)(void *data, UInt32 length, UInt32 *processedSize);
    STDMETHOD(Write)(const void *data, UInt32 length, UInt32 *processedSize);
};
