﻿## 简介
基于新视频引擎和白板sdk在electron上建立的跨平台教育客户端

## 项目构建
1. 确认安装32位的nodejs,2.7版本的python
2. npm install(确保安装4.0.0版本以上的electron)
3. 确认安装node-gyp，如果node没有自带node-gyp，需要[手动安装](https://github.com/nodejs/node-gyp)
4. npm run build (编译)
5. npm start
6. Windows: npm run builder-win (打包)
   Mac: npm run builder-mac


## 调试
Windows: Ctrl+F11
Mac: Cmd+F11

## 日志文件
1. Windows: %USERPROFILE%\AppData\Roaming\TClass\tclass.log
  Mac: ~/Library/Logs/TClass/tclass.log

## 备注
1. windows sdk日志在%appdata%\Tencent\liteav下
2. mac sdk日志在~/Library/Logs/TClass



###  rackey windows上安装 ####

#### 1. 安装node

> 要安装32位的

#### 2. 安装node-gyp

> 使用第一种方式安装 windows-build-tools

##### 2.1 配置npm代理

> 请使用超级管理员打开cmd.exe  具体路径： C:\Windows\System32\cmd.exe

```
npm config set proxy http://web-proxy.tencent.com:8080
npm config set https-proxy http://web-proxy.tencent.com:8080
```

##### 2.2 安装windows-build-tools

> 期间会自动安装python， Visual Studio Build Tools，过程稍久

```
npm install --global --production windows-build-tools
```

> 显示以下信息，表示安装完成

```
---------- Visual Studio Build Tools ----------
Successfully installed Visual Studio Build Tools.
------------------- Python --------------------
Successfully installed Python 2.7

Now configuring the Visual Studio Build Tools and Python...

All done!

```

##### 2.3 安装 node-gyp

```
npm install -g node-gyp
```

#### 3. 安装项目依赖的包

```
npm install
```

#### 4. 编译

```
npm run build
```

#### 5. 运行

```
npm run start
```
