// 从业务服务器获取userSig
// 先临时使用，后续有了业务服务器时只需修改这里
var userMap=[];

// 获取课堂详情(Saas专用)
function getClassInfo(class_id, callback){
  data = JSON.stringify({
    platform: (process.platform != 'darwin') ? "PC" : "Mac",
    class_id: class_id,
  });
  reqUrl = getServerDomain()+"/saas/v1/class/info?sdkappid="+g_data.sdkAppId+"&user_id="+g_data.userId+"&token="+g_data.token+"&random="+Math.floor(Math.random()*10000);
  log.info("[TAG-BUS] getClassInfo->url: "+reqUrl);
  log.info("[TAG-BUS] getClassInfo->req: "+data);
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: reqUrl,
    data: data,
    success: function(json) {
      log.info("[TAG-CLASS] getClassInfo->rsp: "+JSON.stringify(json));
      if (json && json.error_code === 0){
        callback(true, json);
      }else{
        callback(false, json.error_code+","+json.error_msg);
      }
    },
    error: function(xhr, status, err){
      callback(false, "", xhr.status + ': ' + xhr.statusText);
      log.info("[TAG-CLASS] getClassInfo->error: "+xhr.status + ': ' + xhr.statusText);
    }
  });
}

// 加入课堂
function enterClass(class_id, callback){
  var request = {
    platform: (process.platform != 'darwin') ? "PC" : "Mac",
    class_id: class_id,
    role: "student"
  };
  request["password"] = g_data.password;
  data = JSON.stringify(request);
  reqUrl = getServerDomain()+"/saas/v1/member/join?sdkappid="+g_data.sdkAppId+"&user_id="+g_data.userId+"&token="+g_data.token+"&random="+Math.floor(Math.random()*10000);
  log.info("[TAG-BUS] enterClass->url: "+reqUrl);
  log.info("[TAG-BUS] enterClass->req: "+data);
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: reqUrl,
    data: data,
    success: function(json) {
      log.info("[TAG-CLASS] enterClass->rsp: "+JSON.stringify(json));
      if (json && json.error_code === 0){
        callback(true, json);
      }else{
        callback(false, json.error_code+","+json.error_msg);
      }
    },
    error: function(xhr, status, err){
      callback(false, "", xhr.status + ': ' + xhr.statusText);
      log.info("[TAG-CLASS] enterClass->error: "+xhr.status + ': ' + xhr.statusText);
    }
  });
}

// 退出课堂
function quitClass(class_id, callback){
  data = JSON.stringify({
    class_id: class_id
  });
  reqUrl = getServerDomain()+"/saas/v1/member/quit?sdkappid="+g_data.sdkAppId+"&user_id="+g_data.userId+"&token="+g_data.token+"&random="+Math.floor(Math.random()*10000);
  log.info("[TAG-BUS] quitClass->url: "+reqUrl);
  log.info("[TAG-BUS] quitClass->req: "+data);
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: reqUrl,
    data: data,
    success: function(json) {
      log.info("[TAG-BUS] quitClass->rsp: "+JSON.stringify(json));
      if (json && json.error_code === 0){
        callback(true, json);
      }else{
        callback(false, json.error_code+","+json.error_msg);
      }
    },
    error: function(xhr, status, err){
      callback(false, "", xhr.status + ': ' + xhr.statusText);
      log.info("[TAG-BUS] quitClass->error: "+xhr.status + ': ' + xhr.statusText);
    }
  });
}

// 设备操作
function operateDevice(class_id, device, option){
  data = JSON.stringify({
    class_id: class_id,
    device_type: device,
    device_option: option
  });
  reqUrl = getServerDomain()+"/saas/v1/member/device?sdkappid="+g_data.sdkAppId+"&user_id="+g_data.userId+"&token="+g_data.token+"&random="+Math.floor(Math.random()*10000);
  log.info("[TAG-BUS] operateDevice->url: "+reqUrl);
  log.info("[TAG-BUS] operateDevice->req: "+data);
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: reqUrl,
    data: data,
    success: function(json) {
      log.info("[TAG-CLASS] operateDevice->rsp: "+JSON.stringify(json));
      if (json && json.error_code === 0){
        log.error("[TAG-CLASS] operateDevice->rsp: "+JSON.stringify(json));
      }else{
        log.error("[TAG-CLASS] operateDevice->fail: "+json.error_code+","+json.error_msg);
      }
    },
    error: function(xhr, status, err){
      log.info("[TAG-CLASS] operateDevice->error: "+xhr.status + ': ' + xhr.statusText);
    }
  });
}

// 事件上报
function reportEvent(class_id, event, data, callback=null){
  data = JSON.stringify({
    class_id: class_id,
    event: event,
    data: data
  });
  reqUrl = getServerDomain()+"/saas/v1/report/event?sdkappid="+g_data.sdkAppId+"&user_id="+g_data.userId+"&token="+g_data.token+"&random="+Math.floor(Math.random()*10000);
  log.info("[TAG-BUS] reportEvent->url: "+reqUrl);
  log.info("[TAG-BUS] reportEvent->req: "+data);
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: reqUrl,
    data: data,
    success: function(json) {
      log.info("[TAG-BUS] reportEvent->rsp: "+JSON.stringify(json));
      callback && callback(true, json);
    },
    error: function(xhr, status, err){
      log.info("[TAG-CLASS] reportEvent->error: "+xhr.status + ': ' + xhr.statusText);
      callback && callback(false, err);
    }
  });
}

// 心跳
function heartBeat(class_id, callback){
  data = JSON.stringify({
    class_id: class_id
  });
  reqUrl =getServerDomain()+"/saas/v1/report/heartbeat?sdkappid="+g_data.sdkAppId+"&user_id="+g_data.userId+"&token="+g_data.token+"&random="+Math.floor(Math.random()*10000);
  log.info("[TAG-BUS] heartBeat->url: "+reqUrl);
  log.info("[TAG-BUS] heartBeat->req: "+data);
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: reqUrl,
    data: data,
    success: function(json) {
      log.info("[TAG-BUS] heartBeat->rsp: "+JSON.stringify(json));
      if (json.error_code == 0){
        g_data.classInfo.duration_time = json.duration_time;
      }
      callback(json.error_code, json.error_msg);
    },
    error: function(xhr, status, err){
      callback(-1, "", xhr.status + ': ' + xhr.statusText);
      log.info("[TAG-BUS] heartBeat->error: "+xhr.status + ': ' + xhr.statusText);
    }
  });
}

// 获取成员列表
function getMemberList(classId, index, callback){
  data = JSON.stringify({
    class_id: classId,
    index: index
  });
  reqUrl = getServerDomain()+"/saas/v1/member/runtime/list?sdkappid="+g_data.sdkAppId+"&user_id="+g_data.userId+"&token="+g_data.token+"&random="+Math.floor(Math.random()*10000);
  log.info("[TAG-BUS] getMemberList->url: "+reqUrl);
  log.info("[TAG-BUS] getMemberList->req: "+data);
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: reqUrl,
    data: data,
    success: function(json) {
      log.info("[TAG-CLASS] getMemberList->rsp: "+JSON.stringify(json));
      if (json && json.error_code === 0){
        log.info("[TAG-CLASS]  getMemberList->success: "+JSON.stringify(json));
        callback(true, json);
      }else{
        log.error("[TAG-CLASS]  getMemberList->failed: "+JSON.stringify(json));
        callback(false, JSON.stringify(json));
      }
    },
    error: function(xhr, status, err){
      callback(false, "", xhr.status + ': ' + xhr.statusText);
      log.info("[TAG-CLASS] getMemberList->error: "+xhr.status + ': ' + xhr.statusText);
    }
  });
}

// 上课
function startClass(classId, callback){
  data = JSON.stringify({
    class_id: classId
  });
  reqUrl = getServerDomain()+"/saas/v1/class/start?sdkappid="+g_data.sdkAppId+"&user_id="+g_data.userId+"&token="+g_data.token+"&random="+Math.floor(Math.random()*10000);
  log.info("[TAG-BUS] startClass->url: "+reqUrl);
  log.info("[TAG-BUS] startClass->req: "+data);
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: reqUrl,
    data: data,
    success: function(json) {
      log.info("[TAG-CLASS] startClass->rsp: "+JSON.stringify(json));
      if (json && json.error_code === 0){
        log.info("[TAG-CLASS]  startClass->success: "+JSON.stringify(json));
        callback(true, json);
      }else{
        log.error("[TAG-CLASS]  startClass->failed: "+JSON.stringify(json));
        callback(false, JSON.stringify(json));
      }
    },
    error: function(xhr, status, err){
      callback(false, "", xhr.status + ': ' + xhr.statusText);
      log.info("[TAG-CLASS] startClass->error: "+xhr.status + ': ' + xhr.statusText);
    }
  });
}

// 下课
function endClass(classId, callback){
  data = JSON.stringify({
    class_id: classId
  });
  reqUrl = getServerDomain()+"/saas/v1/class/stop?sdkappid="+g_data.sdkAppId+"&user_id="+g_data.userId+"&token="+g_data.token+"&random="+Math.floor(Math.random()*10000);
  log.info("[TAG-BUS] endClass->url: "+reqUrl);
  log.info("[TAG-BUS] endClass->req: "+data);
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: reqUrl,
    data: data,
    success: function(json) {
      log.info("[TAG-CLASS] endClass->rsp: "+JSON.stringify(json));
      if (json && json.error_code === 0){
        log.info("[TAG-CLASS]  endClass->success: "+JSON.stringify(json));
        callback(true, json);
      }else{
        log.error("[TAG-CLASS]  endClass->failed: "+JSON.stringify(json));
        callback(false, JSON.stringify(json));
      }
    },
    error: function(xhr, status, err){
      callback(false, "", xhr.status + ': ' + xhr.statusText);
      log.info("[TAG-CLASS] endClass->error: "+xhr.status + ': ' + xhr.statusText);
    }
  });
}

// 获取用户信息
function getUserInfoInner(userId, callback){
  data = JSON.stringify({
    user_id: userId
  });
  reqUrl = getServerDomain()+"/saas/v1/user/info?sdkappid="+g_data.sdkAppId+"&user_id="+g_data.userId+"&token="+g_data.token+"&random="+Math.floor(Math.random()*10000);
  log.info("[TAG-BUS] getUserInfoInner->url: "+reqUrl);
  log.info("[TAG-BUS] getUserInfoInner->req: "+data);
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: reqUrl,
    data: data,
    success: function(json) {
      log.info("[TAG-BUS] getUserInfoInner->rsp: "+JSON.stringify(json));
      if (json && json.error_code === 0){
        callback(true, json.user_info);
      }else{
        callback(false, JSON.stringify(json));
      }
    },
    error: function(xhr, status, err){
      callback(false, "", xhr.status + ': ' + xhr.statusText);
      log.info("[TAG-CLASS] getUserInfoInner->error: "+xhr.status + ': ' + xhr.statusText);
    }
  });
}

function getUserInfo(userId, callback){
  if (null != userMap[userId]){ // 优化取本地缓存
    callback(userMap[userId]);
  }else{
    getUserInfoInner(userId, (ret, rsp)=>{
      if (ret){
        userMap[userId] = rsp;
        callback(rsp);
      }else{
        callback(null);
      }
    });
  }
}

// 获取用户呢称
function getUserNickName(userId, callback){
  //log.info("[XX] getUserNickName->userId: "+userId+"/"+g_data.userId);
  if (userId == g_data.userId && g_data.nickName.lenght>0){
    callback(g_data.nickName);
  }else if (null != userMap[userId]){
    callback(userMap[userId].nickname);
  }else{
    getUserInfo(userId, (info)=>{
      callback(null!=info ? info.nickname : userId);
    });
  }
}

// 登录-获取用户信息
function getUserSig(userId, password, callback){
  data = JSON.stringify({
    password: password,
    platform: (process.platform != 'darwin') ? "PC" : "Mac",
    role: "student"
  });
  var md5 = crypto.createHash('md5');
  var sign = md5.update(data).digest('hex');
  var reqUrl = getServerDomain()+"/saas/v1/user/login?sdkappid="+g_data.sdkAppId+"&user_id="+g_data.userId+"&random="+Math.floor(Math.random()*10000)+"&sign="+sign
  log.info("[TAG-BUS] getUserSig->url: "+reqUrl);
  log.info("[TAG-BUS] getUserSig->req: "+data);
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: reqUrl,
    data: data,
    success: function(json, status, xhr) {
      //alert("xhr:"+xhr.getAllResponseHeaders());
      //g_data.token = xhr.getResponseHeader("x-api-token");
      log.info("[TAG-BUS] getUserSig->rsp:"+JSON.stringify(json));
      //alert("token: "+g_data.token);
      if (json && json.error_code === 0){
        g_data.token = json.token;
        callback(true, userId, json.user_sig);
      }else{
        callback(false, json.error_code, json.error_msg);
      }
    },
    error: function(xhr, status, err){
      callback(false, "", xhr.status + ': ' + xhr.statusText);
    }
  });
}


function getCompanyInfo(companyId, callback){
  id = parseInt(companyId)
  data = JSON.stringify({
    enterprise_id: id
  });
  var md5 = crypto.createHash('md5');
  var sign = md5.update(data).digest('hex');

  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: getServerDomain()+"/saas/v1/business/base/info?random="+Math.floor(Math.random()*10000),
    data: data,
    success: function(json, status, xhr) {
      if (json && json.error_code === 0){
        g_data.token = json.token;
        callback(true, json);
      }else{
        callback(false, json);
      }
    },
    error: function(xhr, status, err){
      callback(false, "", xhr.status + ': ' + xhr.statusText);
    }
  });
}
