// 获取seq
function getSeq(){
  return Date.now();
}

// 获取通用头部
function ctlGetCom(type){
  return {
    user_id: g_data.userId,
    time: Date.now(),
    type: type,
    role: g_data.role,
    seq: getSeq()
  }
}

function ctlSendCmd(req){
  var jsonStr = JSON.stringify(req);
  log.info("[TAG-CTL] ctlSendCmd->req:"+jsonStr);
  sendCustomMessage(g_data.classInfo.cmd_group_id, jsonStr, "CTRL");
}

// 开始上课
function ctlStartClass(){
  var req = ctlGetCom("control");
  req["data"] = {
    action: "class_begin"
  }
  ctlSendCmd(req);
}
// 下课
function ctlEndClass(){
  var req = ctlGetCom("control");
  req["data"] = {
    action: "class_end"
  }
  ctlSendCmd(req);
}

// 请求权限
function ctlRequestRights(rights){
  var req = ctlGetCom("control");
  req["data"] = {
    action: "apply",
    rights: rights,
    objectId: [g_data.userId]
  }
  ctlSendCmd(req);
}

// 设置权限
function ctlSetRights(enable, rights, ids){
  var req = ctlGetCom("control");
  req["data"] = {
    action: (enable ? "on" : "off"),
    rights: rights,
    objectId: ids
  }
  ctlSendCmd(req);
}

// 控制
function ctlControl(action, ids){
  var req = ctlGetCom("control");
  req["data"] = {
    action: action,
    objectId: ids
  }
  ctlSendCmd(req);
}

// 设置角色
function ctlSetRole(role, ids){
  var req = ctlGetCom("control");
  req["data"] = {
    action: "grant",
    objectId: ids,
    ob_role: role
  }
  ctlSendCmd(req);
}

// 设置布局
function ctlSetLayout(idx){
  var req = ctlGetCom("control");
  req["data"] = {
    action: "layout_change",
    layout: idx
  }
  ctlSendCmd(req);
}

// 主屏控制
function ctlDisplayMainScreen(show, content){
  var req = ctlGetCom("control");
  req["data"] = {
    action: (show ? "content_show" : "content_hide"),
    content: content
  }
  ctlSendCmd(req);
}

// 播片状态
function ctlPlayVideo(play, url, time){
  var req = ctlGetCom("Media");
  req["data"] = {
    Media_address: url,
    time: time,
    action: (play ? "play" : "stop")
  }
  ctlSendCmd(req);
}


// 处理信念
function ctlProcessCmd(data, sender){
  var req = JSON.parse(data);
  if (req.type == "control"){   // 控制信令
    ctlProcessControlCmd(req.data, sender);
  }else if (req.type == "Media"){  // 播片信令
  }else if (req.typ == "tools"){  // 组件信令
  }
}

// 处理控制信令
function ctlProcessControlCmd(req, sender){
  if (req.action == "apply"){   // 请求权限信令
    var handsArr = g_data.handupStu;
    if (handsArr.indexOf(sender) == -1){
      handsArr.push(sender);
      g_data.handupStu = handsArr;
      sendIpcMessage("CTL:Status", sender);
    }
  }else if (req.action == "on"){    // 授权信令
    if (req.objectId.indexOf(g_data.userId) != -1){
      sendIpcMessage("CTL:Control", true, req.rights);
    }
  }else if (req.action == "off"){   // 禁用信令
    if (req.objectId.indexOf(g_data.userId) != -1){
      sendIpcMessage("CTL:Control", false, req.rights);
    }
  }else if (req.action == "mutemsg"){ // 禁言
    if (req.objectId.indexOf(g_data.userId) != -1){
      g_data.sendMsg = false;
      reportEvent(g_data.classId, "slience");
    }
  }else if (req.action == "unmutemsg"){ // 解除禁言
    if (req.objectId.indexOf(g_data.userId) != -1){
      g_data.sendMsg = true;
      reportEvent(g_data.classId, "del_slience");
    }
  }else if (req.action == "kickoff"){   // 被踢
    if (req.objectId.indexOf(g_data.userId) != -1){
      sendIpcMessage("CTL:KickOff", sender);
    }
  }else if (req.action == "hand_up"){
    if (sender != g_data.userId) sendIpcMessage("CTL:HandUp", true, req.objectId);
  }else if (req.action == "hand_down"){
    if (sender != g_data.userId) sendIpcMessage("CTL:HandUp", false, req.objectId);
  }else if (req.action == "class_begin"){ // 上课
    if (sender != g_data.userId) sendIpcMessage("CTL:Class", true);
  }else if (req.action == "class_end"){   // 下课
    if (sender != g_data.userId) sendIpcMessage("CTL:Class", false);
  }else if (req.action == "grant"){ // 角色信令
  }else if (req.action == "layout_change"){ // 布局信令
  }else if (req.action == "content_show"){  // 主屏显示
  }else if (req.action == "content_hide"){  // 主屏隐藏
  }
}
