

let set_app = new Vue({
  el: '#set_app',
  mounted: function () {
    if (!g_data.isClassEnter){ // 未进入课堂时打开设备测试
      sendIpcMessage('DEVICES:MIC', true),
      sendIpcMessage('DEVICES:CAMERA', true);
    }
    sendIpcMessage('DEVICES:QUERY', 0),
    this.initSlider();

    window.onbeforeunload = this.onWindowUnload;
  },
  data:{
    cameras: [],
    mics: [],
    speakers: [],
    local_volume: 0,
    cur_select_camera_id: -1,
    is_beauty_enable: g_data.beauty,
    is_mirror_enable: g_data.mirror,
    is_music_playing: false,
    is_camera_enable: false,
    is_mic_enable: false
  },
  created: function(){
    //this.initSlider();
  },
  methods: {
    /** 窗口事件响应 */
    closeWindow: function () {
      sendIpcMessage('ComWin:Sys', 'close');
    },
    onWindowUnload: function(){
      sendIpcMessage('DEVICES:SPEAKER', false);
      sendIpcMessage('DEVICES:MIC', false);
      sendIpcMessage('DEVICES:CAMERA', false);

      log.info("[TAG-SET] onWindowUnload->classid: "+g_data.classId+", isEnter: "+g_data.isClassEnter);
      if (0 != g_data.classId && !g_data.isClassEnter){
        sendIpcMessage('WIN_CLASS:ACTIVE', g_data.classId, {});
      }
    },
    /** 音视频事件处理 */
    onDeviceList: function(speakers, mics, cameras){
      this.cameras = cameras;
      this.mics = mics;
      this.speakers = speakers;
      this.is_camera_enable = this.cameras && this.cameras[0].id!=0;
      this.is_mic_enable = this.mics && this.mics[0].id!=0;
    },
    onLocalVolume: function(volume){
      this.local_volume = volume;
    },
    onLocalVideoData: function(width, height, rotation, data){
      if (this.cur_select_camera_id != 0){
        var jCanvas = $("#camera_view" );
        renderVideoData(jCanvas[0], width, height, data, false);     
      }
    },
    /** 业务处理 */
    switchBeauty: function(){
      this.is_beauty_enable = !this.is_beauty_enable;
      g_data.beauty = this.is_beauty_enable;
      if (this.is_beauty_enable){
        sendIpcMessage('SET:BEAUTY', 1, 5, 5, 5);
      }else{
        sendIpcMessage('SET:BEAUTY', 1, 0, 0, 0);
      }
    },
    startMusic: function(){
      this.is_music_playing = !this.is_music_playing;
      sendIpcMessage('DEVICES:SPEAKER', this.is_music_playing);
    },
    switchMirror: function(){
      this.is_mirror_enable = !this.is_mirror_enable;
      g_data.mirror = this.is_mirror_enable;
      sendIpcMessage("SET:MIRROR", this.is_mirror_enable);
    },
    getDevIdByName: function(type, name){
      var devList = [];
      if (type == 'camera'){
        devList = this.cameras;
      }else if (type == 'speaker'){
        devList = this.speakers;
      }else{
        devList = this.mics;
      }
      for (var i=0; i<devList.length; i++){
        if (name == devList[i].deviceName){
          return devList[i].deviceId;
        }
      }
      return name;
    },
    changeDevice: function(type, event){
      //alert("changeDevice->"+type+", "+event.target.value);
      var devId = this.getDevIdByName(type, event.target.value);
      log.info("[TAG-SET] changeDevice->type: "+type+", dev:"+event.target.value+"/"+devId);
      if (type == 'camera'){
        this.cur_select_camera_id = devId;
        if (0 == devId) this.clearVideoData();
      }
      sendIpcMessage('DEVICES:CHANGE', type, devId);
    },
    initSlider: function(){
      $('#input_speaker')[0].value = ""+g_data.speakerVolume;
      $('#input_speaker').css('background', 'linear-gradient(to right, #0A818C '+g_data.speakerVolume+'%, #DDDDDD 1%, #DDDDDD)');
      $('#speaker_range').text(g_data.speakerVolume+'%');
      $('#input_speaker').on('input', function(){
        $(this).css('background', 'linear-gradient(to right, #0A818C '+this.value+'%, #DDDDDD 1%, #DDDDDD)');
        $('#speaker_range').text(this.value+'%');
        g_data.speakerVolume = parseInt(this.value);
        sendIpcMessage('SET:SPEAKERVOLUME', g_data.speakerVolume);
      });
    },
    clearVideoData: function(){
      var jCanvas = $("#camera_view");
      var ctx = jCanvas[0].getContext("2d");
      ctx.clearRect(0, 0, jCanvas[0].width, jCanvas[0].height);
    }
  }
})


ipcRenderer.on('DEVICES:LIST', (event, speakers, mics, cameras)=>{
  set_app.onDeviceList(speakers, mics, cameras);
})
ipcRenderer.on('Audio:Local', (event, volume)=>{
  set_app.onLocalVolume(volume);
})
ipcRenderer.on('Video:Local', (event, width, height, rotation, data)=>{
  var decData = Buffer.from(data, 'base64');
  set_app.onLocalVideoData(width, height, rotation, decData);
})


Vue.config.errorHandler = (err, vm) =>{
  let { message, name, script, line, column, stack } = err;
  // 在vue提供的error对象中，script、line、column目前是空的。但这些信息其实在错误栈信息里可以看到。
  script = script ? script : '';
  line = line ? line : 0;
  column = line ? line : 0;
  // 解析错误栈信息
  let stackStr = stack ? stack.toString() : `${name}:${message}`;

  log.error("[TAG-SET] exception->"+stackStr);
}