const os = require('os');
const ntp = require(path.join(__dirname, '../js', 'ntp.js'))
const liteav = require(path.join(__dirname, '../js/module', 'trtc.js'))
// const process = require('process');

var is_kicked_off = false;
var shutdown_video = false;

let classroom_app = new Vue({
  el: '#classroom_app',
  mounted: function () {
    var package = require("../package.json");
    // this.version = package.version;
    this.version = "腾讯云互动课堂 桌面版v" + package.version;
    window.onbeforeunload = this.onWindowUnload;
  },
  data: {
    info_delay: "0ms",
    info_drop: "0%",
    info_cpu: "0%",
    info_net: '优良',
    info_head: '',
    info_time: '',
    logo_url: '',
    version: 'x.x.x',
    teacher: {
      user_id: "",
      nick: "teacher",
      icon: "",
      volume: 0,
      camera: true,
      mic: false,
      talk: true,
      speaker: true,
    },
    is_camera_enable: false,
    is_mic_enable: false,
    is_record: false,
    is_ready_quit: false,
    is_first_quit: true,
    is_show_dialog: false,
    is_show_msg: false,
    is_loading: true,
    is_ai_testing: false,
    is_share_screen: false,
    is_play_video: false,
    is_window_max: false,
    is_hand_up: false,
    has_new_hand_up: false,
    has_screen_share: false,
    show_screen_share: false,
    cur_share_mode: 0,
    dialog_title: '',
    dialog_msg: '',
    dialog_button: [],
    dialog_callback: 0,
    ai_status: "口语评测中",
    class_status: "上课",
    record_path: "",
    memlist: [],
  },
  created: function () {
    // 完成创建
    setRecvBoardMsgListener(this.onRecvBoardMsg);
    setRecvContainerMsgListener(this.onRecvContainerMsg);
    setRecvCtrlMsgListener(this.onRecvCtrlMsg);
    setRecvTextMsgListener(this.onRecvTextMsg);
  },
  methods: {
    /** 窗口事件响应 */
    onWindowLoad: function () {
      log.info("[TAG-CLASS] onWindowLoad->enter");
      initConfig();
      initUserConfig();
      var deviceTest = g_storage.getItem("deviceTest");
      //if (null == deviceTest || deviceTest.length < 1) {
        // 打开设备测试
      //  sendIpcMessage('WIN_SET:OPEN', g_data.classId);
      //} else {
        sendIpcMessage('WIN_CLASS:ACTIVE', g_data.classId);
      //}
    },
    onWindowActive: function () {
      log.info("[TAG-CLASS] onWindowActive->enter");
      g_data.isClassEnter = true;
      g_storage.setItem("deviceTest", "111");
      getCompanyInfo(g_data.companyId, (ret, json) => {//拉取机构信息
        log.info("[TAG-CLASS] getCompanyInfo->sdkAppId: " + JSON.stringify(json));
        if (ret) {
          g_data.sdkAppId = json.sdkappid;//3
          g_data.appName = json.name;
          g_data.appIconUrl = json.icon;

          //保存本地缓存
          g_storage.setItem('mode', g_data.mode);
          g_storage.setItem('companyId', g_data.companyId);
          g_storage.setItem('appName', json.name);
          g_storage.setItem('appIconUrl', json.icon);
          g_storage.setItem('userId', g_data.userId);
          g_storage.setItem('userToken', g_data.userToken);

          document.title = getUserAppName();

          getUserSig(g_data.userId, g_data.userToken, (ret, code, userSig) => {
            if (ret) {
              g_data.userSig = userSig;
              this.loginIM();
            } else {
              this.showErrorMessage("获取用户信息失败: " + code + ", " + userSig, true);
            }
          })
        } else {
          log.info("[TAG-CLASS] getCompanyInfo->fail : " + json.error_msg);
          this.showErrorMessage("获取机构信息失败: " + json.error_msg, true);
        }

      })


      // getUserSig(g_data.userId, g_data.userToken, (ret, code, userSig) => {
      //   if (ret) {
      //     //g_data.userSig = userSig;
      //     this.loginIM();
      //   } else {
      //     this.showErrorMessage("获取用户信息失败: " + code + ", " + userSig);
      //   }
      // })
    },
    closeWindow: function () {
      this.is_ready_quit = true;
      sendIpcMessage('ComWin:Sys', 'close');
    },
    minWindow: function () {
      sendIpcMessage('ComWin:Sys', 'min');
    },
    maxWindow: function () {
      sendIpcMessage('ComWin:Sys', 'max');
    },
    onDlgClick: function (index) {
      if (null != this.dialog_callback) {
        this.dialog_callback(index);
      }
      this.is_show_dialog = false;
      this.is_show_msg = false;
    },
    exitClass: function (callback) {
      if (this.timer) {
        clearInterval(this.timer);
      }
      if (this.hb_timer) {
        clearInterval(this.hb_timer);
      }
      this.enableCamera(false, false);
      liteav.exitRoom();
      this.is_ready_quit = true;
      this.is_first_quit = false;
      quitClass(g_data.classId, (ret, data) => {
        log.info("[TAG-CLASS] quitClass->id: " + g_data.classId + ", ret: " + ret + ", data:" + data);
        callback();
        //this.closeWindow();
      });
    },
    onWindowUnload: function (e) {
      log.info("[TAG-CLASS] onWindowUnload->enter with " + this.is_first_quit + "/quit: " + this.is_ready_quit);
      if (!this.is_ready_quit) {
        return;
      }
      if (this.is_first_quit) {
        this.is_first_quit = false;
        setTimeout(() => {
          this.is_show_dialog = true;
          this.showDialog('是否确定退出课堂', ['是', '否'], (index) => {
            if (index == 0) {
              logoutWebIm((result)=>{
                log.info("[TAG-CLASS] logout im ret: "+result);
                sendIpcMessage('ComWin:Sys', 'close');
                sendIpcMessage('QUITAPP');
              })
              this.exitClass(() => {
                log.info("[TAG-CLASS] exit class");
              });
            } else {
              this.is_first_quit = true;
            }
          });
        })
        e.returnValue = false;
        return false;
      } else {
        sendIpcMessage('QUITAPP');
      }
    },
    onWindowResume: function () {
      this.is_show_dialog = false;
    },
    onWindowMax: function () {
      this.is_window_max = true;
      log.info("[TAG-CLASS] onWindowMax->share: " + this.is_share_screen + ", share_mode: " + this.cur_share_mode);
      if (this.is_share_screen && this.cur_share_mode == 2) {
        //this.stopShareWindow();
        this.startShare();
      }
    },
    onWindowUnMax: function () {
      this.is_window_max = false;
      log.info("[TAG-CLASS] onWindowUnMax->share: " + this.is_share_screen + ", share_mode: " + this.cur_share_mode);
      if (this.is_share_screen && this.cur_share_mode == 2) {
        //this.stopShareWindow();
        this.startShare();
      }
    },
    openClassDocDlg: function () {
      sendIpcMessage('WIN_DOCLIST:OPEN', g_data.classId);
      this.is_show_dialog = true;
    },
    openMemberDlg: function () {
      this.has_new_hand_up = false;
      sendIpcMessage('WIN_MEMBER:OPEN', this.memlist.length+1);
      this.is_show_dialog = true;
    },
    openToolDlg: function () {
      sendIpcMessage('WIN_TOOL:OPEN', 0, false);
      this.is_show_dialog = true;
    },
    openSettingDlg: function () {
      sendIpcMessage('WIN_SET:OPEN', g_data.classId, true);
      this.is_show_dialog = true;
    },
    openAIDlg: function () {
      log.info("[TAG-CLASS] sendCustomCmdMsg->status: " + this.is_ai_testing);
      liteav.sendCustomCmdMsg(this.is_ai_testing ? 4 : 3, JSON.stringify({ userid: g_data.userId }), true, true);
      showAlertMsg(this.version, (idx)=>{});
    },
    handsUp: function (){
      this.is_hand_up = !this.is_hand_up
      reportEvent(g_data.classId, this.is_hand_up ? "hand_up" : "hand_down");
    },
    /** IMSDK 事件处理 */
    onRecvBoardMsg: function (data, groupId, sender) {
      log.info("[TAG-CLASS] recvBoardMsg->data: " + data);
      if (document.getElementById('board_iframe') && document.getElementById('board_iframe').contentWindow) {
        document.getElementById('board_iframe').contentWindow.addBoardData(data);
      }
    },
    onRecvContainerMsg: function (data, groupId, sender) {
      log.info("[TAG-CLASS] recvContainerMsg->data: " + data);
      curApp.container.notify(data);
    },
    onRecvCtrlMsg: function (data, groupId, sender) {
      log.info("[TAG-CLASS] IM:RecvCtrlMsg->recv data: " + data);
      ctlProcessCmd(data, sender);
    },
    onRecvTextMsg: function (data, timestamp, senderId, senderNick) {
      var imdata = {};
      imdata['isSend'] = (senderId == g_data.userId);
      imdata["send"] = senderId;
      imdata["sendNick"] = senderNick;
      imdata["content"] = data;
      imdata["time"] = timestamp;
      if (document.getElementById('board_iframe') && document.getElementById('board_iframe').contentWindow) {
        document.getElementById('board_iframe').contentWindow.clientUpdateIMmsg(imdata);
      }
    },
    onUserHandUp: function(isHandUp, userIdArr){
      if (!this.isTeacher()){ // 学生端忽略这个事件
        if (userIdArr.indexOf(g_data.userId) != -1){
          this.is_hand_up = isHandUp;
        }
        return;
      }
      for (id in userIdArr){
        var member = this.findUserInfo(id);
        member.is_hand_up = isHandUp;      
        if (isHandUp){
          this.has_new_hand_up = true;
        }else{
          for (let i = 0; i < this.memlist.length; i++) {
            if (this.memlist[i].is_hand_up) {
              return;
            }
          }
          this.has_new_hand_up = false;
        }
      }      
    },
    /** LITEAV事件处理 */
    onError: function (code, msg, arg) {
      if (code == -1301 || code == -1314 || code == -1315 || code == -1316) {  // camera error
        reportEvent(g_data.classId, "camera_close");
        this.is_camera_enable = false;
        var member = this.findUserInfo(g_data.userId);
        if (null != member) {
          member.camera = false;
        }
        this.showToast("打开摄像头失败: "+msg);
      } else if (code == -1302) {
        reportEvent(g_data.classId, "mic_close");
        this.is_mic_enable = false;
        var member = this.findUserInfo(g_data.userId);
        if (null != member) {
          member.mic = false;
        }
        this.showToast("打开麦克风失败: "+msg);
      }
      log.error("[TAG-CLASS] onError->code: " + code + ", msg: " + msg + ", arg: " + arg);
    },
    onStatistics: function (upLoss, downLoss, appCpu, systemCpu, rtt, receivedBytes, sentBytes) {
      this.info_delay = rtt + "ms";
      this.info_drop = upLoss + "%";
      this.info_cpu = systemCpu + "%";
    },
    onEnterRoom: function (elapse) {
      this.is_loading = false;
      document.getElementsByClassName('tic-container__menu')[0].style.visibility = 'visible';
      document.getElementsByClassName('tic-container__main-inner')[0].style.visibility = 'visible';
      log.info("[TAG-CLASS] onEnterRoom->elapse: " + elapse);
      liteav.setOnStatistics(this.onStatistics);
      if (this.isTeacher()){
        this.enableCamera(true);
        this.enableMic(true);
      }else{
        setTimeout(()=>{
          var up_user_count = this.memlist.length+1
          log.info("[TAG-CLASS] check video count: "+up_user_count+"/"+g_data.classInfo.max_member_limit);
          if (0 == g_data.classInfo.max_member_limit || up_user_count < g_data.classInfo.max_member_limit){
            this.enableCamera((g_data.classInfo.settings.auto_open_camera) ? true : false);
            this.enableMic((g_data.classInfo.settings.auto_open_mic) ? true : false);
          }else{
            this.showToast('已达到上麦人数上限!');
          }
        }, 1000);
      }
    },
    onUserEnter: function (id) {
      log.info("[TAG-CLASS] onUserEnter->id: " + id);
      sendIpcMessage("TRTC:Status", "enter", id, false);
      if (id != this.teacher.user_id) {
        this.addMember(id);
        sendIpcMessage("TRTC:Update", this.memlist.length+1)
      }
    },
    onUserExit: function (id) {
      log.info("[TAG-CLASS] onUserExit->id: " + id);
      sendIpcMessage("TRTC:Status", "enter", id, false);
      var member = this.findUserInfo(id);
      if (null != member) {
        member.camera = false;
        member.mic = false;
        this.clearVideoData(id);
      }
      if (id != this.teacher.user_id) {
        this.removeMember(id);
        sendIpcMessage("TRTC:Update", this.memlist.length+1)
      }
    },
    onUserVideoEvent: function (id, enable) {
      log.info("[TAG-CLASS] onUserVideoEvent->" + id + ": " + enable);
      if (id == g_data.userId) return;
      sendIpcMessage("TRTC:Status", "video", id, enable);
      var member = this.findUserInfo(id, enable);
      if (null != member) {
        log.info("[TAG-CLASS] onUserVideoEvent->set camera: " + enable);
        member.camera = enable;
      } else {
        log.warn("[TAG-CLASS] onUserVideoEvent->member not found: " + id);
      }
      if (enable) {
        liteav.startRemoteView(id);
        liteav.setRemoteVideoCallback(id, this.onRemoteVideoData);
      } else {
        this.clearVideoData(id);
      }
    },
    onUserAudioEvent: function (id, enable) {
      log.info("[TAG-CLASS] onUserAudioEvent->" + id + ": " + enable);
      if (id == g_data.userId) return;
      var member = this.findUserInfo(id, enable);
      if (null != member) {
        member.mic = enable;
      } else {
        log.warn("[TAG-CLASS] onUserVideoEvent->member not found: " + id);
      }
      sendIpcMessage("TRTC:Status", "audio", id, enable);
    },
    onUserSubStreamEvent: function (id, enable) {
      try {
        if (this.teacher.user_id == id) {
          log.info("setOnUserSubStreamAvailable->id: " + id + ", enable: " + enable);
          this.has_screen_share = enable;
          if (id != g_data.userid) { // 忽略
            sendIpcMessage("TRTC:Status", "screen", id, enable);
            if (enable) {
              liteav.startRemoteSubStreamView("" + id);
              liteav.setRemoteVideoCallback("" + id, this.onRemoteVideoData);
            }else{
              this.show_screen_share = false;
            }
          }
        }
      } catch (err) {
        log.err("[TAG-CLASS] onUserSubStreamEvent->err:  " + err);
      }

    },
    onVolume: function (id, volume) {
      //log.info("[TAG-CLASS] onVolume->"+id+":"+volume);
      try {
        if (id.length < 1) {
          id = g_data.userId;
          // 若设置窗口打开则转发音量
          var deviceWin = electron.remote.BrowserWindow.fromId(g_data.deviceTestId);
          if (null != deviceWin) {
            deviceWin.webContents.send('Audio:Local', volume);
          }
        }
        if (this.teacher.user_id.length > 0) { // 忽略设备测试页的事件
          this.updateUserVolume(id, 9 == volume ? 5 : Math.floor(volume / 2));
        }
      } catch (err) {
        log.error("[TAG-CLASS] onVolume->err: " + err);
      }
    },
    onLocalVideoData: function (id, type, width, height, timestamp, rotation, data) {
      //log.info("[TAG-CLASS] onLocalVideoData->"+id+":"+width+","+height);
      if (shutdown_video) return;
      try {
        if (type == 2) { // 屏幕分享数据
          log.info("[TAG-CLASS] onLocalVideoData->"+id+":"+width+","+height);
          this.renderVideoData(getSubVideoCanvas(), width, height, data, false, false);
          return;
        } else {
          if (!this.is_camera_enable) return;
          // 若设置窗口打开则转发本地视频数据
          if (0 != g_data.setDlgId) {
            var deviceWin = electron.remote.BrowserWindow.fromId(g_data.deviceTestId);
            if (null != deviceWin) {
              var buffer = Buffer.from(data);
              var encData = buffer.toString('base64');
              deviceWin.webContents.send('Video:Local', width, height, rotation, encData);
            }
          }
          var jCanvas = $("#" + g_data.userId);
          this.renderVideoData(jCanvas[0], width, height, data, process.platform=='darwin' ? !g_data.mirror : g_data.mirror);
        }
      } catch (err) {
        log.error("[TAG-CLASS] onLocalVideoData->err: " + err);
      }
    },

    onRecvCustomCmdMsg: function (userid, cmdid, seq, msg) {
      let data
      try {
        data = JSON.parse(msg);
        if (data.userid != g_data.userId) {
          return;
        }
        log.info("[TAG-CLASS] onRecvCustomCmdMsg->msg: " + msg + "/" + g_data.userId);
        if (data.type == 3) {
          var action = JSON.parse(data.action[0]);
          var result = action[0];
          if (result) {
            var score = result.pron_accuracy * result.pron_completion * (2 - result.pron_completion);
            this.is_show_dialog = true;
            this.showAlertMsg("评测结果【" + new Number(score).toFixed(2) + "】 准确率【" + new Number(result.pron_accuracy).toFixed(2)
              + "】 流畅度【" + new Number(result.pron_fluency * 100).toFixed(2) + "】 完整度【" + new Number(result.pron_completion * 100).toFixed(2) + "】");
          }
        } else if (data.type == 0) {
          if (data.cmdid == 7) {
            classroom_app.is_ai_testing = true;
          } else if (data.cmdid == 8) {
            classroom_app.is_ai_testing = false;
          }
        }
      } catch (err) {
        return;
      }
      // //AI测试
      // if (cmdid === 5) {
      //
      //   this.is_ai_testing = true;
      //   this.ai_status = "手势识别";
      // }
      // if (cmdid === 7) {
      //   this.is_ai_testing = true;
      //   this.ai_status = "口语评测";
      // }
      //
      // if (document.getElementById('board_iframe') && document.getElementById('board_iframe').contentWindow) {
      //   document.getElementById('board_iframe').contentWindow.addCustomCmdMsg({
      //     userid, cmdid, seq, msg
      //   });
      // }
      // try {
      //
      // } catch (err) {
      //   log.error("[TAG-CLASS] onRecvCustomCmdMsg->err: " + err);
      // }
    },

    onRemoteVideoData: function (id, type, width, height, timestamp, rotation, data) {
      //log.info("[TAG-CLASS] onRemoteVideoData type :"+ type+"  width  "+width+"  height "+height)
      if (shutdown_video) return;
      try {
        if (type == 2) { // 屏幕分享数据
          var canvas = getSubVideoCanvas();
          if (null == canvas && this.has_screen_share){
            this.show_screen_share = true;
            canvas = $("#screen_share")[0];
          }else{
            this.show_screen_share = false;
          }
          this.renderVideoData(canvas, width, height, data, false, false);
          return;
        } else {
          var member = this.findUserInfo(id);
          if (null != member && member.camera) {
            var jCanvas = $("#" + id);
            this.renderVideoData(jCanvas[0], width, height, data, false);
          }
        }
      } catch (err) {
        log.error("[TAG-CLASS] onRemoteVideoData->err: " + err);
      }
    },
    compareDev: function(devObj, devId){  // 对比设备(Windows下插拔事件devId实为名称)
      return null!=devObj && (devObj.id==devId || devObj.devicename==devId);
    },
    onDeviceChange: function(devId, devType, devState){
      log.info("[TAG-LITEAV] onDeviceChange->id: "+devId+", type: "+devType+", state: "+devState);
      try{
        if ((process.platform=='darwin' && 0==devState) || (process.platform!='darwin' && 1==devState)){
          log.info("[TAG-LITEAV] onDeviceChange->device remove: "+devId);
          if (devType == 0 && this.compareDev(liteav.getCurrentMicDevice(), devId)){  // mic
            this.enableMic(false);
            this.showToast("麦克风被移除!");
          }else if (devType == 1 && this.compareDev(liteav.getCurrentSpeakerDevice(), devId)){  // speaker
            this.showToast("扬声器被移除!");
          }else if (devType == 2 && this.compareDev(liteav.getCurrentCameraDevice(), devId)){
            this.enableCamera(false);
            this.showToast("摄像头被移除!");
          }else{
            log.info("[TAG-LITEAV] onDeviceChange->ignore type:"+devType);
          }
        }
      }catch(err){
        log.error("[TAG-CLASS] onDeviceChange->err:"+err);
      }
    },
    /** 业务相关 */
    isTeacher: function () {
      return isTeacherRole();
    },
    isSelf: function (id) {    // 判断是否对其有控制权限
      return (id == g_data.userId);
    },
    isClassStarted: function(id){
      return g_data.classInfo.class_status == "ing";
    },
    getClassInfoAndJoin: function () {
      if (Object.keys(g_data.classInfo).length == 0) {
        getClassInfo(g_data.classId, (result, json) => {
          if (!result) {
            this.showErrorMessage("获取课堂信息失败: " + json, true);
          } else {
            g_data.classInfo = json;
            this.startJoinClass(json);
          }
        });
      } else {
        this.startJoinClass(g_data.classInfo);
      }
    },
    loginIM: function () {
      loginWebIm(g_data.userId, g_data.userSig, (errCode, errInfo) => {
        if (errCode == 0) {
          this.getClassInfoAndJoin();
        }else{
          this.showErrorMessage(errInfo, true);
        }
      })
      liteav.init();
      liteav.setOnError(this.onError);
    },
    startJoinClass: function (json) {
      log.info("[TAG-LITEAV] start->enter class with id: " + g_data.classId + ", info: " + JSON.stringify(json));
      self = this;
      this.teacher.user_id = g_data.classInfo.teacher_id;
      if (g_data.userId == g_data.classInfo.teacher_id) {
        g_data.role = 'teacher';
      } else {
        log.info("[TAG-LITEAV] startJoinClass->teacher: " + g_data.classInfo.teacher_id + "/" + g_data.userId);
      }
      if (g_data.classInfo.class_status!='ing' & isDemoClient() && isTeacherRole()){
        this.showToast("由于您是第一个进入课堂的人，您的身份是老师");
      }
      getUserNickName(this.teacher.user_id, (nick) => {
        self.teacher.nick = nick;
      })
      enterClass(g_data.classId, (ret, data) => {
        if (ret) {
          this.info_head = "" + g_data.classId;
          this.updateClassStatus(g_data.classInfo.class_status);
          log.info("[TAG-LITEAV] enterClass->role: " + data.role);
          // 若昵称为空则重新获取
          if (g_data.nickName.length == 0){
            getUserNickName(g_data.userId, (nick)=>{
              g_data.nickName = nick;
            });
          }
          //g_data.role = data.role;
          g_storage.setItem('classId', g_data.classId);
          this.startEnterClass(g_data.classId);
          // 启动心跳定时器
          this.hb_timer = setInterval((class_id) => {
            heartBeat(class_id, (code, msg) => {
              if (code == 10216) {
                this.showErrorMessage("Token过期，请重新进入课堂!!", true);
              }else if(code == 10240){
                this.showErrorMessage("课堂出现异常，请重新进入课堂!!", true);
              }
            });
          }, 30000, g_data.classId);
        } else {
          this.showErrorMessage("加入课堂失败: " + data, true);
          log.error("enterClass->error: " + data);
        }
      });
    },
    showErrorMessage: function (message, isBackToLogin=false) {
      this.showAlertMsg(message, (index) => {
        if (isBackToLogin){
          sendIpcMessage('WIN_LOGIN:OPEN');
          sendIpcMessage('WIN_CLASS:CLOSE');
        }else{
          sendIpcMessage('QUITAPP');
        }        
      });
    },
    startEnterClass: function (classid) {
      g_data.subvideo = false;  // 重置辅流状态
      try{
        this.enterIMGroup(g_data.classInfo.chat_group_id, null);
        this.enterIMGroup(g_data.classInfo.cmd_group_id, (result) => {
          log.info("[TAG-CLASS] startEnterClass->enter im callback");
          if (result) {
            log.info("[TAG-CLASS] startEnterClass->sync ntp time");
          }
        });
        this.enterAVRoom(classid, "");
        initBoardSdk();
      }catch (err){
        log.error("[TAG-CLASS] startEnterClass->error: "+err);
      }
      log.info("[TAG-CLASS] startEnterClass->role: " + g_data.role + ", status: " + g_data.classInfo.class_status);
    },
    enterIMGroup: function (groupId, callback) {
      log.info("[TAG-CLASS] enterIMGroup->id: " + groupId);
      joinGroup(groupId, (errCode, errInfo) => {
        if (errCode == 10015 || errCode == 10010) {
          createGroup(groupId, (errCode, errInfo) => {
            if (errCode == 0) {
              if (null != callback) callback(true);
            } else if (errCode == 10013) {
              console.log("[TAG-CLASS] already Group Member");
              if (null != callback) callback(true);
            } else {
              this.showAlertMsg("进入群组失败: " + errCode + ", " + errInfo);
              if (null != callback) callback(false);
            }
          })
        } else {
          if (null != callback) callback(0 == errCode || 10013 == errCode);
        }
      });
    },
    /** LiteAV */
    enterAVRoom: function (roomId, privateMapKey) {
      var resolution = getResolution(g_data.classInfo.settings.resolution);
      log.info("[TAG-CLASS] enterAVRoom->roomId: " + roomId+", "+JSON.stringify(g_data.classInfo.settings));
      
      liteav.setOnEnterRoom(this.onEnterRoom);
      liteav.setVideoEncoderParam(resolution, g_data.classInfo.settings.fps, g_data.classInfo.settings.bitrate);
      liteav.enterRoom(g_data.sdkAppId, parseInt(roomId), privateMapKey, g_data.userId, g_data.userSig);
      liteav.setOnUserEnter(this.onUserEnter);
      liteav.setOnUserExit(this.onUserExit);
      liteav.setOnUserVideoAvailable(this.onUserVideoEvent);
      liteav.setOnUserAudioAvailable(this.onUserAudioEvent);
      liteav.setOnUserSubStreamAvailable(this.onUserSubStreamEvent);
      liteav.setVolumeCallback(this.onVolume);
      liteav.setLocalVideoCallback(this.onLocalVideoData);
      liteav.setOnRecvCustomCmdMsg(this.onRecvCustomCmdMsg);
      liteav.setOnDeviceChange(this.onDeviceChange);
      if (process.platform != 'darwin') {
        liteav.enableAudioVolumeEvaluation(500);
      } else {
        liteav.enableAudioVolumeEvaluation(500, 5);
      }
//
      g_data.speakerVolume = liteav.getCurrentSpeakerVolume();
      log.info("[TAG-CLASS] enterAVRoom->speakerVolume: "+g_data.speakerVolume);
      //this.setSpeakerVolume(g_data.speakerVolume);
    },
    enableCamera: function (enable, report = true) {
      log.info("[TAG-CLASS] enableCamera->enable: " + enable);
      this.is_camera_enable = enable;
      if (report){
        reportEvent(g_data.classId, this.is_camera_enable ? "camera_open" : "camera_close");
      }
      liteav.enableCamera(this.is_camera_enable);
      if (this.is_camera_enable) {        
        if (!isTeacherRole()) {
          this.addMember(g_data.userId);
        }
      } else {
        this.clearVideoData(g_data.userId);
      }
      var member = this.findUserInfo(g_data.userId);
      if (null != member) {
        member.camera = enable;
      }
    },
    enableMic: function (enable, report = true) {
      log.info("[TAG-CLASS] enableMic->enable: " + enable);
      this.is_mic_enable = enable;
      if (report){
        reportEvent(g_data.classId, this.is_mic_enable ? "mic_open" : "mic_close");
      }
      liteav.enableMic(this.is_mic_enable);
      if (!this.is_mic_enable) {
        this.updateUserVolume(g_data.userId, -1);
      }
      var member = this.findUserInfo(g_data.userId);
      if (null != member) {
        member.mic = enable;
      }
    },
    setCurDevice: function (list, cur) {
      if (list.length > 1) {
        for (var i = 0; i < list.length; i++) {
          if (list[i].devicename == cur.devicename) {
            var tmp = list[i];
            list[i] = list[0];
            list[0] = tmp;
            return;
          }
        }
      }
    },
    queryDevicesList: function () {
      var nodevice = {devicename: '<未选择>', id: 0};
      var speakers = liteav.getSpeakerDevicesList();
      var mics = liteav.getMicDevicesList();
      var cameras = liteav.getCameraDevicesList();

      var curSpeaker = liteav.getCurrentSpeakerDevice();
      var curMic, curCamera;
      if (this.is_mic_enable || !g_data.isClassEnter){
        curMic = liteav.getCurrentMicDevice();
      }else{
        mics.push(nodevice);
        curMic = nodevice;
      }
      if (this.is_camera_enable || !g_data.isClassEnter){
        curCamera = liteav.getCurrentCameraDevice();
      }else{
        cameras.push(nodevice);
        curCamera = nodevice;
      }

      this.setCurDevice(speakers, curSpeaker);
      this.setCurDevice(mics, curMic);
      this.setCurDevice(cameras, curCamera);

      log.info("[TAG-CLASS] queryDevicesList->speaker: " + JSON.stringify(speakers));
      log.info("[TAG-CLASS] queryDevicesList->mic: " + JSON.stringify(mics));
      log.info("[TAG-CLASS] queryDevicesList->camera: " + JSON.stringify(cameras));
      sendIpcMessage('DEVICES:LIST', speakers, mics, cameras);
    },
    changeDevices: function (device, id) {
      log.info("[TAG-LITEAV] changeDevices->device: " + device + ", id:" + id);
      if (device == 'speaker') {
        liteav.setCurrentSpeakerDevice(id);
      } else if (device == 'mic') {
        if (0 != id) liteav.setCurrentMicDevice(id);
        if (0 != id && !this.is_mic_enable) this.enableMic(true);
        if (0 == id && this.is_mic_enable) this.enableMic(false);
      } else if (device == 'camera') {
        if (0 != id) liteav.setCurrentCameraDevice(id);
        if (0 != id && !this.is_camera_enable) this.enableCamera(true);
        if (0 == id && this.is_camera_enable) this.enableCamera(false);
      } else {
        log.warn("[TAG-LITEAV] changeDevices->ignore device: " + device);
      }
    },
    enableSpeakerTest: function (enable) {
      if (enable) {
        var testFile = path.join(__dirname, "../", "mp3", "test.mp3");
        log.info("[TAG-LITEAV] enableSpeakerTest->play file:" + testFile);
        liteav.startSpeakerDeviceTest(testFile);
      } else {
        log.info("[TAG-LITEAV] enableSpeakerTest->stop");
        liteav.stopSpeakerDeviceTest();
      }
    },
    enableMicTest: function (enable) {
      // 若麦克风已打开直接忽略
      if (this.is_mic_enable) return;
      log.info("[TAG-LITEAV] enableMicTest->enable: " + enable);
      if (enable) {
        var self = this;
        liteav.setOnTestMicVolume(function (volume) {
          self.onVolume("", Math.floor(volume / 10));
        });
        liteav.startMicDeviceTest(100);
      } else {
        liteav.stopMicDeviceTest();
      }
    },
    enableCameraTest: function (enable) {
      // 若麦克风已打开直接忽略
      if (this.is_camera_enable) return;
      log.info("[TAG-LITEAV] enableCameraTest->enable: " + enable);
      if (enable) {
        liteav.setLocalVideoCallback(this.onLocalVideoData);
        liteav.startCameraDeviceTest();
        this.is_camera_enable = true;
      } else {
        this.is_camera_enable = false;
        liteav.stopCameraDeviceTest();
      }
    },
    setBeautyStyle: function (mode, beauty, white, ruddiness) {
      log.info("[TAG-LITEAV] setBeautyStyle->" + mode + ", " + beauty + ", " + white + ", " + ruddiness);
      liteav.setBeautyStyle(mode, beauty, white, ruddiness);
    },
    setSpeakerVolume: function (volume) {
      liteav.setCurrentSpeakerVolume(volume);
    },
    /**  */
    findMemberPos: function (id) {
      for (let i = 0; i < this.memlist.length; i++) {
        if (id == this.memlist[i].user_id) {
          return i;
        }
      }
      return -1;
    },
    scrollLeft: function (pos) {
      $(".tic-tab__list")[0].scrollLeft += pos;
    },
    startRecordInner: function (selectPath) {
      this.record_path = path.join(selectPath, "class_" + g_data.classId + "_" + formateDateTimeWithSep(new Date(), true, true, "", "", "") + (process.platform!='darwin' ? ".flv" : ".mp4"));
      if (process.platform != 'darwin') { //windows
        liteav.startRecord(document.title, 0, 0, 0, 0, 0, this.record_path);
      } else {//mac
        log.info("[TAG-CLASS] recordPath  " + this.record_path);
        liteav.startRecord(document.title, 0, 0, 0, 0, 0, this.record_path);
      }
      this.is_record = true;
    },
    startRecord: function () {

      liteav.sendCustomCmdMsg(10, "text", true, true);

      var recordDir = path.join((process.platform != 'darwin' ? process.env.USERPROFILE : process.env.HOME), 'TClass', "record");
      if (!fs.existsSync(recordDir)) {
        fs.mkdir(recordDir, function (err) {
          if (err) {
            this.is_show_dialog = true;
            this.showAlertMsg("创建录制文件目录失败");
          };
        });
      }
      if (this.is_record == false) {
        this.is_show_dialog = true;
        this.showDialog('是否需要启动本地录制功能并保存(' + recordDir + ')', ['开始录制', '修改保存目录并开始录制', '取消录制'], (index) => {
          if (index == 0) {
            this.startRecordInner(recordDir);
          } else if (index == 1) {
            showSelectDirDialog('选择录制文件存放目录', recordDir, (selectPath) => {
              this.startRecordInner(selectPath);
            })
          }
        });
      } else {
        this.is_show_dialog = true;
        this.showDialog('是否停止本地录制功能', ['是', '否'], (index) => {
          if (index === 0) {
            liteav.stopRecord();
            this.is_record = false;
          }
        });
      }
    },
    shareWindow: function (shareWin, fullWindow, isScreen) {
      if (fullWindow) {
        liteav.selectScreenCaptureTarget(isScreen ? 1 : 0, shareWin.id, shareWin.sourceName, 0, 0, 0, 0, false, true);
      } else {
        var clientWidth = $(document).width();
        var clientHeight = $(document).height();
        var dpr = window.devicePixelRatio || window.webkitDevicePixelRatio || window.mozDevicePixelRatio || 1;
        var border = 5;
        var top = this.is_window_max ? 210 : 160;

        $("#board_iframe")[0].style.border = "5px solid #8CBF26";
        liteav.selectScreenCaptureTarget(0, shareWin.id, shareWin.sourceName, border, top + border, (clientWidth - border * 2) * dpr, (clientHeight - top - border * 2) * dpr, false, false);
      }
      if (!this.is_share_screen) {
        liteav.startScreenCapture();
        reportEvent(g_data.classId, "screen_share_open");
        if (isDemo()) {
          sendTextMessage(g_data.classInfo.chat_group_id, '开启屏幕分享: ' + calcPlayAddr(true));
        }
        this.is_share_screen = true;
        g_data.subvideo = true;
        //addVideoFrame('屏幕分享', g_data.userId);
      }
    },
    stopShareWindow: function () {
      if (this.is_share_screen) {//关闭屏幕分享
        this.showDialog('是否关闭屏幕分享', ['是', '否'], (index) => {
          if (0 == index) {
            if (this.cur_share_mode == 2) {
              $("#board_iframe")[0].style.border = "none";
            }
            liteav.stopScreenCapture();
            reportEvent(g_data.classId, "screen_share_close");
            this.is_share_screen = false;
            g_data.subvideo = false;
          }
        });
      }
    },
    changeShareStatus: function () {
      if (this.is_share_screen) {//关闭屏幕分享
        this.stopShareWindow();
      } else {//打开屏幕分享
        if (this.is_play_video){
          this.showAlertMsg("请先关闭播片功能!");
          return;
        }
        //this.selectWindow();
        this.cur_share_mode = 0;
        this.startShare();
      }
    },
    startShare: function () {
      // this.is_share_screen = true;
      var sources = liteav.getScreenCaptureSources(120, 70, 20, 20);
      if (this.cur_share_mode == 0) {
        this.shareWindow(sources[0], true, true);
      } else {
        var appName = getUserAppName();
        for (var i = 0; i < sources.length; i++) {
          if (sources[i].sourceName == appName) {
            this.shareWindow(sources[i], this.cur_share_mode == 1, false);
            return;
          }
        }
        log.error("[TAG-CLASS] selectWindow->not found window: " + appName);
      }
    },
    selectWindow: function () {
      this.showDialog('请选择分享区域：', ['全屏', '全窗口', '内容大屏'], (index) => {
        if (-1 != index) {
          this.cur_share_mode = index;
          this.startShare();
        }
      });
    },
    addMember: function (id) {
      var idx = this.findMemberPos(id);
      if (-1 != idx) {
        log.warn("[TAG-CLASS] addMember->member already exist: " + id);
        return;
      }
      let member = {
        user_id: id,
        nick: "student",
        volume: 0,
        camera: false,
        mic: false,
        talk: false,
        speaker: true,
        hand_up: false
      }
      this.memlist.push(member);
      self = this;
      getUserNickName(id, (nick) => {
        var member = this.findUserInfo(id);
        if (null != member) {
          member.nick = nick;
        }
      })
    },
    removeMember: function (id) {
      var idx = self.findMemberPos(id);
      if (-1 != idx) {
        this.memlist.splice(idx, 1);
      }
    },
    ctlSwitchMic: function (id) {
      if (this.isSelf(id)) {
        this.enableMic(!this.is_mic_enable);
      } else {
        var idx = this.findMemberPos(id);
        if (-1 == idx) {
          log.error("[TAG-CLASS] ctlSwitchMic->not found: " + id);
          return;
        }
        if (this.isTeacher()) {
          this.memlist[idx].mic = !this.memlist[idx].mic;
          ctlSetRights(this.memlist[idx].mic, ["mic"], [id]);
          //reportEvent(g_data.classId, "apply", {user_id: id, operate: "mic", enable: this.memlist[idx].mic ? 1 : 0});
        } else {  // 本地禁音
          this.memlist[idx].speaker = !this.memlist[idx].speaker;
          log.info("[TAG-CLASS] muteRemoteAudio->id:" + id + ", enable: " + this.memlist[idx].speaker);
          liteav.muteRemoteAudio(id, !this.memlist[idx].speaker);
        }
      }
    },
    ctlSwitchCamera: function (id) {
      if (this.isSelf(id)) {
        this.enableCamera(!this.is_camera_enable);
        return;
      }
      var idx = this.findMemberPos(id);
      if (-1 == idx) {
        log.error("[TAG-CLASS] ctlSwitchCamera->not found: " + id);
        return;
      }
      this.memlist[idx].camera = !this.memlist[idx].camera;
      ctlSetRights(this.memlist[idx].camera, ["camera"], [id]);
      //reportEvent(g_data.classId, "apply", {user_id: id, operate: "camera", enable: this.memlist[idx].camera ? 1 : 0});
    },
    startClass: function () {
      // 上课或下课
      if (g_data.classInfo.class_status == "ing") {
        this.showDialog('是否确定要现在下课(下课后将直接退出课堂)', ['是', '否'], (index) => {
          if (0 == index) {

            endClass(g_data.classId, (ret, data) => {
              log.info("[TAG-CLASS] endClass->ret: " + ret + ", data: " + JSON.stringify(data));
              //ctlEndClass();
              curApp.end();
              this.enableCamera(false, false);
              liteav.exitRoom();
              this.clearAllVideo();
              this.showErrorMessage("课堂已结束!");
              //sendIpcMessage('WIN_CLASS:OPEN', ret, data);
            });
          }
        });
      } else {
        startClass(g_data.classId, (ret, data) => {
          log.info("[TAG-CLASS] startClass->ret: " + ret + ", data: " + JSON.stringify(data));
          if (ret) {
            curApp.start();
            ctlStartClass();
            this.updateClassStatus('ing');
          } else {
            this.showAlertMsg("错误: " + data.error_msg);
          }
        });
      }
    },
    showAlertMsg: function (message, callback) {
      this.showDialog(message, ['确定'], callback);
    },
    showToast: function(msg){
      setTimeout(function(){
        document.getElementsByClassName('toast-wrap')[0].getElementsByClassName('toast-msg')[0].innerHTML= msg;
        var toastTag = document.getElementsByClassName('toast-wrap')[0];
        toastTag.className = toastTag.className.replace(/toastAnimate/g, '');
        setTimeout(function(){
            toastTag.className = toastTag.className + ' toastAnimate';
        }, 100);
      },500);
    },
    showDialog: function (message, buttons, callback) {
      this.dialog_title = getUserAppName();
      this.dialog_msg = message,
        this.dialog_button = buttons;
      this.dialog_callback = callback;
      this.is_show_dialog = true;
      this.is_show_msg = true;
    },
    findUserInfo: function (id, created = true) {
      if (id == this.teacher.user_id) {
        return this.teacher;
      } else {
        var idx = this.findMemberPos(id);
        if (-1 != idx) {
          return this.memlist[idx];
        } else if (!created) {
          return null;
        }
        let member = {
          user_id: id,
          nick: "student",
          volume: 0,
          camera: false,
          mic: false,
          talk: false,
          speaker: true,
        }
        this.memlist.push(member);
        self = this;
        getUserNickName(id, (nick) => {
          var member = this.findUserInfo(id);
          if (null != member) {
            member.nick = nick;
          }
        })
        return member;
      }
    },
    updateUserVolume: function (id, volume) {
      var member = this.findUserInfo(id);
      if (null != member) {
        member.volume = volume;
      }
    },
    clearVideoData: function (id) {
      var jCanvas = $("#" + id);
      if (null != jCanvas[0]) {
        var ctx = jCanvas[0].getContext("2d");
        ctx.clearRect(0, 0, jCanvas[0].width, jCanvas[0].height);
      }
    },
    updateClassStatus: function (status) {
      log.info('[TAG-CLASS] updateClassStatus->status: ' + status + "/" + g_data.classInfo.class_status);
      g_data.classInfo.class_status = status;
      if ('ing' == g_data.classInfo.class_status) {
        this.class_status = '下课';
        this.timer = setInterval((classid) => {
          g_data.classInfo.duration_time++;
          var hour = Math.floor(g_data.classInfo.duration_time / 3600);
          var min = Math.floor((g_data.classInfo.duration_time % 3600) / 60);
          var sec = Math.floor(g_data.classInfo.duration_time % 60);
          this.info_time = g_data.classInfo.class_topic+" 已经开课: "+(hour < 9 ? '0' + hour : hour) + ':' + (min < 9 ? '0' + min : min) + ':' + (sec < 9 ? '0' + sec : sec);
        }, 1000, g_data.classId);
      } else if ('end' == g_data.classInfo.class_status) {
        if (this.timer) {
          clearInterval(this.timer);
          this.timer = null;
        }
        this.enableCamera(false, false);
        liteav.exitRoom();
        this.clearAllVideo();
        this.showErrorMessage("课堂已结束!");
      } else {
        this.class_status = '上课';
      }
    },
    clearAllVideo: function(){
      shutdown_video = true;
      this.clearVideoData(g_data.userId);
      for (let i = 0; i < this.memlist.length; i++) {
        this.clearVideoData(this.memlist[i].user_id);
      }
    },
    renderVideoData: function (c, width, height, data, mirror, crop=true) {
      if (null == c) return;
      resizeCanvas(c);
      var ctx = c.getContext("2d");
      //离屏渲染
      var tempData = data.slice();
      const arr = new Uint8ClampedArray(tempData);
      let imageData = new ImageData(arr, width, height);

      var offscreenCanvas = document.createElement('canvas');
      var offscreenContext = offscreenCanvas.getContext('2d');

      offscreenCanvas.width = width;
      offscreenCanvas.height = height;
      offscreenContext.putImageData(imageData, 0, 0);

      //黑边方式
      var top = 0, left = 0;
      //log.info("[XX] renderVideoData->"+width+"x"+height+", c: "+c.width+"x"+c.height);
      if (crop){  // 裁剪模式
        if (offscreenCanvas.width / offscreenCanvas.height < c.width / c.height) { //最长边为基准缩放
          var x = c.width / offscreenCanvas.width;
          top = (offscreenCanvas.height - c.height / x) / 2;
        } else {
          var x = c.height / offscreenCanvas.height;
          left = (offscreenCanvas.width - c.width / x) / 2;
        }
        sw = c.width / x;
        sh = c.height / x;
        if (mirror) {
          ctx.translate(c.width / 2 - c.width * -1 / 2, 0);
          ctx.scale(-1, 1);
          ctx.drawImage(offscreenCanvas, left, top, sw, sh, 0, 0, c.width, c.height);
          // 坐标参考还原
          ctx.setTransform(1, 0, 0, 1, 0, 0);
        } else {
          ctx.drawImage(offscreenCanvas, left, top, sw, sh, 0, 0, c.width, c.height);
        }
      }else{  // 黑边模式
        if (offscreenCanvas.width / offscreenCanvas.height > c.width / c.height) { //最长边为基准缩放
          var x = c.width / offscreenCanvas.width;
          top = (c.height - offscreenCanvas.height * x) / 2;
        } else {
          var x = c.height / offscreenCanvas.height;
          left = (c.width - offscreenCanvas.width * x) / 2;
        }
        sw = offscreenCanvas.width * x;
        sh = offscreenCanvas.height * x;
        ctx.fillRect(0, 0, c.width, c.height);
        if (mirror) {
          ctx.translate(c.width / 2 - c.width * -1 / 2, 0);
          ctx.scale(-1, 1);
          ctx.drawImage(offscreenCanvas, 0, 0, offscreenCanvas.width, offscreenCanvas.height, left, top, sw, sh);
          // 坐标参考还原
          ctx.setTransform(1, 0, 0, 1, 0, 0);
        } else {
          ctx.drawImage(offscreenCanvas, 0, 0, offscreenCanvas.width, offscreenCanvas.height, left, top, sw, sh);
        }
      }
    }
  }
})

ipcRenderer.on('start', function (e, data) {
  try{
    classroom_app.onWindowLoad();
    if (null != g_data.configUrl && g_data.configUrl.length > 0) {
      StreamDownload.downloadFile(g_data.configUrl, path.join(getConfigDir(), 'config.json'), (event, percentAge) => {
        if (event == 'progress') {
          log.info("[TAG-CLASS] start->process: " + percentAge);
        } else if (event == 'finished') {
          initUserConfig();
          document.title = getUserAppName();
          classroom_app.logo_url = getUserAppIcon();
        }
      })
    } else {
      document.title = getUserAppName();
      classroom_app.logo_url = getUserAppIcon();
    }
  }catch(err){
      log.error("[TAG-CLASS] start event->err: "+err);
  }
})

ipcRenderer.on('join', function (e, data) {
  classroom_app.onWindowActive();
})

ipcRenderer.on('resume', function (e, data) {
  classroom_app.onWindowResume();
})

ipcRenderer.on('max', function (e, data) {
  classroom_app.onWindowMax();
})

ipcRenderer.on('unmax', function (e, data) {
  classroom_app.onWindowUnMax();
})

// 应用网络课件
ipcRenderer.on('CLASS:OpenDoc', (e, doc) => {
  var docUrl = doc.is_transcode ? doc.transcode_result : doc.doc_url;
  log.info("[TAG-CLASS] CLASS:OpenDoc->url: " + docUrl);
  reportEvent(g_data.classId, "open_doc", docUrl);
  addClassDoc(doc);
})

// 应用网络课件
ipcRenderer.on('TOOL:PLAYVIDEO', (e, videoPath) => {
  if (!classroom_app.is_share_screen) {
    log.info("[TAG-CLASS] TOOL:PLAYVIDEO" + videoPath);

    startPlayVideo(videoPath, 0, (pos, total) => {
      setVideoLength(pos, total);
    });
    if (!g_data.subvideo) {
      addVideoFrame(path.basename(videoPath), g_data.userId, true);
      g_data.subvideo = true;
    }
  } else {
    classroom_app.showAlertMsg("请先关闭屏幕分享!");
  }
})


//处理查询设备测试请求
ipcRenderer.on('DEVICES:QUERY', (e, data) => {
  classroom_app.queryDevicesList();
})
ipcRenderer.on('DEVICES:CHANGE', (e, device, id) => {
  classroom_app.changeDevices(device, id);
})
ipcRenderer.on('DEVICES:SPEAKER', (e, enable) => {
  classroom_app.enableSpeakerTest(enable);
})
ipcRenderer.on('DEVICES:MIC', (e, enable) => {
  classroom_app.enableMicTest(enable);
})
ipcRenderer.on('DEVICES:CAMERA', (e, enable) => {
  classroom_app.enableCameraTest(enable);
})

// 处理音频设置
ipcRenderer.on('SET:SPEAKERVOLUME', (e, volume) => {
  classroom_app.setSpeakerVolume(volume);
})
ipcRenderer.on('SET:MICVOLUME', (e, volume) => {
  //classroom_app.setMicVolume(volume);
})
ipcRenderer.on('SET:BEAUTY', (e, mode, beauty, white, ruddiness) => {
  classroom_app.setBeautyStyle(mode, beauty, white, ruddiness);
})

// 发送IM消息处理
ipcRenderer.on('IM:SENDTEXTMSG', (e, groupId, data, ext) => {
  sendTextMessage(groupId, data, ext);
})
ipcRenderer.on('IM:SENDCUSTOMMSG', (e, groupId, data, ext) => {
  // alert("custom " + data + " " + ext);
  sendCustomMessage(groupId, data, ext);
})

// 课堂工具
ipcRenderer.on('TOOL:SCREEN', (e, enable) => {
  log.info('[TAG-CLASS] shareScreen->enter');
  if (!g_data.subvideo) {
    classroom_app.selectWindow();
    // var clientWidth = $(document).width();
    // var clientHeight = $(document).height();
    // var dpr = window.devicePixelRatio || window.webkitDevicePixelRatio || window.mozDevicePixelRatio || 1;
    // var sources = liteav.getScreenCaptureSources(120, 70, 20, 20);
    // var shareWin = sources[0];
    // var appName = getUserAppName();
    // for (var i=0; i<sources.length; i++){
    //   if (sources[i].sourceName == appName){
    //     shareWin = sources[i];
    //     break;
    //   }
    // }
    // liteav.selectScreenCaptureTarget(0, shareWin.id, shareWin.sourceName, 0, 0, clientWidth*dpr, clientHeight*dpr, false, true);
    // liteav.startScreenCapture();
    // if (process.platform != 'darwin'){
    //   var sources = liteav.getScreenCaptureSources(120, 70, 20, 20);
    //   var wholeScreen = sources[0];
    //   log.info("[TAG-CLASS] selectScreenCaptureTarget->title: "+document.title+", "+clientWidth*dpr+"x"+clientHeight*dpr);
    //   liteav.selectScreenCaptureTarget(0, 0, document.title, 0, 0, clientWidth*dpr, clientHeight*dpr);
    //   liteav.startScreenCapture();
    // }else{
    //   var sources = liteav.getScreenCaptureSources(120, 70, 20, 20);
    //   var wholeScreen = sources[0];
    //   //alert('开始分享 ' + wholeScreen.sourceName);
    //   liteav.selectScreenCaptureTarget(0, liteav.getCurrentWindowID(), document.title, 0, 0, 0, 0);
    //   liteav.startScreenCapture();
    // }
  } else {
    if (classroom_app.is_share_screen) {
      stopScreenShare();
    } else {
      classroom_app.showAlertMsg("请先关闭播片功能!");
    }
  }
})

// 信令设置状态
ipcRenderer.on('CTL:Control', (e, enable, rights) => {
  log.info("[TAG-CLASS] CTL:Control->rights:" + rights + ", enable:" + enable);
  if (rights.indexOf("camera") != -1) {
    classroom_app.enableCamera(enable);
  }
  if (rights.indexOf("mic") != -1) {
    classroom_app.enableMic(enable);
    //operateDevice(g_data.classId, "mic", enable ? 1 : 0);
  }
})

// 被踢
ipcRenderer.on('CTL:KickOff', (e, user) => {
  log.info("[TAG-CLASS] CTL:KicoOff->kicked by " + user);
  //sendIpcMessage('WIN_CLASS:CLOSE', ret, data);
  //sendIpcMessage('WIN_CLASS:SHOW', false);
  is_kicked_off = true;
  classroom_app.exitClass(function () {
    classroom_app.showErrorMessage("您已被踢出课堂", true)
  });
})

// 上课
ipcRenderer.on('CTL:Class', (e, start) => {
  log.info("[TAG-CLASS] CTL:Class->start class: " + start);
  if (start) {
    classroom_app.updateClassStatus('ing');
  } else {
    classroom_app.updateClassStatus("end");
  }
})

// 更新成员举手状态
ipcRenderer.on('CTL:HandUp', (e, isHandUp, userId)=>{
  log.info("[TAG-CLASS] CTL:HandUp->hand_up: "+isHandUp+"/"+userId);
  classroom_app.onUserHandUp(isHandUp, userId);
})

//播片能力
var maxVideo = 0;
var playPath = "";
var playPos = 0;
var playing = false;
function startPlayVideo(path, repeat, callback) {
  log.info("willguo startPlayVideo play path " + path+", playing: "+playing);
  playPath = path;
  reportEvent(g_data.classId, "media_open", path);
  classroom_app.is_play_video = true;
  liteav.startVodPlay(path, 0);
  liteav.setVodPlayerStoped(() => {
    log.info("[TAG-CLASS] setVodPlayerStoped->stoped");
    playPos = 0;
    playing = false;
    classroom_app.is_play_video = false;
    callback(0, 0);
  })
  liteav.setVodPlayerStarted((length) => {
    log.info("[TAG-CLASS] setVodPlayerStarted->started");
    playing = true;
    maxVideo = length;
    callback(0, length);
  })
  liteav.setVodPlayerProgress((pos) => {
    callback(pos, maxVideo);
  })
  liteav.setVodPlayerError((err)=>{
    log.error("[TAG-CLASS] setVodPlayerError->error: "+err);
    playPos = 0;
    playing = false;
    classroom_app.is_play_video = false;
    callback(0, 0);
  })
}

function setVideoPos(pos) {
  playPos = pos;
  liteav.seekVodPlay(pos);
}

function stopPlayVideo() {
  reportEvent(g_data.classId, "media_close");
  liteav.stopVodPlay();
  classroom_app.is_play_video = false;
}


function pausePlayVideo() {
  log.info("[TAG-LITEAV] pausePlayVideo->enter");
  liteav.pauseVodPlay();
}

function resumePlayVideo() {
  log.info("[TAG-LITEAV] resumePlayVideo->enter");
  if (playing) {
    liteav.resumeVodPlay();
  } else {
    liteav.startVodPlay(playPath, 0);
    liteav.seekVodPlay(playPos);
  }
}

function stopScreenShare() {
  classroom_app.stopShareWindow();
}

function showxDialog(message, buttons, callback) {
  classroom_app.showDialog(message, buttons, callback);
}

function showAlertMsg(message) {
  classroom_app.showAlertMsg(message);
}

function showErrorMsg(message){
  classroom_app.showErrorMessage(message);
}

function reportTime() {
  ntp.getNetworkTime('time1.cloud.tencent.com', 123, (err, date) => {
    if (null == err) {
      var boardSdk = document.getElementById('board_iframe').contentWindow.boardSDK;
      var data = {
        type: 1008,
        avsdk_time: liteav.getTickCount(),
        board_time: boardSdk.getBoardTimestamp(),
        time_line: date
      }
      sendCustomMessage(g_data.classInfo.cmd_group_id, JSON.stringify(data), 'TXConferenceExt');
      log.info("[TAG-CLASS] reportTime->msg: " + JSON.stringify(data));
    } else {
      log.info("[TAG-CLASS] reportTime->ntp err: " + err);
    }
  })
}

window.showMessageBox = showxDialog;
