const saas = require(path.join(__dirname, '../js/module', 'saas.js'))


let loading_app = new Vue({
    el: '#loading_app',
    mounted: function(){
        this.onWindowLoad();
    },
    data: {
        is_loading: true,
        is_show_msg: false,
        dialog_title: '',
        dialog_msg: '',
        dialog_button: [],
        dialog_callback: 0,
    },
    created: function(){

    },
    methods: {
        /** 窗口事件 */
        onWindowLoad: function(){
            saas.syncInfo(g_data.companyId, g_data.classId, g_data.userId, g_data.userToken, (ret, json)=>{
                if (!ret){
                    this.onError(-100, json);
                    return;
                }
                log.info('[TAG-LOAD] initSaas->rsp: '+JSON.stringify(json));
                g_data.sdkAppId = saas.sdkAppId;
                g_data.appName = saas.appName;
                g_data.appIconUrl = saas.iconUrl;
                g_data.token = saas.token;
                g_data.userSig = saas.userSig;
                g_data.classInfo = json;

                g_storage.setItem('mode', g_data.mode);
                g_storage.setItem('companyId', g_data.companyId);
                g_storage.setItem('appName', json.name);
                g_storage.setItem('appIconUrl', json.icon);
                g_storage.setItem('userId', g_data.userId);
                g_storage.setItem('userToken', g_data.userToken);
                g_storage.setItem('classId', g_data.classId);
                sendIpcMessage('WIN_CLASS:RELOAD', json.class_type);
            });
        },

        /** 内部方法 */
        showDialog: function(message, buttons, callback){
            this.dialog_title = saas.appName;
            this.dialog_msg = message;
            this.dialog_button = buttons;
            this.dialog_callback = callback;
            this.is_show_msg = true;
        },
        showErrorMessage: function(message, isBackLogin=false){
            this.showDialog(message, ['确定'], (index)=>{
                if (isBackLogin){
                    sendIpcMessage('WIN_LOGIN:OPEN');
                    sendIpcMessage('WIN_CLASS:CLOSE');
                }else{
                    sendIpcMessage('QUITAPP');
                }
            });
        },
        

        /** 内部回调 */
        onError: function(code, msg){
            log.error('[TAG-LOAD] onError->code: '+code+", msg: "+msg);
            this.is_loading = false;
            this.showErrorMessage('失败: '+msg, true);
        },
        onDlgClick: function (index) {
            if (null != this.dialog_callback) {
              this.dialog_callback(index);
            }
            this.is_show_msg = false;
        },
    }
})