var bClosed = false;
var speaker_start = false;

// 获取成员列表
ipcRenderer.on('start', function (event, classid) {
  bClosed = false;
  sendIpcMessage('DEVICES:QUERY', 0);
  sendIpcMessage('DEVICES:MIC', true);
  sendIpcMessage('DEVICES:CAMERA', true);

  $('#input_mirror').attr('checked',  g_data.mirror);
  $('#input_beauty').attr('checked', g_data.beauty);
  $('#input_speaker').val(g_data.speakerVolume);
  $('#input_speaker').css('background', 'linear-gradient(to right, #0A818C '+g_data.speakerVolume+'%, #DDDDDD 1%, #DDDDDD)');
  $('#speaker_range').text(g_data.speakerVolume+'%');
  $('#input_mic').val(g_data.micVolume);
  $('#input_mic').css('background', 'linear-gradient(to right, #0A818C '+g_data.micVolume+'%, #DDDDDD 1%, #DDDDDD)');
  $('#mic_range').text(g_data.micVolume+'%');
});

ipcRenderer.on('Video:Local', (event, width, height, rotation, data)=>{
  if (bClosed) return;
  var decData = Buffer.from(data, 'base64');
  //log.info("[TAG-SET] Video:Local->len: "+data.length+"=>"+decData.length);
  var c = document.getElementById("camera_view");
  var ctx = c.getContext("2d");
  resizeCanvas(c);
  var tempData = decData.slice();
  const arr = new Uint8ClampedArray(tempData);
  let imageData = new ImageData(arr, width, height);
  var offscreenCanvas = document.createElement('canvas');
  var offscreenContext = offscreenCanvas.getContext('2d');
  offscreenCanvas.width = width;
  offscreenCanvas.height = height;
  offscreenContext.putImageData(imageData, 0, 0);

  var top = 0, left = 0;
  if (offscreenCanvas.width / offscreenCanvas.height > c.width/c.height) { //最长边为基准缩放
    var x = c.width / offscreenCanvas.width;
    top = (c.height - offscreenCanvas.height * x) / 2;
  } else {
    var x = c.height / offscreenCanvas.height;
    left = (c.width - offscreenCanvas.width * x) / 2;
  }

  sw = offscreenCanvas.width * x;
  sh = offscreenCanvas.height * x;

  if (g_data.mirror){
    ctx.translate(c.width / 2 - c.width * -1 / 2, 0);
    ctx.scale(-1, 1);
    ctx.drawImage(offscreenCanvas, 0, 0, offscreenCanvas.width, offscreenCanvas.height, left, top, sw, sh);
    // 坐标参考还原
    ctx.setTransform(1, 0, 0, 1, 0, 0);
  }else{
    ctx.drawImage(offscreenCanvas, 0, 0, offscreenCanvas.width, offscreenCanvas.height, left, top, sw, sh);
  }
});

ipcRenderer.on('Audio:Local', (event, volume)=>{
  //log.info("[TAG-SET] Audio:Local->volume:"+volume);
  $("#mic_volume span").css("width", (volume*11)+"%");
});

ipcRenderer.on('DEVICES:LIST', (event, speakers, mics, cameras)=>{
  for (i=0; i<speakers.length; i++){
    $("#speaker_id").append("<option value='"+speakers[i]+"'>"+speakers[i]+"</option>");
  }
  for (i=0; i<mics.length; i++){
    $("#mic_id").append("<option value='"+mics[i]+"'>"+mics[i]+"</option>");
  }
  for (i=0; i<cameras.length; i++){
    $("#camera_id").append("<option value='"+cameras[i]+"'>"+cameras[i]+"</option>");
  }
  // 处理选择事件
  $("#speaker_id").change(function(){
    sendIpcMessage('DEVICES:CHANGE', 'speaker', $(this).children('option:selected').val());
  });
  $("#mic_id").change(function(){
    sendIpcMessage('DEVICES:CHANGE', 'mic', $(this).children('option:selected').val());
  });
  $("#camera_id").change(function(){
    sendIpcMessage('DEVICES:CHANGE', 'camera', $(this).children('option:selected').val());
  });
})

$(".img-close").on('click', function () {
  bClosed = true;
  sendIpcMessage('DEVICES:SPEAKER', false);
  sendIpcMessage('DEVICES:MIC', false);
  sendIpcMessage('DEVICES:CAMERA', false);
  sendIpcMessage('WIN_SET:CLOSE', g_data.classInfo.chat_group_id, g_data.userId);
});

$("#trans-commit").on('click', function(){
  alert("submit");
});

$(".speaker_test").on('click', function(){
  speaker_start = !speaker_start;
  log.info("[TAG-SET] startSpeakerTest->enable: "+speaker_start);
  if (speaker_start){
    $('.speaker_img').attr("style", 'content:url(../img/speaker_test_on.png)');
    sendIpcMessage('DEVICES:SPEAKER', true);
  }else{
    $('.speaker_img').attr("style", 'content:url(../img/speaker_test_off.png)');
    sendIpcMessage('DEVICES:SPEAKER', false);
  }
});

$('#input_mic').on('change', function(){
  $(this).css('background', 'linear-gradient(to right, #0A818C '+this.value+'%, #DDDDDD 1%, #DDDDDD)');
  $('#mic_range').text(this.value+'%');
  g_data.micVolume = parseInt(this.value);
  sendIpcMessage('SET:MICVOLUME', g_data.micVolume);
});
$('#input_speaker').on('change', function(){
  $(this).css('background', 'linear-gradient(to right, #0A818C '+this.value+'%, #DDDDDD 1%, #DDDDDD)');
  $('#speaker_range').text(this.value+'%');
  g_data.speakerVolume = parseInt(this.value);
  sendIpcMessage('SET:SPEAKERVOLUME', g_data.speakerVolume);
});
$('#input_mirror').on('change', function(){
  g_data.mirror = this.checked;
});
$('#input_beauty').on('change', function(){
  if (this.checked){
    sendIpcMessage('SET:BEAUTY', 1, 5, 5, 5);
  }else{
    sendIpcMessage('SET:BEAUTY', 1, 0, 0, 0);
  }
  g_data.beauty = this.checked;
});
$('#device_submit').on('click', function(){
  $('.img-close').trigger("click");
});
