Vue.component('pager', {
    props: {
        index: Number,
        total: Number,
        onpagechange: Function,
    },
    methods: {
        next: function () {
            ++this.index;
            this.onpagechange(this.index);
        },
        prev: function() {
            --this.index;
            this.onpagechange(this.index);
        },
        home: function() {
            this.index = 1;
            this.onpagechange(this.index);
        },
        end: function() {
            this.index = this.total;
            this.onpagechange(this.index);
        }

    },
    template: '<div class="pager"><button id="leftend" @click="home" :disabled="index<=1"></button><button id="left" @click="prev" :disabled="index<=1"></button>'
        + '<button id="pagemark">{{ index }} / {{ total }}</button>'
        + '<button id="right" @click="next" :disabled="index>=total" ></button><button id="rightend" @click="end" :disabled="index>=total"></button></div>'
})