var mic_start = false;
var camera_start = false;
var speaker_start = false;

var mic_enable = false;
var camera_enable = false;
var speaker_enable = false;

var content = "";

ipcRenderer.on('Video:Local', (event, width, height, rotation, data)=>{
  var decData = Buffer.from(data, 'base64');
  //log.info("[TAG-SET] Video:Local->len: "+data.length+"=>"+decData.length);
  var c = document.getElementById("camera_view");
  var ctx = c.getContext("2d");
  var tempData = decData.slice();
  const arr = new Uint8ClampedArray(tempData);
  let imageData = new ImageData(arr, width, height);
  var offscreenCanvas = document.createElement('canvas');
  var offscreenContext = offscreenCanvas.getContext('2d');
  offscreenCanvas.width = width;
  offscreenCanvas.height = height;
  offscreenContext.putImageData(imageData, 0, 0);

  var top = 0, left = 0;
  if (offscreenCanvas.width > offscreenCanvas.height) { //最长边为基准缩放
    var x = c.width / offscreenCanvas.width;
    top = (c.height - offscreenCanvas.height * x) / 2;
  } else {
    var x = c.height / offscreenCanvas.height;
    left = (c.width - offscreenCanvas.width * x) / 2;
  }

  sw = offscreenCanvas.width * x;
  sh = offscreenCanvas.height * x;

  ctx.drawImage(offscreenCanvas, 0, 0, offscreenCanvas.width, offscreenCanvas.height, left, top, sw, sh);
});

ipcRenderer.on('Audio:Local', (event, volume)=>{
  log.info("[TAG-SET] Audio:Local->volume:"+volume);
  $("#mic_volume span").css("width", volume+"%");
});

ipcRenderer.on('DEVICES:LIST', (event, speakers, mics, cameras)=>{
  for (i=0; i<speakers.length; i++){
    $("#speaker_id").append("<option value='"+speakers[i]+"'>"+speakers[i]+"</option>");
  }
  for (i=0; i<mics.length; i++){
    $("#mic_id").append("<option value='"+mics[i]+"'>"+mics[i]+"</option>");
  }
  for (i=0; i<cameras.length; i++){
    $("#camera_id").append("<option value='"+cameras[i]+"'>"+cameras[i]+"</option>");
  }
  // 处理选择事件
  $("#speaker_id").change(function(){
    sendIpcMessage('DEVICES:CHANGE', 'speaker', $(this).children('option:selected').val());
  });
  $("#mic_id").change(function(){
    sendIpcMessage('DEVICES:CHANGE', 'mic', $(this).children('option:selected').val());
  });
  $("#camera_id").change(function(){
    sendIpcMessage('DEVICES:CHANGE', 'camera', $(this).children('option:selected').val());
  });
})

function showDeviceView(device){
  if (device == "start"){
    $("#device_title").hide();    // 隐藏导航
    $("#device_start").show();
  }else if (device == "speaker"){
    $("#device_title").show();    // 显示导航
    $("#device_start").hide();
    $("#device_result").hide();
    $("#menu_speaker").attr("style", 'content:url(../img/dma_speaker.png)');
    $("#menu_mic").attr("style", 'content:url(../img/dm_mic.png)');
    $("#menu_camera").attr("style", 'content:url(../img/dm_camera.png)');
    $("#menu_result").attr("style", 'content:url(../img/dm_result.png)');
    $("#speaker_space").attr("style", 'background-color: #006eff');
    $("#mic_space").attr("style", 'background-color: #006eff');
    $("#camera_space").attr("style", 'background-color: #006eff');
    $("#device_speaker").show();
  }else if (device == "mic"){
    $("#device_speaker").hide();
    $("#device_mic").show();
    $("#menu_mic").attr("style", 'content:url(../img/dma_mic.png)');
    $("#menu_speaker").attr("style", 'content:url(../img/dmo_speaker.png)');
    $("#speaker_space").attr("style", 'background-color: #666666');

    // 自动打开麦克风测试
    sendIpcMessage('DEVICES:SPEAKER', false);
    sendIpcMessage('DEVICES:MIC', true);
  }else if (device == "camera"){
    $("#device_mic").hide();
    $("#device_camera").show();
    $("#menu_camera").attr("style", 'content:url(../img/dma_camera.png)');
    $("#menu_mic").attr("style", 'content:url(../img/dmo_mic.png)');
    $("#mic_space").attr("style", 'background-color: #666666');

    // 自动打开摄像头测试
    sendIpcMessage('DEVICES:MIC', false);
    sendIpcMessage('DEVICES:CAMERA', true);
  }else if (device == "result"){
    $("#device_camera").hide();
    $("#device_result").show();
    $("#device_title").hide();    // 隐藏导航
    $("#menu_result").attr("style", 'content:url(../img/dma_result.png)');
    $("#menu_camera").attr("style", 'content:url(../img/dmo_camera.png)');
    $("#camera_space").attr("style", 'background-color: #666666');
    sendIpcMessage('DEVICES:CAMERA', false);
  }
}

function updateResult(){
  $("#speaker_ret_img").attr("style", speaker_enable ? 'content:url(../img/speaker_ok.png)' : 'content:url(../img/speaker_fail.png)');
  $("#speaker_ret").text(speaker_enable ? "扬声器正常使用" : "扬声器出现异常");
  $("#mic_ret_img").attr("style", mic_enable ? 'content:url(../img/mic_ok.png)' : 'content:url(../img/mic_fail.png)');
  $("#mic_ret").text(mic_enable ? "麦克风正常使用" : "麦克风出现异常");
  $("#camera_ret_img").attr("style", camera_enable ? 'content:url(../img/camera_ok.png)' : 'content:url(../img/camera_fail.png)');
  $("#camera_ret").text(camera_enable ? "摄像头正常使用" : "摄像头出现异常");

  if (speaker_enable && mic_enable && camera_enable){
    $("#p_ret_info").text("检测完毕，设备状态正常，可开始上课");
  }else{
    $("#p_ret_info").text("检测完毕，设备状态异常，请检测设备");
  }
}

ipcRenderer.on('start', function (e, data) {
  content = data;
  // 先隐藏扬声器测试
  showDeviceView("start");
  $("#device-start").on('click', function(){
    showDeviceView("speaker");
  });
  $("#btn-speaker").on('click', function(){
    showDeviceView("speaker");
  });
  $("#btn-mic").on('click', function(){
    showDeviceView("mic");
  });
  $("#btn-camera").on('click', function(){
    showDeviceView("camera");
  });
  sendIpcMessage('DEVICES:QUERY', 0);
})

$("#speaker-test").on('click', function(){
  speaker_start = !speaker_start;
  if (speaker_start){
    sendIpcMessage('DEVICES:SPEAKER', true);
    $("#speaker-test").text("停止播放");
  }else{
    sendIpcMessage('DEVICES:SPEAKER', false);
    $("#speaker-test").text("播放音乐");
  }
});

$("#speaker-ok").on('click', function(){
  speaker_enable = true;
  showDeviceView("mic");
});

$("#speaker-fail").on('click', function(){
  speaker_enable = false;
  showDeviceView("mic");
})

$("#mic-ok").on('click', function(){
  mic_enable = true;
  showDeviceView("camera");
});

$("#mic-fail").on('click', function(){
  mic_enable = false;
  showDeviceView("camera");
});

$("#camera-ok").on('click', function(){
  camera_enable = true;
  showDeviceView("result");
  updateResult();
});

$("#camera-fail").on('click', function(){
  camera_enable = false;
  showDeviceView("result");
  updateResult();
});

$("#device-retry").on('click', function(){
  showDeviceView("speaker");
});

$("#start-class").on('click', function(){
  if (0 != g_data.classId){
    sendIpcMessage('WIN_CLASS:OPEN', g_data.classId, content);
  }
  g_storage.setItem("deviceTest", (speaker_enable ? "1" : "0")+(mic_enable ? "1" : "0")+(camera_enable ? "1" : "0"));
  sendIpcMessage('WIN_DEVICES:CLOSE');
});
