// const path = require('path');
// const ELKLog = require(path.dirname('../logreport'));
const client = require(path.join(__dirname, '../', 'js', 'module', 'client.js'))
// const ELKLog = require(path.join(__dirname, '../js', 'logreport.js'));

var app3 = new Vue({
  el: '#login_app',
  data: {
    seen: false,
    version: "x.x.x",
    message: "这里是错误提示",
    nick: g_storage.getItem('nick'), //导入上次昵称
    classId: g_storage.getItem('classId'), //导入上次课堂
    companyId:g_storage.getItem('companyId'),
    userId: g_storage.getItem('userId'), //导入上次昵称
    layout_type: "demo_landscape",
    is_show_dialog: false
  },
  mounted: function () {
    var package = require("../package.json");
    this.version = package.version;

    var lastMode = g_storage.getItem('mode');
    if (lastMode != g_data.mode){
      log.info("[TAG-LOGIN] mounted->clear while mode changed");
      g_storage.clear();
      this.nick = "";
      this.classId = "";
      this.companyId = "";
      this.userId = "";
    }
  },
  methods: {
    loginByClassId: function () { //登录逻辑
      var classid = $("#class-id").val();
      var nick = $("#nickname").val();

      var oldNick = g_storage.getItem('nick');
      if ((oldNick.startsWith('d@') && !nick.startsWith('d@'))
        || (!oldNick.startsWith('d@') && nick.startsWith('d@'))) {
        g_storage.setItem('userId', '');
      }

      g_data.test = nick.startsWith('d@');
      g_storage.setItem('nick', nick);
      g_storage.setItem('classId', classid);


      if (classid.length == 0 || nick.length == 0) {
        app3.message = "房间号和昵称 不能填空！";
        app3.seen = true;
        return;
      }

      g_data.guest = false;
      g_data.classId = parseInt(classid);
      this.startEnterClass(nick);//进房
      this.is_show_dialog = true;
    },

    loginSaas: function () {
      g_data.classId= parseInt("0"+$("#class-id").val());
      g_data.userToken= $("#user-token").val();
      g_data.userId =  $("#user-id").val();
      g_data.companyId = $("#company-id").val();

      if (0 == g_data.classId || g_data.userToken.length < 1 || g_data.userId.length < 1 || g_data.companyId < 1){
        this.message = "输入信息不能为空";
        this.seen = true;
      }else{
        sendIpcMessage('WIN_CLASS:OPEN', {});//跳转进房页面
      }
    },

    startEnterClass: function (nick) {
      client.init(g_data.test);
      client.initInfo(g_data.classId, nick, this.layout_type, (ret, response) => {
        if (!ret) {
          app3.message = "获取用户信息失败: " + JSON.stringify(response);
          app3.seen = true;
          this.is_show_dialog = false;
          return;
        }
        g_data.sdkAppId = parseInt(response.sdkappid);
        g_data.companyId = parseInt(response.enterprise_id);
        g_data.userSig = response.user_sig;
        g_data.env = response.env;
        if (response.user_id.length > 1) {
          g_data.userId = response.user_id;
          g_data.userToken = response.user_token;
        } else {
          g_data.userId = g_storage.getItem('userId');
          g_data.userToken = g_storage.getItem('userToken');
        }

        //log.info("[TAG-LOGIN] enterClassInfo sdkAppId: "+JSON.stringify(response));

        g_data.nickName = nick;
        sendIpcMessage('WIN_CLASS:OPEN', {});
      });
    },
    minWindow: function () {
      sendIpcMessage('ComWin:Sys', 'min');
    },
    maxWindow: function () {
      sendIpcMessage('ComWin:Sys', 'max');
    },
    closeWindow: function () {
      sendIpcMessage('ComWin:Sys', 'close');
      sendIpcMessage('QUITAPP');
    },
  }
})


ipcRenderer.on('start', function (event, params) {
  if (Object.keys(params).length != 0) {
    if (isDemoClient()) {
      app3.startEnterClass(params.nick);
    } else {
      //app3.login(params.user_id, params.user_token);
    }
  }
})

// 响应回车事件
$(document).keyup(function (event) {
  if (event.keyCode == 13) {
    $("#login_btn").trigger("click");
  }
});
