const client = require(path.join(__dirname, '../', 'js', 'module', 'client.js'))

let login_set_app = new Vue({
    el: '#login_set_app',
    mounted: function(){
        this.onWindowLoad();
    },
    data: {
        tab_mode: 'about',
        env_click_count: 0,
        first_click_time: 0,
        /** 弹窗信息 */
        is_loading: false,
        is_show_msg: false,
        is_show_dialog: false,
        dialog_title: '',
        dialog_msg: '',
        dialog_button: [],
        dialog_callback: 0,
    },
    created: function(){

    },
    methods: {
        /** 窗口事件 */
        onWindowLoad: function(){
            client.init(g_data.test);
        },
        minWindow: function () {
            sendIpcMessage('ComWin:Sys', 'min');
        },
        clsoeWindow: function(){
            sendIpcMessage('WIN_LOGIN:BACK');
        },
        onEnvChange: function(){
            var clickTime = new Date().getTime();
            if (clickTime - this.first_click_time > 1000){
                this.first_click_time = clickTime;
                this.env_click_count = 0;
            }else{
                this.env_click_count ++;
                if (this.env_click_count > 4){
                    g_data.test = !g_data.test;
                    this.env_click_count = 0;
                    this.showDialog("切换到"+(g_data.test?"测试":"正式")+"环境", ["确定"], null);
                }                
            }            
        },

        /** 布局方法 */
        getVersion: function(){
            var package = require('../package.json');
            log.info("[TAG-LOGIN] getVersion->"+package.version+"."+g_data.minVer);
            return package.version+"."+g_data.minVer;
        },
        checkVersion: function(){
            var companyId = g_storage.getItem('companyId');
            var curVersion = this.getVersion();
            if (companyId && companyId > 0){
                client.checkVersion(companyId, curVersion, (ret, json)=>{
                    if (!ret || compareVersion(curVersion, json.latest_version)){
                        this.showDialog('当前已是最新版本!', ['确定'], (index)=>{                            
                        })
                    }else{
                        var items = ['去升级'];
                        if (!json.force_update){
                            items.push('不用了');
                        }
                        this.showDialog('检测到有新版本['+json.latest_version+']，快去下载升级吧!', items, (index)=>{
                            if (0 == index){
                                shell.openExternale(json.download_url);
                                sendIpcMessage('QUITAPP');
                            }
                        })
                    }
                })
            }else{
                this.showDialog('请先输入机构码!', ['确定'], (index)=>{                    
                })
            }
        },

        /** 内部方法 */
        showDialog: function (message, buttons, callback) {
            this.dialog_title = '提示';
            this.dialog_msg = message;
            this.dialog_button = buttons;
            this.dialog_callback = callback;
            this.is_show_msg = true;
        },
        onDlgClick: function (index) {
            if (null != this.dialog_callback) {
                this.dialog_callback(index);
            }
            this.is_show_msg = false;
        },
    }
})


Vue.config.errorHandler = (err, vm) =>{
    let { message, name, script, line, column, stack } = err;
    // 在vue提供的error对象中，script、line、column目前是空的。但这些信息其实在错误栈信息里可以看到。
    script = script ? script : '';
    line = line ? line : 0;
    column = line ? line : 0;
    // 解析错误栈信息
    let stackStr = stack ? stack.toString() : `${name}:${message}`;

    log.error("[TAG-LOGIN] exception->"+stackStr);
}