// 从业务服务器获取userSig
// 先临时使用，后续有了业务服务器时只需修改这里


function getUserSig(userId, password, callback){
  data = JSON.stringify({
    password: password,
    platform: (process.platform != 'darwin') ? "PC" : "Mac",
    role: "student"
  });
  var md5 = crypto.createHash('md5');
  var sign = md5.update(data).digest('hex');
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: getServerDomain()+"/user/login?sdkappid="+g_data.sdkAppId+"&user_id="+g_data.userId+"&random="+Math.floor(Math.random()*10000)+"&sign="+sign,
    data: data,
    success: function(json, status, xhr) {
      //alert("xhr:"+xhr.getAllResponseHeaders());
      //g_data.token = xhr.getResponseHeader("x-api-token");
      log.info("[TAG-LOGIN] getUserSig->rsp:"+JSON.stringify(json));
      //alert("token: "+g_data.token);
      if (json && json.error_code === 0){
        g_data.token = json.token;
        callback(true, userId, json.user_sig);
      }else{
        callback(false, json.error_code, json.error_msg);
      }
    },
    error: function(xhr, status, err){
      callback(false, "", xhr.status + ': ' + xhr.statusText);
    }
  });
}

function getGuestSig(nick, callback){
  data = JSON.stringify({
    nickname: nick
  });
  var md5 = crypto.createHash('md5');
  var sign = md5.update(data).digest('hex');
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: getServerDomain()+"/user/visitor/get?sdkappid="+g_data.sdkAppId+"&user_id="+g_data.userId+"&random="+Math.floor(Math.random()*10000)+"&sign="+sign,
    data: data,
    success: function(json, status, xhr) {
      //alert("xhr:"+xhr.getAllResponseHeaders());
      //g_data.token = xhr.getResponseHeader("x-api-token");
      if (json && json.error_code === 0){
        g_data.token = json.token;
        log.info("getGuestSig->"+JSON.stringify(json));
        callback(true, json.user_id, json.user_sig);
      }else{
        callback(false, json.error_code, json.error_msg);
      }
    },
    error: function(xhr, status, err){
      callback(false, "", xhr.status + ': ' + xhr.statusText);
    }
  });
}

// 进入课堂(Paas专用)
function enterClassInfo(created, classid, nick, callback){
  var id = g_storage.getItem('userId');
  // log.info("[TAG-LOGIN] enterClassInfo has local id : "+id);
  data = JSON.stringify({
    class_id: parseInt(classid),
    create_class: created,
    nickname: nick,
    platform: (process.platform != 'darwin') ? "PC" : "Mac"
  });
  var reqUrl;


  var md5 = crypto.createHash('md5');
  var sign = md5.update(data).digest('hex');
  if (id == ""){
    log.info("[TAG-LOGIN] enterClassInfo don't has local id ");
    reqUrl = getServerDomain()+"/class/enter?sdkappid="+g_data.sdkAppId+"&random="+Math.floor(Math.random()*10000)+"&sign="+sign;
  }else{
    reqUrl = getServerDomain()+"/class/enter?sdkappid="+g_data.sdkAppId+"&user_id="+id+"&random="+Math.floor(Math.random()*10000)+"&sign="+sign;
  }
  log.info("[TAG-BUS] enterClassInfo->url: "+reqUrl);
  log.info("[TAG-BUS] enterClassInfo->req: "+data);
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: reqUrl,
    data: data,
    success: function(json, status, xhr) {
      if (json && json.error_code === 0){
        g_data.token = json.member_info.token;
        log.info("[TAG-BUS] enterClassInfo->rsp:"+JSON.stringify(json));
        callback(true, json);
      }else{
        callback(false, json);
      }
    },
    error: function(xhr, status, err){
      log.info("enterClassInfo->"+xhr.status + ': ' + xhr.statusText);
      callback(false, {});
    }
  });
}

// 组件化Demo初始化接口
function initInfo(classid, nick, classType, callback){
  var id = g_storage.getItem('userId');
  // log.info("[TAG-LOGIN] enterClassInfo has local id : "+id);
  var params = {
    class_id: parseInt(classid),
    nickname: nick,
    class_type: classType,
    platform: (process.platform != 'darwin') ? "PC" : "Mac"
  };
  if (id.length > 0){
    params.user_id = id;
  }
  data = JSON.stringify(params);
  var reqUrl;

  var md5 = crypto.createHash('md5');
  var sign = md5.update(data).digest('hex');
  reqUrl = getServerDomain()+"/demo/v1/init?sdkappid="+g_data.sdkAppId+"&user_id="+id+"&random="+Math.floor(Math.random()*10000)+"&sign="+sign;

  log.info("[TAG-BUS] initInfo->url: "+reqUrl);
  log.info("[TAG-BUS] initInfo->req: "+data);
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: reqUrl,
    data: data,
    success: function(json, status, xhr) {
      log.info("[TAG-BUS] initInfo->rsp:"+JSON.stringify(json));
      if (json && json.error_code === 0){
        callback(true, json);
      }else{
        callback(false, json);
      }
    },
    error: function(xhr, status, err){
      log.info("initInfo->"+xhr.status + ': ' + xhr.statusText);
      callback(false, {});
    }
  });
}
