/**
 * ELK日志系统
 */
function ELKLog() {
}

ELKLog.prototype = {
  // APIURL : 'http://123.206.118.43:8099/wawaji/logreport',
  APIURL: 'https://ilivelog.qcloud.com',
  // APIURL : 'https://webrtc.qq.com:8687/api/uploadlog',
  method: 'POST',

  //事件时机
  events: {
    login_event: 'login_event', // action 1 开始画线
    enter_room:'enter_room',
    log_event:"log_event"
  },

  levels: {
    info: 'info',
    warn: 'warn',
    error: 'error'
  },

  send: function (datas) {
    try {
      // datas['net_type'] = (navigator.connection.effectiveType || '').toUpperCase();
      datas['userAgent'] = navigator.userAgent;
      datas = this.fillDatas(datas);
      var xhr = this.getXHR();
      // xhr.onreadystatechange = this.reporterHandel(this);
      xhr.open(this.method, this.APIURL, true);
      xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
      xhr.send(JSON.stringify(datas));
    } catch (e) {
      console.log(e);
    }
  },

  fillDatas: function (datas) {
    var self = this;
    var dt = {};
    for (var p in self.defDatas) {
      if (['sdkappid', 'classid', 'userid','time_consume'].indexOf(p) >= 0) {
        dt[p] = self.defDatas[p];
        continue;
      }
      dt[p] = typeof datas[p] != 'undefined' ? datas[p] : self.defDatas[p];
    }
    return dt;
  },

  datasParseToString: function (datas) {
    var tmp = [];
    for (var p in datas) {
      tmp.push(p + '=' + encodeURIComponent(datas[p]));
    }
    return tmp.join('&');
  },

  getXHR: function () {
    var xmlhttp = null;
    if (window.XMLHttpRequest) { // code for all new browsers
      xmlhttp = new XMLHttpRequest();
    } else if (window.ActiveXObject) { // code for IE5 and IE6
      try {
        xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
      } catch (e) {
        try {
          xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        } catch (e) {}
      }
    }
    if (xmlhttp == null) {
      console.log("Your browser does not support XMLHTTP.");
      return;
    }
    return xmlhttp;
  },

  // reporterHandel: function () {
  //   return function (ev) {
  //     if (ev && ev.readyState) {
  //       switch (ev.readyState) {
  //         case 0:

  //           break;
  //         case 1:

  //           break;
  //         case 2:

  //           break;
  //         case 3:

  //           break;
  //         case 4:

  //           break;
  //       }
  //     }
  //   }
  // },

  log: function (key, value) {
    this.send({
      'action': key,
      'action_result': value || 0,
      'log_msg': key,
      'log_level': this.levels.info
    });
  },

  warn: function (key, value) {
    this.send({
      'action': key,
      'action_result': value || 0,
      'log_msg': key,
      'log_level': this.levels.warn
    });
  },
  error: function (key, value) {
    this.send({
      'action': key,
      'action_result': value || 0,
      'log_msg': key,
      'log_level': this.levels.error
    });
  },


  defDatas: {
    "action": "", // 	事件名称
    "version": "", // 版本号
    "action_result": 0, // 事件错误码
    "action_info": "", // 	错误详细信息
    "userid": "", // 登录用户的id
    "time_consume": 0, //事件耗时，单位毫秒
    "sdkappid": "", // sdkappid
    "platform": process.platform, // 事件对应的平台
    "decice_id":"",
    "log_time": new Date(), //  时间上报时的本地秒级时间戳
    "business": 'saas', //  业务sdk名字
    "classid": "", // 房间id，进房以及在房间中的所有事件都要带上
    "extra_info": "", // 可扩展字段
    "net_type": 'unknown', //
    "mode":"",
    "role":"",
    "userAgent": null
  },

  setSdkAppid: function (id) {
    if (id == undefined || id == null) {
      console.log('sdkappid invalid!');
      return;
    }
    this.defDatas.sdkappid = id;
  },

  setRoomId: function (id) {
    if (id == undefined || id == null) {
      console.log('roomid invalid!');
      return;
    }
    this.defDatas.roomid = id;
  },

  setUserId: function (id) {
    // debugger
    if (id == undefined || id == null) {
      console.log('userid invalid!');
      return;
    }
    this.defDatas.userid = id;
  },

  setVersion: function(version){
    this.defDatas.version = version;
  },

  setUUID: function (uuid) {
    // debugger
    if (uuid == undefined || uuid == null) {
      console.log('uuid invalid!');
      return;
    }
    this.defDatas.decice_id = uuid;
  },

  setTimeConsume: function (millisecond) {
    console.log("millisecond  "+millisecond);
    // if (millisecond == undefined || millisecond < 0) {

    //   console.log('millisecond invalid!');
    //   return;
    // }
    this.defDatas.time_consume = millisecond;
  },
  // 上报日志
  report: function (action, content = {}) {
    try {
      this.send(Object.assign({
        action_result: 0,
        time_consume: 0
      }, content, {
        'action': action,
        // 'log_time': 0
      }));
    } catch (error) {

    }
  }
};

module.exports = new ELKLog();
