
function enterClass(classId){
  g_data.classId = classId;
  sendIpcMessage('WIN_CLASS:LOAD', classId);
}

function queryClassList(){
  getClassList((ret, list) =>{
    $("#class_ing").html("");
    $("#class_will").html("");
    $("#class_end").html("");
    for (var i=0; i<list.length; i++){
      if (list[i].class_status == "ing"){
        $("#class_ing").append('<div class="class_item"><img class="class_icon" /><p><span class="class_topic">'+list[i].class_topic+'</span><br/>'
          +'<span class="class_type">'+list[i].class_type+' '+list[i].class_id+'</span>'
          +'<button type="button" class="btn_join" name="'+list[i].class_id+'">加入课堂</button><br/>'
          +'<span class="class_time">'+formatDateTime(new Date(list[i].start_time*1000), true)
          +'-'+formatDateTime(new Date(list[i].start_time*1000), true)+'</span></p></div>');
      }else if(list[i].class_status == "will"){
        $("#class_will").append('<div class="class_item"><img class="class_icon" /><p><span class="class_topic">'+list[i].class_topic+'</span><br/>'
          +'<span class="class_type">'+list[i].class_type+' '+list[i].class_id+'</span>'
          +'<button type="button" class="btn_join" name="'+list[i].class_id+'">加入课堂</button><br/>'
          +'<span class="class_time">'+formatDateTime(new Date(list[i].start_time*1000), true)
          +'-'+formatDateTime(new Date(list[i].stop_time*1000), true)+'</span></p></div>');
      }else if(list[i].class_status == "end"){
        $("#class_end").append('<div class="class_item"><img class="class_icon" /><p><span class="class_topic">'+list[i].class_topic+'</span><br/>'
          +'<span class="class_type">'+list[i].class_type+' '+list[i].class_id+'</span><br/>'
          +'<span class="class_time">'+formatDateTime(new Date(list[i].start_time*1000), true)
          +'-'+formatDateTime(new Date(list[i].start_time*1000), true)+'</span></p></div>');
      }
    };
    ing_btns = $("#class_ing button");
    for (var i=0; i<ing_btns.length; i++){
      ing_btns[i].onclick = function(){
        enterClass(parseInt(this.name));
      };
    }
    will_btns = $("#class_will button");
    for (var i=0; i<will_btns.length; i++){
      will_btns[i].onclick = function(){
        enterClass(parseInt(this.name));
      };
    }
  });

  getPublicClassList((ret, list) =>{
    $("#class_public").html("");
    for (var i=0; i<list.length; i++){
      $("#class_public").append('<div class="class_item"><img class="class_icon" /><p><span class="class_topic">'+list[i].class_topic+'</span><br/>'
        +'<span class="class_type">'+list[i].class_type+' '+list[i].class_id+'</span>'
        +'<button type="button" class="btn_join" name="'+list[i].class_id+'">加入课堂</button><br/>'
        +'<span class="class_time">'+formatDateTime(new Date(list[i].start_time*1000), true)
        +'-'+formatDateTime(new Date(list[i].start_time*1000), true)+'</span></p></div>');
    };
    will_btns = $("#class_public button");
    for (var i=0; i<will_btns.length; i++){
      will_btns[i].onclick = function(){
        enterClass(parseInt(this.name));
      };
    }
  });
}

// 自动登录WebIM
ipcRenderer.on('start', function (e, userid, userSig) {
  $("#user_id").text(g_data.userId);
  // 获取群组列表
  queryClassList();

  // 测试修改资料
  $("#btn-setprofile").on('click', function(){
    data = JSON.stringify({
      sdkappid: parseInt(g_data.sdkAppId),
      user_id: g_data.userId,
      token: g_data.token,
      nickname: "test"
    });
    var md5 = crypto.createHash('md5');
    var sign = md5.update(data).digest('hex');
    $.ajax({
      headers: {
        "Content-Type": "application/json"
      },
      type: "POST",
      url: "https://iclass.api.qcloud.com/saas/v1/user/profile/modify?random="+Math.floor(Math.random()*10000)+"&sign="+sign,
      data: data,
      success: function(json) {
        if (json && json.error_code === 0){
          alert("修改资料成功");
        }else{
          alert("修改资料失败:"+json.error_code+", "+json.error_msg);
        }
      },
      error: function(err){
        alert("修改资料异常: "+err);
      }
    });
  });

  // 测试修改密码
  $("#btn-setpwd").on('click', function(){
    data = JSON.stringify({
      sdkappid: parseInt(g_data.sdkAppId),
      user_id: g_data.userId,
      verify_type: 0,
      new_password: "1234",
      old_password: "12345678"
    });
    var md5 = crypto.createHash('md5');
    var sign = md5.update(data).digest('hex');
    $.ajax({
      headers: {
        "Content-Type": "application/json"
      },
      type: "POST",
      url: "https://iclass.api.qcloud.com/saas/v1/user/password/modify?random="+Math.floor(Math.random()*10000)+"&sign="+sign,
      data: data,
      success: function(json) {
        if (json && json.error_code === 0){
          alert("修改密码成功");
        }else{
          alert("修改密码失败:"+json.error_code+", "+json.error_msg);
        }
      },
      error: function(err){
        alert("修改密码异常: "+err);
      }
    });
  });

  // 测试登出
  $("#btn-logout").on('click', function(){
    data = JSON.stringify({
      sdkappid: parseInt(g_data.sdkAppId),
      user_id: g_data.userId,
      token: g_data.token,
      role: "student"
    });
    var md5 = crypto.createHash('md5');
    var sign = md5.update(data).digest('hex');
    $.ajax({
      headers: {
        "Content-Type": "application/json"
      },
      type: "POST",
      url: "https://iclass.api.qcloud.com/saas/v1/user/logout?random="+Math.floor(Math.random()*10000)+"&sign="+sign,
      data: data,
      success: function(json) {
        if (json && json.error_code === 0){
          alert("登出成功");
        }else{
          alert("登出失败:"+json.error_code+", "+json.error_msg);
        }
      },
      error: function(err){
        alert("登出异常: "+err);
      }
    });
  });
})

// 测试创建课堂
$("#btn-create").on('click', function(){
  var curTime = Math.floor(new Date().getTime() / 1000);
  data = JSON.stringify({
    sdkappid: parseInt(g_data.sdkAppId),
    user_id: "admin",
    token: "d7efd80085b5cdc4b3fba186d44bc1b8",
    platform: "console",
    class_topic: "测试课堂-"+Math.floor(Math.random()*10000),
    class_type: "public",
    start_time: curTime,
    stop_time: curTime+3600,
    settings: {
      resolution: "1024x768",
      fps: 20,
      layout: 1,
      recort_type: "local",
      auto_create_im: 1
    }
  });
  var md5 = crypto.createHash('md5');
  var sign = md5.update(data).digest('hex');
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: "https://iclass.api.qcloud.com/saas/v1/class/create?random="+Math.floor(Math.random()*10000)+"&sign="+sign,
    data: data,
    success: function(json) {
      if (json && json.error_code === 0){
        alert("创建课堂成功");
      }else{
        alert("创建课堂失败:"+json.error_code+", "+json.error_msg);
      }
    },
    error: function(err){
      alert("创建课堂失败: "+err);
    }
  });
})

// 刷新课堂列表
$("#btn-fresh").on('click', function(){
  queryClassList();
})

// 获取个人详细资料
$("#btn-profile").on('click', function(){
  getProfile((ret, data)=>{
    if (ret){
      $("#content_class").hide();
      $("#content_profile").show();
      $("#input_id").val(data.user_info.user_id);
      $("#input_nick").val(data.user_info.nickname);
      $("#input_role").val(data.user_info.role);
      $("#input_phone").val(data.user_info.phone_no);
      $("#input_mail").val(data.user_info.e_mail);
    }else{
      alert("获取个人信息失败: "+data);
    }
  })
})

$("#btn-classlist").on('click', function(){
  $("#content_profile").hide();
  $("#content_class").show();
  queryClassList();
})
