

// 获取课堂列表(Saas专用)
function getClassList(callback){
  data = JSON.stringify({
    platform: (process.platform != 'darwin') ? "PC" : "Mac",
    class_status: ["will", "ing"],
    size: 15,
    create_time_desc: true,
    index: 0
  });
  log.info("[TAG-CLASS] getClassList->enter");
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: getServerDomain()+"/class/list?sdkappid="+g_data.sdkAppId+"&user_id="+g_data.userId+"&token="+g_data.token+"&random="+Math.floor(Math.random()*10000),
    data: data,
    success: function(json) {
      log.info("[TAG-CLASS] getClassList->rsp: "+JSON.stringify(json));
      if (json && json.error_code === 0){
        callback(true, json.list);
      }else{
        callback(false, json.error_code+","+json.error_msg);
      }
    },
    error: function(xhr, status, err){
      callback(false, "", xhr.status + ': ' + xhr.statusText);
      log.info("[TAG-CLASS] getClassList->error: "+xhr.status + ': ' + xhr.statusText);
    }
  });
}

// 获取公开课列表(Saas专用)
function getPublicClassList(callback){
  data = JSON.stringify({
    platform: (process.platform != 'darwin') ? "PC" : "Mac",
    class_status: ["will", "ing"],
    size: 15,
    create_time_desc: true,
    index: 0
  });
  log.info("[TAG-CLASS] getPublicClassList->enter");
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: getServerDomain()+"/class/public/list?sdkappid="+g_data.sdkAppId+"&user_id="+g_data.userId+"&token="+g_data.token+"&random="+Math.floor(Math.random()*10000),
    data: data,
    success: function(json) {
      log.info("[TAG-CLASS] getPublicClassList->rsp: "+JSON.stringify(json));
      if (json && json.error_code === 0){
        callback(true, json.list);
      }else{
        callback(false, json.error_code+","+json.error_msg);
      }
    },
    error: function(xhr, status, err){
      callback(false, "", xhr.status + ': ' + xhr.statusText);
      log.info("[TAG-CLASS] getPublicClassList->error: "+xhr.status + ': ' + xhr.statusText);
    }
  });
}

// 获取课堂详情(Saas专用)
function getClassInfo(class_id, callback){
  data = JSON.stringify({
    platform: (process.platform != 'darwin') ? "PC" : "Mac",
    class_id: class_id,
  });
  log.info("[TAG-CLASS] getClassInfo->enter");
  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: getServerDomain()+"/class/info?sdkappid="+g_data.sdkAppId+"&user_id="+g_data.userId+"&token="+g_data.token+"&random="+Math.floor(Math.random()*10000),
    data: data,
    success: function(json) {
      log.info("[TAG-CLASS] getClassInfo->rsp: "+JSON.stringify(json));
      if (json && json.error_code === 0){
        callback(true, json);
      }else{
        callback(false, json.error_code+","+json.error_msg);
      }
    },
    error: function(xhr, status, err){
      callback(false, "", xhr.status + ': ' + xhr.statusText);
      log.info("[TAG-CLASS] getClassInfo->error: "+xhr.status + ': ' + xhr.statusText);
    }
  });
}

// 获取个人详细资料
function getProfile(callback){
  data = JSON.stringify({
    user_id: g_data.userId,
  });
  log.info("[TAG-CLASS] getProfile->enter");

  $.ajax({
    headers: {
      "Content-Type": "application/json"
    },
    type: "POST",
    url: getServerDomain()+"/user/info?sdkappid="+g_data.sdkAppId+"&user_id="+g_data.userId+"&random="+Math.floor(Math.random()*10000)+"&token="+g_data.token,
    data: data,
    success: function(json) {
      log.info("[TAG-CLASS] getProfile->rsp: "+JSON.stringify(json));
      if (json && json.error_code === 0){
        callback(true, json);
      }else{
        callback(false, json.error_code+","+json.error_msg);
      }
    },
    error: function(xhr, status, err){
      callback(false, "", xhr.status + ': ' + xhr.statusText);
      log.info("[TAG-CLASS] getProfile->error: "+xhr.status + ': ' + xhr.statusText);
    }
  });
}
