

module.exports = {
    user_id: '',
    role: '',

    /** 获取序列号 */
    getSeq: function(){
        return Date.now();
    },

    /** 初始化控制模块 */
    init: function(userId, role){
        this.user_id = userId;
        this.role = role;
    },
    
    /** 获取通用头部 */
    getCommonRequest: function(type){
        return {
            user_id: this.user_id,
            time: Date.now(),
            type: type,
            role: this.role,
            seq: this.getSeq()
        }
    },
    /** 上课 */
    getStartClassMsg: function(){
        var req = this.getCommonRequest('control');
        req.data = {action: 'class_begin'}
        return JSON.stringify(req);
    },
    getUpdateInfo: function(){
        var req = this.getCommonRequest('control');
        req.data = {action: 'refresh_member_info'}
        return JSON.stringify(req);
    },
    /** 进入课堂 */
    getComCtrlMsg: function(action){
        var req = this.getCommonRequest('control');
        req.data = {action: action}
        return JSON.stringify(req);
    },
    /** 设置权限 */
    getSetRightMsg: function(enable, rights, ids){
        var req = this.getCommonRequest('control');
        req.data = {
            action: (enable ? 'on' : 'off'),
            rights: rights,
            objectId: ids
        }
        return JSON.stringify(req);
    },
    getSetAllRightMsg: function(enable, rights){
        var req = this.getCommonRequest('control');
        req.data = {
            action: (enable ? 'on_all' : 'off_all'),
            rights: rights
        }
        return JSON.stringify(req);
    },
    /** 控制 */
    getControlMsg: function(action, ids){
        var req = this.getCommonRequest('control');
        req.data = {
            action: action,
            objectId: ids
        }
        return JSON.stringify(req);
    }
}