const path = require('path');
const log = require('electron-xlog');
const axios = require('axios');

log.transports.file.setPath(path.join((process.platform != 'darwin' ? process.env.USERPROFILE : process.env.HOME), 'TClass'), 'TClass')

module.exports = {
    domain: 'http://127.0.0.1',
    port: 37604,
    stimer: null,
    state_listener: null,
    
    init: function(sdkappid, userId, userSig, callback){
        data = JSON.stringify({
            SdkAppId: sdkappid,
            UserId: userId,
            UserSig: userSig
          });
  
          var reqUrl = this.getDoamin() + 'Init';
  
          log.info("[TAG-RECORD] init->url: "+reqUrl);
          log.info("[TAG-RECORD] init->req: "+data);
  
          this.post({url: reqUrl, data: data}, (ret, json)=>{
            if (null == this.stimer){
                this.stimer = setInterval(() => {
                    this.getState();
                }, 8000);
            }
            callback(ret, json)
          });
    },

    setStateListener: function(listener){
        this.state_listener = listener;
    },

    setParameter: function(recolution, fps, bitrate){
        // data = JSON.stringify({
        //     VideoResolution: recolution,
        //     VideoFps: fps,
        //     VideoBps: bitrate
        //   });
  
        //   var reqUrl = this.getDoamin() + 'SetParameter';
  
        //   log.info("[TAG-RECORD] setParameter->url: "+reqUrl);
        //   log.info("[TAG-RECORD] setParameter->req: "+data);
  
        //   this.post({url: reqUrl, data: data}, (ret, json)=>{});
    },

    startRecord: function(name, wnd, dstPath, x, y, width, height, classid){
        data = JSON.stringify({
            AppProc: name,
            Wnd: wnd,
            DstPath: dstPath,
            x: x,
            y: y,
            Width: width,
            Height: height,
            SliceTime: 3*60,
            ClassId: classid
          });

        var reqUrl = this.getDoamin() + 'StartRecord';

        log.info("[TAG-RECORD] StartRecord->url: "+reqUrl);
        log.info("[TAG-RECORD] StartRecord->req: "+data);

        this.post({url: reqUrl, data: data}, (ret, json)=>{
        });
    },

    stopRecord: function(){        
        // if (this.stimer){
        //     clearInterval(this.stimer)
        //     this.stimer = null;
        // }

        data = JSON.stringify({
        });
  
        var reqUrl = this.getDoamin() + 'StopRecord';

        log.info("[TAG-RECORD] StopRecord->url: "+reqUrl);
        log.info("[TAG-RECORD] StopRecord->req: "+data);

        this.post({url: reqUrl, data: data}, (ret, json)=>{});
    },

    startPush: function(name, wnd, dstUrl, x, y, width, height){
        data = JSON.stringify({
            AppProc: name,
            Wnd: wnd,
            DstURL: dstUrl,
            x: x,
            y: y,
            Width: width,
            Height: height
          });

        var reqUrl = this.getDoamin() + 'StartPush';

        log.info("[TAG-RECORD] startPush->url: "+reqUrl);
        log.info("[TAG-RECORD] startPush->req: "+data);

        this.post({url: reqUrl, data: data}, (ret, json)=>{                       
        });        
    },

    stopPush: function(){        
        // if (this.stimer){
        //     clearInterval(this.stimer)
        //     this.stimer = null;
        // }

        data = JSON.stringify({
        });
  
        var reqUrl = this.getDoamin() + 'StopPush';

        log.info("[TAG-RECORD] stopPush->url: "+reqUrl);
        log.info("[TAG-RECORD] stopPush->req: "+data);

        this.post({url: reqUrl, data: data}, (ret, json)=>{});
    },

    getState: function(){
        data = JSON.stringify({
        });
  
        var reqUrl = this.getDoamin() + 'GetState';

        log.info("[TAG-RECORD] getState->url: "+reqUrl);
        log.info("[TAG-RECORD] getState->req: "+data);

        this.post({url: reqUrl, data: data}, (ret, json)=>{
            this.state_listener && this.state_listener(ret, json);
        });
    },

    /** 测试 */
    log: function(msg){
        log.info(msg);
    },
    err: function(msg){
        log.error(msg);
    },
    
    /** 通用接口 */
    getDoamin: function(){
        return this.domain + ':' + this.port + '/localrecord/v1/';
    },
    post: function (option, callback) {
        option.headers = {'Content-Type': 'application/json'};
        option.method = 'POST';
        axios(option).then((rsp) => {
            this.log('[TAG-RECORD] post->rsp: ' + JSON.stringify(rsp.data));
            callback(rsp.data && rsp.data.Response, rsp.data.Response);
        }).catch((err) => {
            this.err('[TAG-RECORD] post->fail: '+ err);
            callback(false, err);
        })
    }
}

