
const liteav = require('bindings')("liteav")
const log = require('electron-xlog');

module.exports = {
    listeners: {},

    /** 导出接口 */
    init: function(){
        this.log("[TAG-TRTC] init->enter");
        liteav.setOnError(onError);
        liteav.setOnEnterRoom(onEnterRoom);
        liteav.setOnUserEnter(onUserEnter);
        liteav.setOnUserExit(onUserExit);
        liteav.setOnUserVideoAvailable(onUserVideoEvent);
        liteav.setOnUserAudioAvailable(onUserAudioEvent);
        liteav.setOnUserSubStreamAvailable(onUserSubStreamEvent);
        liteav.setVolumeCallback(onVolume);
        liteav.setLocalVideoCallback(onLocalVideoData);
        liteav.setOnRecvCustomCmdMsg(onRecvCustomCmdMsg);
        liteav.setOnDeviceChange(OnDeviceChange);
    },
    getTickCount: function(){
        return liteav.getTickCount();
    },    
    enterRoom: function(sdkAppId, roomId, privateMapKey, userId, userSig){
        this.log("[TAG-TRTC] enterRoom->roomId: "+roomId);
        liteav.enableAudioVolumeEvaluation(500, 5);
        liteav.enterRoom(sdkAppId, roomId, userId, userSig, privateMapKey, "", 1);
    },
    exitRoom: function(){
        liteav.exitRoom();
    },

    /** 音视频参数 */
    setVideoEncoderParam: function(resolution, fps, bitrate){
        liteav.setVideoEncoderParam(resolution, fps, bitrate);
    },
    startRemoteView: function(id){
        return liteav.startRemoteView(id);
    },
    startRemoteSubStreamView: function(id){
        return liteav.startRemoteSubStreamView(id);
    },
    setRemoteVideoCallback: function(id, callback){
        return liteav.setRemoteVideoCallback(id, callback);
    },
    enableAudioVolumeEvaluation: function(interval, data){
        return liteav.enableAudioVolumeEvaluation(interval, data);
    },

    /** 设置控制 */
    enableCamera: function(enable){
        if (enable){
            liteav.startLocalPreview();
        }else{
            liteav.stopLocalPreview();
        }        
    },
    enableMic: function(enable){
        if (enable){
            liteav.startLocalAudio();
        }else{
            liteav.stopLocalAudio();
        }
    },
    getCurrentSpeakerVolume: function(){
        return liteav.getCurrentSpeakerVolume();
    },
    setCurrentSpeakerVolume: function(volume){
        return liteav.setCurrentSpeakerVolume(volume);
    },
    getSpeakerDevicesList: function (){
        return liteav.getSpeakerDevicesList();
    },
    getMicDevicesList: function(){
        return liteav.getMicDevicesList();
    },
    getCameraDevicesList: function(){
        return liteav.getCameraDevicesList();
    },
    getCurrentSpeakerDevice: function(){
        return liteav.getCurrentSpeakerDevice();
    },
    getCurrentMicDevice: function(){
        return liteav.getCurrentMicDevice();
    },
    getCurrentCameraDevice: function(){
        return liteav.getCurrentCameraDevice();
    },
    setCurrentSpeakerDevice: function(devId){
        return liteav.setCurrentSpeakerDevice(devId);
    },
    setCurrentMicDevice: function(devId){
        return liteav.setCurrentMicDevice(devId);
    },
    setCurrentCameraDevice: function(devId){
        return liteav.setCurrentCameraDevice();
    },
    startSpeakerDeviceTest: function(file){
        return liteav.startSpeakerDeviceTest(file);
    },
    stopSpeakerDeviceTest: function(){
        return liteav.stopSpeakerDeviceTest();
    },
    startMicDeviceTest: function(value){
        return liteav.startMicDeviceTest(value);
    },
    stopMicDeviceTest: function(){
        return liteav.stopMicDeviceTest();
    },
    startCameraDeviceTest: function(){
        return liteav.startCameraDeviceTest();
    },
    stopCameraDeviceTest: function(){
        return liteav.stopCameraDeviceTest();
    },
    setBeautyStyle: function(mode, beauty, white, ruddiness){
        return liteav.setBeautyStyle(mode, beauty, white, ruddiness);
    },

    /** 录制和屏幕分享 */
    startRecord: function(title, x, y, w, h, slice, path){
        return liteav.startRecord(title, x, y, w, h, slice, path);
    },
    stopRecord: function(){
        return liteav.stopRecord();
    },
    selectScreenCaptureTarget: function(type, id, name, x, y, w, h, mouse, border){
        return liteav.selectScreenCaptureTarget(type, id, name, x, y, w, h, mouse, border);
    },
    startScreenCapture: function(){
        return liteav.startScreenCapture();
    },
    stopScreenCapture: function(){
        return liteav.stopScreenCapture();
    },
    getScreenCaptureSources: function(thumbW, thumbH, w, h){
        return liteav.getScreenCaptureSources(thumbW, thumbH, w, h);
    },

    /** 播片 */
    startVodPlay: function(path, loop){
        return liteav.startVodPlay(path, loop);
    },
    setVodPlayerStarted: function(callback){
        return liteav.setVodPlayerStarted(callback);
    },
    setVodPlayerStoped: function(callback){
        return liteav.setVodPlayerStoped(callback);
    },
    setVodPlayerProgress: function(callback){
        return liteav.setVodPlayerProgress(callback);
    },
    setVodPlayerError: function(callback){
        return liteav.setVodPlayerError(callback);
    },
    seekVodPlay: function(pos){
        return liteav.seekVodPlay(pos);
    },
    pauseVodPlay: function(){
        return liteav.pauseVodPlay();
    },
    resumeVodPlay: function(){
        return liteav.resumeVodPlay();
    },
    stopVodPlay: function(){
        return liteav.stopVodPlay();
    },

    /** 自定义消息 */
    sendCustomCmdMsg: function(cmdId, msg, reliable, order){
        return liteav.sendCustomCmdMsg(cmdId, msg, reliable, order);
    },

    /** 设置回调 */
    setOnError: function(listener){
        this.listeners.onError = listener;
    },
    setOnEnterRoom: function(listener){
        this.listeners.onEnterRoom = listener;
    },
    setOnStatistics: function(listener){
        this.listeners.onStatistics = listener;
    },
    setOnUserEnter: function(listener){
        this.listeners.onUserEnter = listener;
    },
    setOnUserExit: function(listener){
        this.listeners.onUserExit = listener;
    },
    setOnUserVideoAvailable: function(listener){
        this.listeners.onUserVideoEvent = listener;
    },
    setOnUserAudioAvailable: function(listener){
        this.listeners.onUserAudioEvent = listener;
    },
    setOnUserSubStreamAvailable: function(listener){
        this.listeners.onUserSubStreamEvent = listener;
    },
    setVolumeCallback: function(listener){
        this.listeners.onVolume = listener;
    },
    setLocalVideoCallback: function(listener){
        this.listeners.onLocalVideoData = listener;
    },
    setOnRecvCustomCmdMsg: function(listener){
        this.listeners.onRecvCustomCmdMsg = listener;
    },
    setOnDeviceChange: function(listener){
        this.listeners.OnDeviceChange = listener;
    },

    /** 测试 */
    log: function(msg){
        log.info(msg);
    },
    err: function(msg){
        log.error(msg);
    },

    /**  TRTC 事件 */
    onError: function(code, msg, arg){
        this.err("[TAG-TRTC] onError->code:"+code+", msg:"+msg);
        if (this.listeners.hasOwnProperty('onError')){
            this.listeners.onError(code, msg, arg);
        }
    },
    onEnterRoom: function(elapse){
        this.log("[TAG-TRTC] onEnterRoom->elapse:"+elapse);
        liteav.setOnStatistics(onStatistics);
        if (this.listeners.hasOwnProperty('onEnterRoom')){
            this.listeners.onEnterRoom(elapse);
        }
    },
    onUserEnter: function(id){
        if (this.listeners.hasOwnProperty('onUserEnter')){
            this.listeners.onUserEnter(id);
        }
    },
    onUserExit: function(id){
        if (this.listeners.hasOwnProperty('onUserExit')){
            this.listeners.onUserExit(id);
        }
    },
    onUserVideoEvent: function(id, enable){
        if (this.listeners.hasOwnProperty('onUserVideoEvent')){
            this.listeners.onUserVideoEvent(id, enable);
        }
    },
    onUserAudioEvent: function(id, enable){
        if (this.listeners.hasOwnProperty('onUserAudioEvent')){
            this.listeners.onUserAudioEvent(id, enable);
        }
    },
    onUserSubStreamEvent: function(id, enable){
        if (this.listeners.hasOwnProperty('onUserSubStreamEvent')){
            this.listeners.onUserSubStreamEvent(id, enable);
        }
    },
    onVolume: function(id, volume){
        if (this.listeners.hasOwnProperty('onVolume')){
            this.listeners.onVolume(id, volume);
        }
    },
    onLocalVideoData: function(id, type, width, height, timestamp, rotation, data){
        if (this.listeners.hasOwnProperty('onLocalVideoData')){
            this.listeners.onLocalVideoData(id, type, width, height, timestamp, rotation, data);
        }
    },
    onRecvCustomCmdMsg: function(id, cmdId, req, msg){
        if (this.listeners.hasOwnProperty('onRecvCustomCmdMsg')){
            this.listeners.onRecvCustomCmdMsg(id, cmdId, req, msg);
        }
    },
    OnDeviceChange: function(devId, devType, devState){
        if (this.listeners.hasOwnProperty('OnDeviceChange')){
            this.listeners.OnDeviceChange(devId, devType, devState);
        }
    },
    onStatistics: function(upLoss, downLoss, appCpu, systemCpu, rtt, recvBytes, sentBytes){
        if (this.listeners.hasOwnProperty('onStatistics')){
            this.listeners.onStatistics(upLoss, downLoss, appCpu, systemCpu, rtt, recvBytes, sentBytes);
        }
    },
}

/** 外部事件监听(liteav不支持子方法) */
function onError(code, msg, arg){
    module.exports.onError(code, msg, arg);
}
function onEnterRoom(elapse){
    module.exports.onEnterRoom(elapse);
}
function onUserEnter(id){
    module.exports.onUserEnter(id);
}
function onUserExit(id){
    module.exports.onUserExit(id);
}
function onUserVideoEvent(id, enable){
    module.exports.onUserVideoEvent(id, enable);
}
function onUserAudioEvent(id, enable){
    module.exports.onUserAudioEvent(id, enable);
}
function onUserSubStreamEvent(id, enable){
    module.exports.onUserSubStreamEvent(id, enable);
}
function onVolume(id, volume){
    module.exports.onVolume(id, volume);
}
function onLocalVideoData(id, type, width, height, timestamp, rotation, data){
    module.exports.onLocalVideoData(id, type, width, height, timestamp, rotation, data);
}
function onRecvCustomCmdMsg(id, cmdId, req, msg){
    module.exports.onRecvCustomCmdMsg(id, cmdId, req, msg);
}
function OnDeviceChange(devId, devType, devState){
    module.exports.OnDeviceChange(devId, devType, devState);
}
function onStatistics(upLoss, downLoss, appCpu, systemCpu, rtt, recvBytes, sentBytes){
    module.exports.onStatistics(upLoss, downLoss, appCpu, systemCpu, rtt, recvBytes, sentBytes);
}