

let dialog_app = new Vue({
  el: '#dialog_app',
  mounted: function () {
    this.check_timer = setInterval(()=>{
      sendIpcMessage('MAIN:CHECK', {});
    }, 5000);
    window.onbeforeunload = this.onWindowUnload;
  },
  data: {
      title: '腾讯云互动课堂',
      id: 0,
      message: '',
      buttons: [],
      select: -1
  },
  created: function () {

  },
  methods: {
    closeWindow: function () {
      sendIpcMessage('DIALOG:CLOSE', this.id, this.select);
      sendIpcMessage('DIALOG:HIDE', this.id);
    },
    onWindowUnload: function(e){
      if (this.check_timer) {
        clearInterval(this.check_timer);
      }
      log.info("[TAG-DLG] onWindowUnload->enter");
    },
    onClick: function(index){
      log.info("[TAG-DLG] onClick->select: "+index);
      this.select = index;
      this.closeWindow();
    },
    initDialog: function(dlgId, message, buttons){
      initUserConfig();
      this.id = dlgId;
      this.title = getUserAppName();
      this.message = message;
      this.buttons = buttons;
      this.select = -1;
      if (buttons.length < 1){
        $("#dialog_msg")[0].style.marginTop = "20px";
      }else{
        $("#dialog_msg")[0].style.marginTop = "0px";
      }
    }
  }
});

ipcRenderer.on('start', (event, options)=>{
  dialog_app.initDialog(options.id, options.message, options.buttons);
})

ipcRenderer.on('init', (event, options)=>{
  dialog_app.initDialog(options.id, options.message, options.buttons);
})
