/**
 * 读取本地配置
 */
const path = require('path')

var configDir = path.join((process.platform!='darwin' ? process.env.USERPROFILE : process.env.HOME), 'TClass');

function JsonCfg(cfgPath, cfgName, cfgDef){
  this.path = cfgPath;
  this.name = cfgName;
  this.url = path.join(cfgPath, cfgName);
  this.def = cfgDef;
  this.initConfig = function(){
    log.info("[TAG-DB] initConfig->path: "+this.url);
    if (!fs.existsSync(this.path)){
      fs.mkdir(this.path, function(err){
        if(err){
          log.error("[TAG-DB] Create Db dir failed");
        };
      });
    }
    try{
      config = this.readConfig();
      if (config) {
        this.config = JSON.parse(config);
        if (null != this.def['version']){
          if (this.config['version'] != cfgDef['version']){  // 版本不对时重置数据
            this.config = this.def;
          }
        }
        return true;
      }
    }catch(err){
      log.warn("[TAG-DB] ReadConfig fail: "+err);    }

    const content = JSON.stringify(this.def);
    fs.writeFileSync(this.url, content);
    this.config = this.def;
    return true;
  }
  this.isExit = function(){
    let success = true;
    if (!(this.config && typeof this.config === 'object')) {
      success = this.initConfig();
    }
    return success;
  }
  this.readConfig = function() {
    try {
      const result = fs.readFileSync(this.url, 'utf8');
      return result[0]=='{' ? result : result.substring(1);
    } catch (error) {
      return false;
    }
  }
  this.writeConfig = function(value) {
    try {
      const content = JSON.stringify(value);
      fs.writeFileSync(this.url, content);
      return true;
    } catch (e) {
      return false;
    }
  }
  this.getItem = function(key){
    const success = this.isExit();
    if (success) {
      const result = this.config[key];
      return result ? result : '';
    }
    return null;
  }
  this.setItem = function(key, value){
    let success = this.isExit();
    if (success) {
      const config = Object.assign({}, this.config);
      config[key] = value;
      const suc = this.writeConfig(config);
      if (suc) {
        this.config = config;
        return true;
      }
    }
    return false;
  }
  this.getAll = function(){
    let success = this.isExit();
    if (success) {
      return this.config;
    }
    return null;
  }
  this.removeItem = function(key){
    const value = this.getItem(key);
    if (value) {
      const config = Object.assign({}, this.config);
      delete config[key];
      const suc = this.writeConfig(config);
      if (suc) {
        this.config = config;
        return true;
      }
    }
    return false;
  }
  this.clear = function(){
    let success = this.isExit();
    if (success) {
      const suc = this.writeConfig({});
      if (suc) {
        this.config = {};
        return true;
      }
    }
    return false;
  }
}

const localConfig = new JsonCfg(configDir, 'localTClass.dat', {version: '1.2',
  appName: '腾讯视频云',
  appIconUrl: 'https://main.qcloudimg.com/raw/04105df39e96083d089d60f18f8f07bd.ico'
});
let userConfig

function initConfig(){
  localConfig.initConfig();
}

function initUserConfig(){
  log.info('[TAG-DB] initUserConfig->enter');
  userConfig = new JsonCfg(configDir, 'config.json', {
    title: '腾讯视频云',
    logo: 'https://main.qcloudimg.com/raw/04105df39e96083d089d60f18f8f07bd.ico'
  })
  userConfig.initConfig();
}

function getConfigDir(){
  return configDir;
}

function getUserAppName(){
  return localConfig.getItem('appName');
}

function getUserAppIcon(){
  return localConfig.getItem('appIconUrl');
}
