'use strict';

var log = require('./log').log;
var transportConsole = require('./transports/console');
var transportFile = require('./transports/mmap');

module.exports = create();
module.exports.default = module.exports;

function create() {
  var instance = {
    create: create,
    functions: {},
    hooks: [],
    levels: ['error', 'warn', 'info', 'debug', 'verbose'],
  };

  instance.transports = {
    console: transportConsole(instance),
    file: transportFile(instance),
  };

  instance.levels.forEach(function (level) {
    instance[level] = log.bind(null, instance, level);
    instance.functions[level] = instance[level];
  });

  instance.log = log.bind(null, instance, 'info');
  instance.functions.log = instance.log;

  return instance;
}
