
const nativeXlog = require('../../build/Release/' + (process.platform != 'darwin' ? 'win' : 'mac') + '/xlog.node');

module.exports = mmapTransportFactory;

function mmapTransportFactory() {

  transport.xlog = new nativeXlog.NodeXlog();
  transport.setPath = function(path, name) {
    transport.xlog.setPath(path, name);
  }
  transport.flush = function() {
    transport.xlog.flush();
  }
  return transport;

  function transport(message) {
    let logLevel = 2;
    switch (message.level) {
      case 'verbose':
        logLevel = 0;
        break;
      case 'debug':
        logLevel = 1;
        break;
      case 'info':
        logLevel = 2;
        break;
      case 'warn':
        logLevel = 3;
        break;
      case 'error':
        logLevel = 4;
        break;
    }
    transport.xlog.log(logLevel, message.data[0]);
  }

}
