"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const SoftwareRenderer_1 = __importDefault(require("./SoftwareRenderer"));
exports.SoftwareRenderer = SoftwareRenderer_1.default;
const GlRenderer_1 = __importDefault(require("./GlRenderer"));
class GlRenderer {
    constructor() {
        this.self = GlRenderer_1.default.apply(this);
        this.event = this.self.event;
    }
    bind(element) {
        return this.self.bind(element);
    }
    unbind() {
        return this.self.unbind();
    }
    drawFrame(imageData) {
        return this.self.drawFrame(imageData);
    }
    setContentMode(mode) {
        return this.self.setContentMode(mode);
    }
    refreshCanvas() {
        return this.self.refreshCanvas();
    }
}
exports.GlRenderer = GlRenderer;
// RGB renderer
const RGBRenderer_1 = __importDefault(require("./RGBRenderer"));
exports.RGBRenderer = RGBRenderer_1.default;

// 自定义 Renderer 实现
class CustomRenderer {
    constructor() {
    }
    bind(element) {
    }
    unbind() {
    }
    drawFrame(imageData) {
    }
    setContentMode(mode) {
    }
    refreshCanvas() {
    }
}
exports.CustomRenderer = CustomRenderer;
