"use strict";

const TRTCCloud = require("./trtc");
const { TRTCVideoStreamType } = require("./trtc_define");

class TRTCEduCloud extends TRTCCloud {
    constructor() {
        super();
        this.initEduHandler();
        this.enableRGBRenderer();
    }
    enableRGBRenderer() {
        this.setRenderMode(3);
        this.rtcCloud.setVideoCallbackPixel(3);
    }
    setRenderSize(width, height) {
        this.rtcCloud.setRenderSize(width, height);
    }
    startVodPlay(path, repeat, view) {
        if (view !== undefined) {
            let key = this.getKey("local_video", TRTCVideoStreamType.TRTCVideoStreamTypeSub);
            this._initRender(key, view);
            this.addLocalVideoRenderCallback();
            this.rtcCloud.startVodPlay(path, repeat);
        }
        else {
            console.error("startLocalPreview, view is undefined!s");
        }
    }

    pauseVodPlay() {
        this.rtcCloud.pauseVodPlay();
    }

    resumeVodPlay() {
        this.rtcCloud.resumeVodPlay();
    }

    stopVodPlay() {
        let key = this.getKey("local_video", TRTCVideoStreamType.TRTCVideoStreamTypeSub);
        this._destroyRender(key, null);
        this.rtcCloud.stopVodPlay();
    }

    vodSeek(pos) {
        this.rtcCloud.vodSeek(pos);
    }

    startLocalRecord(windowid, x, y, w, h, slice, path) {
        this.rtcCloud.startLocalRecord(windowid, x, y, w, h, slice, path);
    }

    stopLocalRecord() {
        this.rtcCloud.stopLocalRecord();
    }

    initEduHandler() {
        const fire = (event, ...args) => {
            setImmediate(() => {
                this.emit(event, ...args);
            });
        };
        
        this.rtcCloud.onEvent('onVodPlayerStarted', function (msLength) {
            fire('onVodPlayerStarted', msLength);
        });
        
        this.rtcCloud.onEvent('onVodPlayerProgress', function (msPos) {
            fire('onVodPlayerProgress', msPos);
        });
        
        this.rtcCloud.onEvent('onVodPlayerPaused', function () {
            fire('onVodPlayerPaused');
        });
        
        this.rtcCloud.onEvent('onVodPlayerResumed', function () {
            fire('onVodPlayerResumed');
        });
        
        this.rtcCloud.onEvent('onVodPlayerSeekDone', function () {
            fire('onVodPlayerSeekDone');
        });
        
        this.rtcCloud.onEvent('onVodPlayerStoped', function (reason) {
            fire('onVodPlayerStoped', reason);
        });
        
        this.rtcCloud.onEvent('onVodPlayerError', function (error) {
            fire('onVodPlayerError', error);
        });
        
        this.rtcCloud.onEvent('onVodPlayerWarn', function (error) {
            fire('onVodPlayerWarn', error);
        });
    }

}

module.exports = TRTCEduCloud;