/**
 * Utils for command line tools
 */
const semver = require('semver')
const pkg = require('../package.json');

const { Platform, DependentElectronVersion } = require('./constant')

module.exports.detectOS = () => {
  const platform = process.platform;
  switch (platform) {
    case 'darwin':
      return Platform.MACOS;
    case 'win32':
      return Platform.WINDOWS;
    default:
      return Platform.UNSUPPORTED;
  }
};

module.exports.detectOwnVersion = () => {
  const { major, minor, patch } = semver.coerce(pkg.version);
  return {
    major, minor, patch, version: pkg.version
  };
};

module.exports.detectOwnName = () => {
  var name = pkg.name;
  return name;
};

