const Application = require('spectron').Application
const assert = require('assert')
const electronPath = require('electron') // Require Electron from the binaries included in node_modules.
const path = require('path')
const sleep = time => new Promise(r => setTimeout(r, time))

describe('Application launch', function () {
  this.timeout(30000)

  before(function () {
    this.app = new Application({
      path: electronPath,
      args: [path.join(__dirname, '..'), 100001, 1000663273, 'jason_teacher', '123456', 'eJwtzNEKgjAYBeB32W1hv9NpCF0UUSApRCkJQYiu-EttuhFG9O7J1uX5zuF8yHF3sF68JwGhFpCpzljyVuEVNd9z*WwviudFNWYzkOUjFwJLEtgugO1Ranum4YPAno-OGKMAYFRho813qQue81eJt-E-9WW7dtR51gwiWWVF1FV1ON9MoiQ*hcu05tHAum0fxm*6X5DvD3Y4NQk_']
    })
    return this.app.start()
  })

  after(function () {
    function sleep (time) {
      return new Promise((resolve) => setTimeout(resolve, time));
    }
    let self = this
    sleep(2000).then(() => {
      if (self.app && self.app.isRunning()) {
        return self.app.stop()
      }
    })
    // if (this.app && this.app.isRunning()) {
    //   return this.app.stop()
    // }
  })

  it('shows an initial window', function () {
    return this.app.client.getWindowCount().then(function (count) {
      assert.equal(count, 1)
    })
  })

  it('draw', function () {
    let self = this;

    // .tic-icon-toolgraphical #board_iframe  div.tic-player__tool ul.tic-toolbar-menu li.tic-item-toolgraphical a
    return this.app.client.waitUntilTextExists('#btn_send', '发送')
            .windowHandles().then(function() {
              return this.frame('board_iframe')
            })
            .click('li.tic-item-toolgraphical a').then(function() {
              // self.app.client.click('li.tic-item-toolgraphical a')
              return self.app.client.windowHandles()           
            })
            .then(function() {
              return this.frame()
            })
            .then(function() {

              self.app.client.webContents.sendInputEvent({ type: 'mouseDown', button: 'left', x: 100, y: 320, clickCount: 1})
              self.app.client.webContents.sendInputEvent({ type: 'mouseMove', x: 600, y: 320})
              self.app.client.webContents.sendInputEvent({ type: 'mouseUp'})
              self.app.client.webContents.sendInputEvent({ type: 'mouseDown', button: 'left', x: 100, y: 340, clickCount: 1})
              self.app.client.webContents.sendInputEvent({ type: 'mouseMove', x: 600, y: 340})
              self.app.client.webContents.sendInputEvent({ type: 'mouseUp'})
              self.app.client.webContents.sendInputEvent({ type: 'mouseDown', button: 'left', x: 100, y: 360, clickCount: 1})
              self.app.client.webContents.sendInputEvent({ type: 'mouseMove', x: 600, y: 360})
              self.app.client.webContents.sendInputEvent({ type: 'mouseUp'})
              self.app.client.webContents.sendInputEvent({ type: 'mouseDown', button: 'left', x: 100, y: 380, clickCount: 1})
              self.app.client.webContents.sendInputEvent({ type: 'mouseMove', x: 600, y: 380})
              self.app.client.webContents.sendInputEvent({ type: 'mouseUp'})
              self.app.client.webContents.sendInputEvent({ type: 'mouseDown', button: 'left', x: 100, y: 400, clickCount: 1})
              self.app.client.webContents.sendInputEvent({ type: 'mouseMove', x: 600, y: 400})
              self.app.client.webContents.sendInputEvent({ type: 'mouseUp'})

              self.app.client.webContents.sendInputEvent({ type: 'mouseDown', button: 'left', x: 100, y: 420, clickCount: 1})
              self.app.client.webContents.sendInputEvent({ type: 'mouseMove', x: 600, y: 420})
              self.app.client.webContents.sendInputEvent({ type: 'mouseUp'})
              self.app.client.webContents.sendInputEvent({ type: 'mouseDown', button: 'left', x: 100, y: 440, clickCount: 1})
              self.app.client.webContents.sendInputEvent({ type: 'mouseMove', x: 600, y: 440})
              self.app.client.webContents.sendInputEvent({ type: 'mouseUp'})
              self.app.client.webContents.sendInputEvent({ type: 'mouseDown', button: 'left', x: 100, y: 460, clickCount: 1})
              self.app.client.webContents.sendInputEvent({ type: 'mouseMove', x: 600, y: 460})
              self.app.client.webContents.sendInputEvent({ type: 'mouseUp'})
              self.app.client.webContents.sendInputEvent({ type: 'mouseDown', button: 'left', x: 100, y: 480, clickCount: 1})
              self.app.client.webContents.sendInputEvent({ type: 'mouseMove', x: 600, y: 480})
              self.app.client.webContents.sendInputEvent({ type: 'mouseUp'})
              self.app.client.webContents.sendInputEvent({ type: 'mouseDown', button: 'left', x: 100, y: 500, clickCount: 1})
              self.app.client.webContents.sendInputEvent({ type: 'mouseMove', x: 600, y: 500})
              self.app.client.webContents.sendInputEvent({ type: 'mouseUp'})
              self.app.client.webContents.sendInputEvent({ type: 'mouseDown', button: 'left', x: 100, y: 520, clickCount: 1})
              self.app.client.webContents.sendInputEvent({ type: 'mouseMove', x: 600, y: 520})
              self.app.client.webContents.sendInputEvent({ type: 'mouseUp'})
              // return self.app.client.windowHandles()
            })
            // .then(function() {
            //   return this.frame('board_iframe')
            // })
            // .click('li.tic-item-toolgraphical a').then(function() {
            //   return self.app.client.click('.tic-toolbar-dorp-list ul li:nth-child(2)')
            // })
            // .then(function() {
            //   return self.app.client.windowHandles()           
            // })
            // .then(function() {
            //   return this.frame()
            // })
            // .then(function() {
            //   self.app.client.webContents.sendInputEvent({ type: 'mouseDown', button: 'left', x: 100, y: 200, clickCount: 1})
            //   self.app.client.webContents.sendInputEvent({ type: 'mouseMove', x: 600, y: 320})
            //   self.app.client.webContents.sendInputEvent({ type: 'mouseUp'})
            // })
          

  })

  // it ('draw', function () {
  //   this.app.client.webContents.sendInputEvent({ type: 'mouseDown', button: 'left', x: 300, y: 500, clickCount: 1})
  //   this.app.client.webContents.sendInputEvent({ type: 'mouseMove', x: 500, y: 500})
  // })


})