#include "led.h"

static void _led_delay(u16 _ms)
{
	for(u16 i=_ms;i>0;i--)
	{
		for(u16 j=5000;j>0;j--)
			for(u16 k=2;k>0;k--)
			;
	}
}
void Led_Init(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;
  
  RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOE | RCC_AHB1Periph_GPIOC, ENABLE);					 
			 
	GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_0 | GPIO_Pin_1 | GPIO_Pin_2 | GPIO_Pin_3 | GPIO_Pin_4;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_UP;
	GPIO_Init(GPIOE, &GPIO_InitStructure);
	
	GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_13 | GPIO_Pin_14 | GPIO_Pin_15;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_UP;
	GPIO_Init(GPIOC, &GPIO_InitStructure);
	
	Led_Control(9,0);
	_led_delay(150);
	Led_Control(1,1);
	_led_delay(150);
	Led_Control(2,1);
	_led_delay(150);
	Led_Control(3,1);
	_led_delay(150);
	Led_Control(4,1);
	_led_delay(150);
	Led_Control(5,1);
	_led_delay(150);
	Led_Control(6,1);
	_led_delay(150);
	Led_Control(7,1);
	_led_delay(150);
	Led_Control(8,1);
	_led_delay(150);
	Led_Control(1,0);
	_led_delay(150);
	Led_Control(2,0);
	_led_delay(150);
	Led_Control(3,0);
	_led_delay(150);
	Led_Control(4,0);
	_led_delay(150);
	Led_Control(5,0);
	_led_delay(150);
	Led_Control(6,0);
	_led_delay(150);
	Led_Control(7,0);
	_led_delay(150);
	Led_Control(8,0);
}
void Led_Control(u8 num,u8 state)
{
	switch(num)
	{
		case 1: LED1(state);break;
		case 2: LED2(state);break;
		case 3: LED3(state);break;
		case 4: LED4(state);break;
		case 5: LED5(state);break;
		case 6: LED6(state);break;
		case 7: LED7(state);break;
		case 8: LED8(state);break;
		default : LED1(state);LED2(state);LED3(state);LED4(state);LED5(state);LED6(state);LED7(state);LED8(state);break;
	}
}
void Led_Show_Yaw(float yaw)
{
	if(yaw>-22.5f&&yaw<22.5f)
	{
		LED1(1);LED2(0);LED3(0);LED4(1);LED5(1);LED6(1);LED7(0);LED8(0);
	}
	else if(yaw>22.5f&&yaw<67.5f)
	{
		LED1(0);LED2(1);LED3(0);LED4(0);LED5(1);LED6(1);LED7(1);LED8(0);
	}
	else if(yaw>67.5f&&yaw<112.5f)
	{
		LED1(0);LED2(0);LED3(1);LED4(0);LED5(0);LED6(1);LED7(1);LED8(1);
	}
	else if(yaw>112.5f&&yaw<157.5f)
	{
		LED1(1);LED2(0);LED3(0);LED4(1);LED5(0);LED6(0);LED7(1);LED8(1);
	}
	else if(yaw>157.5f||yaw<-157.5f)
	{
		LED1(1);LED2(1);LED3(0);LED4(0);LED5(1);LED6(0);LED7(0);LED8(1);
	}
	else if(yaw>-157.5f&&yaw<-112.5f)
	{
		LED1(1);LED2(1);LED3(1);LED4(0);LED5(0);LED6(1);LED7(0);LED8(0);
	}
	else if(yaw>-112.5f&&yaw<-67.5f)
	{
		LED1(0);LED2(1);LED3(1);LED4(1);LED5(0);LED6(0);LED7(1);LED8(0);
	}
	else if(yaw>-67.5f&&yaw<-22.5f)
	{
		LED1(0);LED2(0);LED3(1);LED4(1);LED5(1);LED6(0);LED7(0);LED8(1);
	}
}
