#include "sd.h"
#include "led.h"

#define NULL 0

SD_Error state;
/* Private function prototypes -----------------------------------------------*/
FATFS fs;            // Work area (file system object) for logical drive
FIL fsrc, fdst;      // file objects
//BYTE buffer[512]; 	 // file copy buffer
FRESULT res;         // FatFs function common result code
UINT br, bw;         // File R/W count

char file_name[20];
char SD_Write_Data[300]="";

u8 SD_Card_Init(void)
{
	state=SD_Init();
	if(!(state==SD_OK))	
		return 0;
	
	file_name[0] = 0x31;
	file_name[1] = 0x32;
	file_name[2] = 0x33;
	file_name[3] = 0x34;
	file_name[4] = '.';
	file_name[5] = 't';
	file_name[6] = 'x';
	file_name[7] = 't';
	file_name[8] = 0;
	
	res = f_mount(0, &fs);
	res = f_open(&fsrc,file_name, FA_OPEN_ALWAYS|FA_READ|FA_WRITE);
	if(res==SD_OK)
		return 1;
	else
		return 0;
}
u8 SD_Card_Write(char *data, u16 num)
{
	res = f_lseek(&fsrc,fsrc.fsize); 
	res = f_write(&fsrc,data,num,(void *)&bw);	
	if(res==SD_OK)
		return 1;
	else
		return 0;
}
u8 SD_Card_Sync(void)
{
	res = f_sync(&fsrc); 
	if(res==SD_OK)
		return 1;
	else
		return 0;
}
u8 SD_Card_Close(void)
{
	res = f_close(&fsrc); 
	res = f_mount(0, NULL);
	if(res==SD_OK)
		return 1;
	else
		return 0;
}
