#include "usart2.h"

void Usart2_Init(u32 baudrate)
{
	GPIO_InitTypeDef GPIO_InitStructure;
  USART_InitTypeDef USART_InitStructure; 

  RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOD,ENABLE);

  RCC_APB1PeriphClockCmd(RCC_APB1Periph_USART2,ENABLE);

  GPIO_PinAFConfig(GPIOD, GPIO_PinSource5, GPIO_AF_USART2);
  GPIO_PinAFConfig(GPIOD, GPIO_PinSource6, GPIO_AF_USART2);

  /*
  *  Open_USARTx_TX -> PD5 , Open_USARTx_RX -PD6
  */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_5;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_UP;
  GPIO_Init(GPIOD, &GPIO_InitStructure);


  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_6;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_OD;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_Init(GPIOD, &GPIO_InitStructure);

  USART_InitStructure.USART_BaudRate = baudrate;
  USART_InitStructure.USART_WordLength = USART_WordLength_8b;
  USART_InitStructure.USART_StopBits = USART_StopBits_1;
  USART_InitStructure.USART_Parity = USART_Parity_No;
	USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_None;
  USART_InitStructure.USART_Mode = USART_Mode_Rx | USART_Mode_Tx;
  USART_Init(USART2, &USART_InitStructure);
  /* Enable the Open_USART Transmit interrupt: this interrupt is generated when the 
     Open_USARTx transmit data register is empty */
  USART_ITConfig(USART2,USART_IT_RXNE,ENABLE);

  USART_Cmd(USART2, ENABLE);
}
u8 TxBuffer_2[256];
u8 TxCounter_2=0;
u8 count_2=0; 

void Gps_Data_Anl(u8 uart_data);

void Uart2_IRQ(void)
{
	if(USART2->SR & USART_SR_ORE)//OREж
	{
		u8 com_data = USART2->DR;//USART_ClearFlag(USART1,USART_IT_ORE);
	}
	//ж
	if((USART2->SR & (1<<7))&&(USART2->CR1 & USART_CR1_TXEIE))//if(USART_GetITStatus(USART1,USART_IT_TXE)!=RESET)
	{
		USART2->DR = TxBuffer_2[TxCounter_2++]; //дDRжϱ־          
		if(TxCounter_2 == count_2)
		{
			USART2->CR1 &= ~USART_CR1_TXEIE;		//رTXEж//USART_ITConfig(USART1,USART_IT_TXE,DISABLE);
		}
	}
	//ж (ռĴǿ) 
	if(USART2->SR & (1<<5))//if(USART_GetITStatus(USART1, USART_IT_RXNE) != RESET)    
	{
		u8 com_data = USART2->DR;
		Gps_Data_Anl(com_data);
	}
}
/////////////////////////////////////////////////////////////////////////////////////////////////////

T_GPS_DATA Gps_Data;

void Gps_Data_Anl(u8 uart_data)
{
/*
POSLLH : 	B5 62 01 02 1C 00  ͷݣݳ282ֽУ
SOL			B5 62 01 06 34 00 					ݳ522ֽУ

*/
	static u8 gps_data_status = 0;
	static u8 gps_data_temp[100],gps_data_temp_cnt=0;
	
	switch(gps_data_status)
	{
		case 0:
						if(uart_data==0xB5)
							gps_data_status = 1;
					break;
		case 1:
						if(uart_data==0x62)
							gps_data_status = 2;
						else
							gps_data_status = 0;
					break;
		case 2:
						if(uart_data==0x01)
							gps_data_status = 3;
						else
							gps_data_status = 0;
					break;
		case 3:
						if(uart_data==0x02)
							gps_data_status = 11;
						else if(uart_data==0x06)
							gps_data_status = 21;
						else
							gps_data_status = 0;
					break;
/////////////////////////////////////////////////////////////////
		case 11:
						if(uart_data==0x1C)
							gps_data_status = 12;
						else
							gps_data_status = 0;
					break;
		case 12:
						if(uart_data==0x00)
						{
							gps_data_temp_cnt=0;
							gps_data_status = 13;
						}
						else
							gps_data_status = 0;
					break;
		case 13:		//POSLLH
						gps_data_temp[gps_data_temp_cnt++] = uart_data;
						if(gps_data_temp_cnt==30)		//
						{
							u8 ck_a=0,ck_b=0;
							gps_data_status = 0;
							ck_a += 1;
							ck_b += ck_a;
							ck_a += 2;
							ck_b += ck_a;
							ck_a += 0x1C;
							ck_b += ck_a;
							ck_b += ck_a;
							for(u8 i=0;i<28;i++)			//У
							{
								ck_a += gps_data_temp[i];
								ck_b += ck_a;
							}
							if(ck_a==gps_data_temp[28]&&ck_b==gps_data_temp[29])	//Уͨ
							{
								Gps_Data.Lng_32 = gps_data_temp[7]<<24|gps_data_temp[6]<<16|gps_data_temp[5]<<8|gps_data_temp[4];
								Gps_Data.Lng = (double)Gps_Data.Lng_32 / 10000000;
								Gps_Data.Lat_32 = gps_data_temp[11]<<24|gps_data_temp[10]<<16|gps_data_temp[9]<<8|gps_data_temp[8];
								Gps_Data.Lat = (double)Gps_Data.Lat_32 / 10000000;
								vs32 _temp;
								_temp = gps_data_temp[15]<<24|gps_data_temp[14]<<16|gps_data_temp[13]<<8|gps_data_temp[12];
								Gps_Data.Alt = (double)_temp / 1000;
								//_temp = gps_data_temp[19]<<24|gps_data_temp[18]<<16|gps_data_temp[17]<<8|gps_data_temp[16];
								//Gps_Data.Alt = (double)_temp / 1000;
								_temp = gps_data_temp[23]<<24|gps_data_temp[22]<<16|gps_data_temp[21]<<8|gps_data_temp[20];
								Gps_Data.Hac = (float)_temp / 1000;
								_temp = gps_data_temp[27]<<24|gps_data_temp[26]<<16|gps_data_temp[25]<<8|gps_data_temp[24];
								Gps_Data.Vac = (float)_temp / 1000;
							}
						}
					break;
/////////////////////////////////////////////////////////
		case 21:		//SOL
						if(uart_data==0x34)
							gps_data_status = 22;
						else
							gps_data_status = 0;
					break;
		case 22:
						if(uart_data==0x00)
						{
							gps_data_temp_cnt=0;
							gps_data_status = 23;
						}
						else
							gps_data_status = 0;
					break;
		case 23:
						gps_data_temp[gps_data_temp_cnt++] = uart_data;
						if(gps_data_temp_cnt==54)		//
						{
							u8 ck_a=0,ck_b=0;
							gps_data_status = 0;
							ck_a += 1;
							ck_b += ck_a;
							ck_a += 6;
							ck_b += ck_a;
							ck_a += 0x34;
							ck_b += ck_a;
							ck_b += ck_a;
							for(u8 i=0;i<52;i++)			//У
							{
								ck_a += gps_data_temp[i];
								ck_b += ck_a;
							}
							if(ck_a==gps_data_temp[52]&&ck_b==gps_data_temp[53])	//Уͨ
							{
								Gps_Data.FixSta = gps_data_temp[10];
								vs32 _temp;
								_temp = gps_data_temp[43]<<24|gps_data_temp[42]<<16|gps_data_temp[41]<<8|gps_data_temp[40];
								Gps_Data.SOG = (float)_temp / 100;
								Gps_Data.SVN = gps_data_temp[47];
							}
						}
					break;
	}
	
}
