/* Includes ------------------------------------------------------------------*/
#include "config.h"

__IO u8 MS5611_Cal_Flag = 0;
__IO u8 AK8975_Cal_Flag = 0;
__IO u16 DEBUG_CNT;

int main(void)
{
	Usart1_Init(500000);
	Usart2_Init(19200);
	Tim_Pwm_In_Init();	//벶
	Tim_Pwm_Out_Init();
	Timer_Sys_Init(500);
	I2C1_RESET();
	I2C1_INIT(0X00,400000,1,1,1,1);
	Led_Init();
	Spi1_Init();
	Nvic_Init();
	Nrf24l01_Init(MODEL_TX2,40);
 	if(Nrf24l01_Check())	Uart1_Put_String("NRF24L01 IS OK !\r\n");
 	else 									Uart1_Put_String("NRF24L01 IS NOT OK !\r\n");
	MPU6050_Init();
	
	Uart1_Put_String("Welcome to ANO TC!\r\n");
	
	if(SD_Card_Init())
		Uart1_Put_String("SD_Card OK!\r\n");
	else
		Uart1_Put_String("SD_Card Error!\r\n");

	Data_Read();
	
while (1)
{
	if(AK8975_Cal_Flag)
	{
		AK8975_Cal_Flag = 0;
		AK8975_Cal();
	}
	if(MS5611_Cal_Flag)
	{
		MS5611_Cal_Flag = 0;
		MS5611_Cal();
	}
	if(Data_Check)
	{
		Data_Check = 0;
		Send_Data();
	}
}

}
