#ifndef __RPC_PMAP_PROT_H__
#define __RPC_PMAP_PROT_H__

#include <rpc/xdr.h>

/* The following procedures are supported by the protocol:
 *
 * PMAPPROC_NULL() returns ()
 * 	takes nothing, returns nothing
 *
 * PMAPPROC_SET(struct pmap) returns (bool_t)
 * 	TRUE is success, FALSE is failure.  Registers the tuple
 *	[prog, vers, prot, port].
 *
 * PMAPPROC_UNSET(struct pmap) returns (bool_t)
 *	TRUE is success, FALSE is failure.  Un-registers pair
 *	[prog, vers].  prot and port are ignored.
 *
 * PMAPPROC_GETPORT(struct pmap) returns (long unsigned).
 *	0 is failure.  Otherwise returns the port number where the pair
 *	[prog, vers] is registered.  It may lie!
 *
 * PMAPPROC_DUMP() RETURNS (struct pmaplist *)
 *
 * PMAPPROC_CALLIT(unsigned, unsigned, unsigned, string<>)
 * 	RETURNS (port, string<>);
 * usage: encapsulatedresults = PMAPPROC_CALLIT(prog, vers, proc, encapsulatedargs);
 * 	Calls the procedure on the local machine.  If it is not registered,
 *	this procedure is quite; ie it does not return error information!!!
 *	This procedure only is supported on rpc/udp and calls via
 *	rpc/udp.  This routine only passes null authentication parameters.
 *	This file has no interface to xdr routines for PMAPPROC_CALLIT.
 *
 * The service supports remote procedure calls on udp/ip or tcp/ip socket 111.
 */

#define PMAPPORT		((unsigned short)111)
#define PMAPPROG		((unsigned long)100000)
#define PMAPVERS		((unsigned long)2)
#define PMAPVERS_PROTO		((unsigned long)2)
#define PMAPVERS_ORIG		((unsigned long)1)
#define PMAPPROC_NULL		((unsigned long)0)
#define PMAPPROC_SET		((unsigned long)1)
#define PMAPPROC_UNSET		((unsigned long)2)
#define PMAPPROC_GETPORT	((unsigned long)3)
#define PMAPPROC_DUMP		((unsigned long)4)
#define PMAPPROC_CALLIT		((unsigned long)5)

struct pmap {
	long unsigned pm_prog;
	long unsigned pm_vers;
	long unsigned pm_prot;
	long unsigned pm_port;
};

extern bool_t xdr_pmap (XDR *__xdrs, struct pmap *__regs);

#endif
