/*
 * File      : application.c
 * This file is part of RT-Thread RTOS
 * COPYRIGHT (C) 2006, RT-Thread Development Team
 *
 * The license and distribution terms for this file may be
 * found in the file LICENSE in this distribution or at
 * http://www.rt-thread.org/license/LICENSE
 *
 * Change Logs:
 * Date           Author       Notes
 * 2009-01-05     Bernard      the first version
 */

/**
 * @addtogroup STM32
 */
/*@{*/

#include <stdio.h>
#include "stm32f4xx.h"
#include <board.h>
#include <rtthread.h>

#ifdef RT_USING_DFS
#include <dfs_init.h>
#include <dfs_fs.h>
#include <drivers/mmcsd_core.h>
#include "stm32f4xx_sd.h"
#ifdef RT_USING_DFS_ELMFAT
#include <dfs_elm.h>
#endif
#endif

#include "LED.h"
#include "sysconfig.h"
#include "ano_tc_stm32_i2c.h"
#include "mpu6050.h"
#include "ms5611.h"
#include "usart_gps.h"
#include "usart_dt.h"
#include "timer_hw.h"
#include "Tim_Pwm_In.h"
#include "tim_pwm_out.h"
#include "nrf24.h"

void rt_init_thread_entry(void* parameter)
{
	rt_err_t resault;
	resault = rt_event_init(&Evt_Sys,"Evt_Senser",RT_IPC_FLAG_FIFO);
	if(resault != RT_EOK)	return;
	
	Usart1_Init(115200);
	Usart2_Init(115200);
	ANO_TC_I2C1_RESET();
	ANO_TC_I2C1_INIT(0X00,400000,1,1,1,1);
	MPU6050_Init();
	MS5611_Init();
	Tim_Pwm_In_Init();
	Tim_Pwm_Out_Init();
	Timer_Sys_Init(500);
	Spi1_Init(); 
	Nrf24l01_Init(MODEL_TX2,40);
	if(Nrf24l01_Check())	
		rt_kprintf("NRF24L01 IS OK !\n");
 	else 					
		rt_kprintf("NRF24L01 IS NOT OK !\n");
	
#ifdef RT_USING_DFS	
	rt_mmcsd_core_init();
    rt_mmcsd_blk_init();
    stm32f4xx_sdio_init();
    rt_thread_delay(RT_TICK_PER_SECOND);

	/* initialize the device file system */
	dfs_init();
#ifdef RT_USING_DFS_ELMFAT
	/* initialize the elm chan FatFS file system*/
	elm_init();
	if (dfs_mount("sd0", "/", "elm", 0, 0) == 0)
	{
		rt_kprintf("SDCard File System initialized!\n");
	}
	else
	{
		rt_kprintf("SDCard File System initialzation failed!\n");
	}
#endif
#endif

	Data_Read();
	Timer_Sys_Run(1);
}

ALIGN(RT_ALIGN_SIZE)
static char thread_led1_stack[1024];
struct rt_thread thread_led1;
//LED_STA	
//0:NORMAL	1:CAL_MAG
u8	LED_STA = 0;
static void rt_thread_entry_led1(void* parameter)
{
    Led_Init();
	u16 time;
		//rt_kprintf("A", str_buffer);
    while (1)
    {
		switch(LED_STA)
		{
			case 0:
				time = Led_Flash_Normal();
				rt_thread_delay(time);
				break;
			case 1:
				time = Led_Flash_CalMAG();
				rt_thread_delay(time);
				break;
			case 2:
				time = Led_Flash_CalMAG();
				rt_thread_delay(time);
				break;
			default:
				LED_STA = 0;
				break;
		}
    }
}

int rt_application_init()
{
    rt_thread_t init_thread;

    init_thread = rt_thread_create("init",
                                   rt_init_thread_entry, RT_NULL,
                                   2048, 0, 200);

    if (init_thread != RT_NULL)
        rt_thread_startup(init_thread);

    //------- init led1 thread
    rt_thread_init(&thread_led1,
                   "led1",
                   rt_thread_entry_led1,
                   RT_NULL,
                   &thread_led1_stack[0],
                   sizeof(thread_led1_stack),THD_LED_P,2);
    rt_thread_startup(&thread_led1);

    //------- 
    rt_thread_init(&thd_6050,
                   "6050",
                   rt_thread_entry_6050,
                   RT_NULL,
                   &thread_6050_stack[0],
                   sizeof(thread_6050_stack),THD_6050_P,5);
    rt_thread_startup(&thd_6050);
		
	//------- 
    rt_thread_init(&thd_ATT,
                   "ATT",
                   rt_thread_entry_ATT,
                   RT_NULL,
                   &thread_ATT_stack[0],
                   sizeof(thread_ATT_stack),THD_ATT_P,5);
    rt_thread_startup(&thd_ATT);
	
	//------- 
    rt_thread_init(&thd_POS,
                   "POS",
                   rt_thread_entry_POS,
                   RT_NULL,
                   &thread_POS_stack[0],
                   sizeof(thread_POS_stack),THD_POS_P,5);
    rt_thread_startup(&thd_POS);
	
	//------- 
    rt_thread_init(&thd_RC,
                   "RC",
                   rt_thread_entry_RC,
                   RT_NULL,
                   &thread_RC_stack[0],
                   sizeof(thread_RC_stack),THD_RC_P,5);
    rt_thread_startup(&thd_RC);
	
	//------- 
    rt_thread_init(&thd_DataTrans,
                   "DT",
                   rt_thread_entry_DataTrans,
                   RT_NULL,
                   &thread_DataTrans_stack[0],
                   sizeof(thread_DataTrans_stack),THD_DT_P,5);
    rt_thread_startup(&thd_DataTrans);

    return 0;
}

/*@}*/
