#include <stdio.h>
#include "stm32f4xx.h"
#include <rtthread.h>
#include "sysconfig.h"
#include "mpu6050.h"
#include "ms5611.h"
#include "ak8975.h"
#include "usart_gps.h"
#include "Tim_Pwm_In.h"
#include "imu.h"
#include "data_transfer.h"
#include "rc.h"
/******************************************************************************/
/******************************************************************************/
struct rt_event Evt_Sys;
/******************************************************************************/
//6050̣߳1msһΣεĽƽATT߳
T_int16_xyz 	Acc,Gyr;	//ۺϺĴ
/******************************************************************************/
ALIGN(RT_ALIGN_SIZE)
char thread_6050_stack[1024];
struct rt_thread thd_6050;
void rt_thread_entry_6050(void* parameter)
{
	static rt_uint32_t ev;
	static T_int16_xyz mpu6050_dataacc1,mpu6050_dataacc2,mpu6050_datagyr1,mpu6050_datagyr2;
	static u8 d_6050_sta = 0;
	static u8 send_cnt = 0;
	
    while(1)
    {
		rt_event_recv(&Evt_Sys,EVT_SS_6050,RT_EVENT_FLAG_AND|RT_EVENT_FLAG_CLEAR,RT_WAITING_FOREVER,&ev);
		d_6050_sta++;
		if(d_6050_sta==1)
			MPU6050_Dataanl(&mpu6050_dataacc1,&mpu6050_datagyr1);
		else
		{
			d_6050_sta = 0;
			MPU6050_Dataanl(&mpu6050_dataacc2,&mpu6050_datagyr2);
			Acc.X = (mpu6050_dataacc1.X+mpu6050_dataacc2.X)/2;
			Acc.Y = (mpu6050_dataacc1.Y+mpu6050_dataacc2.Y)/2;
			Acc.Z = (mpu6050_dataacc1.Z+mpu6050_dataacc2.Z)/2;
			Gyr.X = (mpu6050_datagyr1.X+mpu6050_datagyr2.X)/2;
			Gyr.Y = (mpu6050_datagyr1.Y+mpu6050_datagyr2.Y)/2;
			Gyr.Z = (mpu6050_datagyr1.Z+mpu6050_datagyr2.Z)/2;
			rt_event_send(&Evt_Sys,EVT_CL_ATT);
		}
		send_cnt++;
		if(send_cnt==5)		//send_cnt  MS
		{
			send_cnt = 0;
			Send_Senser = 1;
		}
    }
}
/******************************************************************************/
//ATT߳,2msһ
//̬㷨,ֻ60508975,еǰ̬,rol,pit,yawǶ
T_int16_xyz		Acc_AVG;	
T_int16_xyz		Mag;
vs32			Alt;
T_float_angle 	Att_Angle;	//ATT̬
float			Mag_Heading;
/******************************************************************************/
ALIGN(RT_ALIGN_SIZE)
char thread_ATT_stack[1024];
struct rt_thread thd_ATT;
void rt_thread_entry_ATT(void* parameter)		
{
	static rt_uint32_t ev;
	static u8 send_cnt = 0;
	
	while(1)
	{
		rt_event_recv(&Evt_Sys,EVT_CL_ATT,RT_EVENT_FLAG_AND|RT_EVENT_FLAG_CLEAR,RT_WAITING_FOREVER,&ev);
		Prepare_Data(&Acc,&Acc_AVG);
		IMUupdate(&Gyr,&Acc_AVG,&Att_Angle);
		//ȡ
		if(rt_event_recv(&Evt_Sys,EVT_SS_8975,RT_EVENT_FLAG_AND|RT_EVENT_FLAG_CLEAR,0,&ev)==RT_EOK)
		{
			AK8975_GetValue(&Mag);
			Get_CompassAngle(&Mag,&Acc_AVG,&Mag_Heading);	//ÿ43
		}
		//ȡѹ
		if(rt_event_recv(&Evt_Sys,EVT_SS_5611,RT_EVENT_FLAG_AND|RT_EVENT_FLAG_CLEAR,0,&ev)==RT_EOK)
		{
			Alt = MS5611_GetValue();	//ÿ43
		}
		Control(&Att_Angle,&Gyr,&Rc_D,RC_Control.ARMED);
		
		send_cnt++;
		if(send_cnt==5)	//send_cnt * 2  MS
		{
			send_cnt = 0;
			Send_Status = 1;
		}
		
		Debug_cnt++;
	}
}
/******************************************************************************/
//POS߳
T_GPS_Data		Gps_Data;
/******************************************************************************/
ALIGN(RT_ALIGN_SIZE)
char thread_POS_stack[1024];
struct rt_thread thd_POS;
void rt_thread_entry_POS(void* parameter)		
{
	rt_uint32_t ev;
	
	while(1)
	{
		rt_event_recv(&Evt_Sys,EVT_GPS_GET,RT_EVENT_FLAG_AND|RT_EVENT_FLAG_CLEAR,RT_WAITING_FOREVER,&ev);
		Get_GpsData(&Gps_Data);	
		Send_GpsData = 1;
	}
}
/******************************************************************************/
//RC߳
T_RC_Data 		Rc_D;
T_Control		RC_Control;
/******************************************************************************/
ALIGN(RT_ALIGN_SIZE)
char thread_RC_stack[1024];
struct rt_thread thd_RC;
void rt_thread_entry_RC(void* parameter)		
{
	rt_uint32_t ev;

	while(1)
	{
		if(rt_event_recv(&Evt_Sys,EVT_RC_GET,RT_EVENT_FLAG_AND|RT_EVENT_FLAG_CLEAR,25,&ev)==RT_ETIMEOUT)
			rt_kprintf("RC_E");
		else
		{
			Rc_GetValue(&Rc_D);
			RC_Analyse(&Rc_D,&RC_Control);
			Send_RCData = 1;
		}
	}
}
/******************************************************************************/
//DATA_TRANSFER߳
/******************************************************************************/
ALIGN(RT_ALIGN_SIZE)
char thread_DataTrans_stack[1024];
struct rt_thread thd_DataTrans;
void rt_thread_entry_DataTrans(void* parameter)		
{
	while(1)
	{
		Data_Exchange();
		rt_thread_delay(1);
	}
}
