#include "timer_hw.h"

#define SYS_TIMx					TIM6
#define SYS_RCC_TIMx			RCC_APB1Periph_TIM6

void Timer_Sys_Init(u32 period_num)
{
	TIM_TimeBaseInitTypeDef TIM_TimeBaseStructure;
	
	//ãʱͱȽãֻ趨ʱԲOCȽ
	RCC_APB1PeriphClockCmd(SYS_RCC_TIMx,ENABLE);
	
	TIM_DeInit(SYS_TIMx);

	TIM_TimeBaseStructure.TIM_Period=period_num;//װֵ
	//prescaler is 1200,that is 168000000/168/500=2000Hz;
	TIM_TimeBaseStructure.TIM_Prescaler=84-1;//Ƶϵ

	TIM_TimeBaseStructure.TIM_ClockDivision=TIM_CKD_DIV1; //or TIM_CKD_DIV2 or TIM_CKD_DIV4

	TIM_TimeBaseStructure.TIM_CounterMode=TIM_CounterMode_Up;
	
	TIM_TimeBaseInit(SYS_TIMx,&TIM_TimeBaseStructure);

	TIM_ClearFlag(SYS_TIMx,TIM_FLAG_Update);

	TIM_ITConfig(SYS_TIMx,TIM_IT_Update,ENABLE);

//	TIM_Cmd(SYS_TIMx,ENABLE);
}
void Timer_Sys_Run(u8 ena)
{
	if(ena)
		TIM_Cmd(SYS_TIMx,ENABLE);
	else
		TIM_Cmd(SYS_TIMx,DISABLE);
}
