/**
  ******************************************************************************
  * @file    IO_Toggle/stm32f4xx_it.c
  * @author  MCD Application Team
  * @version V1.0.0
  * @date    19-September-2011
  * @brief   Main Interrupt Service Routines.
  *          This file provides template for all exceptions handler and
  *          peripherals interrupt service routine.
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2011 STMicroelectronics</center></h2>
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "stm32f4xx.h"
#include <rtthread.h>
#include "board.h"

/** @addtogroup STM32F4_Discovery_Peripheral_Examples
  * @{
  */

/** @addtogroup IO_Toggle
  * @{
  */

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/******************************************************************************/
/*            Cortex-M4 Processor Exceptions Handlers                         */
/******************************************************************************/

/**
  * @brief   This function handles NMI exception.
  * @param  None
  * @retval None
  */
void NMI_Handler(void)
{
}

/**
  * @brief  This function handles Hard Fault exception.
  * @param  None
  * @retval None
  */
//void HardFault_Handler(void)
//{
//    // definition in libcpu/arm/cortex-m4/context_*.S
//}

/**
  * @brief  This function handles Memory Manage exception.
  * @param  None
  * @retval None
  */
void MemManage_Handler(void)
{
  /* Go to infinite loop when Memory Manage exception occurs */
  while (1)
  {
  }
}

/**
  * @brief  This function handles Bus Fault exception.
  * @param  None
  * @retval None
  */
void BusFault_Handler(void)
{
  /* Go to infinite loop when Bus Fault exception occurs */
  while (1)
  {
  }
}

/**
  * @brief  This function handles Usage Fault exception.
  * @param  None
  * @retval None
  */
void UsageFault_Handler(void)
{
  /* Go to infinite loop when Usage Fault exception occurs */
  while (1)
  {
  }
}

/**
  * @brief  This function handles SVCall exception.
  * @param  None
  * @retval None
  */
void SVC_Handler(void)
{
}

/**
  * @brief  This function handles Debug Monitor exception.
  * @param  None
  * @retval None
  */
void DebugMon_Handler(void)
{
}

/**
  * @brief  This function handles PendSVC exception.
  * @param  None
  * @retval None
  */
//void PendSV_Handler(void)
//{
//    // definition in libcpu/arm/cortex-m4/context_*.S
//}

/**
  * @brief  This function handles SysTick Handler.
  * @param  None
  * @retval None
  */
//void SysTick_Handler(void)
//{
//    // definition in boarc.c
//}

/******************************************************************************/
/*                 STM32F4xx Peripherals Interrupt Handlers                   */
/*  Add here the Interrupt Handler for the used peripheral(s) (PPP), for the  */
/*  available peripheral interrupt handler's name please refer to the startup */
/*  file (startup_stm32f4xx.s).                                               */
/******************************************************************************/

/**
  * @brief  This function handles PPP interrupt request.
  * @param  None
  * @retval None
  */
/*void PPP_IRQHandler(void)
{
}*/

#include "sysconfig.h"


#include "ano_tc_stm32_i2c.h"
void I2C1_EV_IRQHandler(void)
{
	ANO_TC_I2C1_EV_IRQ();
}
void I2C1_ER_IRQHandler(void)
{
	ANO_TC_I2C1_ER_IRQ();
}
#include "Tim_Pwm_In.h"
void TIM3_IRQHandler(void)		
{	 
	Tim3_Pwm_In_Irq();
}
void TIM2_IRQHandler(void)		
{	 
	Tim2_Pwm_In_Irq();
}
void TIM1_BRK_TIM9_IRQHandler(void)		
{	 
	Tim9_Pwm_In_Irq();
}
void TIM1_UP_TIM10_IRQHandler(void)		
{	 
	Tim10_Pwm_In_Irq();
}
void TIM1_TRG_COM_TIM11_IRQHandler(void)		
{	 
	Tim11_Pwm_In_Irq();
}
#include "mpu6050.h"
#include "ak8975.h"
#include "ms5611.h"
u32				Debug_cnt=0,Debug_cntshow=0;
void TIM6_DAC_IRQHandler(void)		
{	 
	static u16 s1cnt=0;
	static u16 AK8975_sta=0,AK8975_cnt=10,MS5611_sta=0,MS5611_cnt=10;
	static u8 tim_cnt=0,ak8975_iic_ok=0,ms5611_iic_ok=0;
	if(TIM6->SR & TIM_IT_Update)		//if ( TIM_GetITStatus(TIM3 , TIM_IT_Update) != RESET ) 
	{  
		tim_cnt++;
		s1cnt++;
		if(s1cnt==2000)
		{
			s1cnt = 0;
			Debug_cntshow = Debug_cnt;
			Debug_cnt = 0;
		}
		if(tim_cnt%2)
		{
			if(!MPU6050_Read())
			{
			}
		}
		else
		{
			if(AK8975_cnt)	AK8975_cnt--;
			if(MS5611_cnt)	MS5611_cnt--;
			
			if(AK8975_cnt==0)
			{
				switch(AK8975_sta)
				{
					case 0:
							ak8975_iic_ok = AK8975_Run();
							if(ak8975_iic_ok)	
							{
								AK8975_sta = 1;
								AK8975_cnt = 10;	//10msʼжǷOK
							}
							break;
					case 1:
							ak8975_iic_ok = AK8975_Check1();
							if(ak8975_iic_ok)	
								AK8975_sta = 2;
							break;
					case 2:
							ak8975_iic_ok = AK8975_Check2();
							if(ak8975_iic_ok)	
								AK8975_sta = 3;
							else							
								AK8975_sta = 1;
							break;
					case 3:
							ak8975_iic_ok = AK8975_Read();
							if(ak8975_iic_ok)	
								AK8975_sta = 4;
							else							
								AK8975_sta = 0;
							break;
					case 4:
							AK8975_Cal();
							rt_event_send(&Evt_Sys,EVT_SS_8975);
							AK8975_sta = 0;
							AK8975_cnt = 10;
							break;
				}
			}
			else if(MS5611_cnt==0)
			{
				switch(MS5611_sta)
				{
					case 0:
							ms5611_iic_ok = ms5611_reset();
							if(ms5611_iic_ok)
							{
								MS5611_sta = 1;
								MS5611_cnt = 20;
							}
							break;
					case 1:
							ms5611_iic_ok = ms5611_start_t();
							if(ms5611_iic_ok)
							{
								MS5611_sta = 2;
								MS5611_cnt = 10;
							}
							break;
					case 2:
							ms5611_iic_ok = ms5611_read_adc_t();
							if(ms5611_iic_ok)
							{
								MS5611_sta = 3;
								MS5611_cnt = 1;
							}
							break;
					case 3:
							ms5611_iic_ok = ms5611_start_p();
							if(ms5611_iic_ok)
							{
								MS5611_sta = 4;
								MS5611_cnt = 10;
							}
							break;
					case 4:
							ms5611_iic_ok = ms5611_read_adc_p();
							if(ms5611_iic_ok)
							{
								MS5611_sta = 5;
								MS5611_cnt = 1;
							}
							break;
					case 5:
							ms5611_iic_ok = ms5611_calculate();
							if(ms5611_iic_ok)
							{
								rt_event_send(&Evt_Sys,EVT_SS_5611);
								MS5611_sta = 1;
								MS5611_cnt = 1;
							}
							break;
				}
			}
		}
	}
	TIM6->SR = ~TIM_FLAG_Update;//TIM_ClearITPendingBit(TIM3 , TIM_FLAG_Update);   //??????
}
#include "usart_gps.h"
void USART2_IRQHandler(void)  //??????
{
	Uart2_IRQ();
}
#include "usart_dt.h"
void USART1_IRQHandler(void)  //??????
{
	Uart1_IRQ();
}
/**
  * @}
  */

/**
  * @}
  */

/******************* (C) COPYRIGHT 2011 STMicroelectronics *****END OF FILE****/
