#include "led.h"
#include <rtthread.h>
//static void _led_delay(u16 _ms)
//{
//	for(u16 i=_ms;i>0;i--)
//	{
//		for(u16 j=5000;j>0;j--)
//			for(u16 k=2;k>0;k--)
//			;
//	}
//}
#define LED_DELAYTIME	(RT_TICK_PER_SECOND/8)
void Led_Init(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;
  
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOE | RCC_AHB1Periph_GPIOC, ENABLE);					 
			 
	GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_0 | GPIO_Pin_1 | GPIO_Pin_2 | GPIO_Pin_3 | GPIO_Pin_4;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_UP;
	GPIO_Init(GPIOE, &GPIO_InitStructure);
	
	GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_13 | GPIO_Pin_14 | GPIO_Pin_15;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_UP;
	GPIO_Init(GPIOC, &GPIO_InitStructure);
	
	Led_Control(9,0);
	rt_thread_delay(LED_DELAYTIME);
	Led_Control(1,1);
	rt_thread_delay(LED_DELAYTIME);
	Led_Control(2,1);
	rt_thread_delay(LED_DELAYTIME);
	Led_Control(3,1);
	rt_thread_delay(LED_DELAYTIME);
	Led_Control(4,1);
	rt_thread_delay(LED_DELAYTIME);
	Led_Control(5,1);
	rt_thread_delay(LED_DELAYTIME);
	Led_Control(6,1);
	rt_thread_delay(LED_DELAYTIME);
	Led_Control(7,1);
	rt_thread_delay(LED_DELAYTIME);
	Led_Control(8,1);
	rt_thread_delay(LED_DELAYTIME);
	Led_Control(1,0);
	rt_thread_delay(LED_DELAYTIME);
	Led_Control(2,0);
	rt_thread_delay(LED_DELAYTIME);
	Led_Control(3,0);
	rt_thread_delay(LED_DELAYTIME);
	Led_Control(4,0);
	rt_thread_delay(LED_DELAYTIME);
	Led_Control(5,0);
	rt_thread_delay(LED_DELAYTIME);
	Led_Control(6,0);
	rt_thread_delay(LED_DELAYTIME);
	Led_Control(7,0);
	rt_thread_delay(LED_DELAYTIME);
	Led_Control(8,0);
}
void Led_Control(u8 num,u8 state)
{
	switch(num)
	{
		case 1: LED1(state);break;
		case 2: LED2(state);break;
		case 3: LED3(state);break;
		case 4: LED4(state);break;
		case 5: LED5(state);break;
		case 6: LED6(state);break;
		case 7: LED7(state);break;
		case 8: LED8(state);break;
		default : LED1(state);LED2(state);LED3(state);LED4(state);LED5(state);LED6(state);LED7(state);LED8(state);break;
	}
}
void Led_Show_Yaw(float yaw)
{
	if(yaw>-22.5f&&yaw<22.5f)
	{
		LED1(1);LED2(0);LED3(0);LED4(1);LED5(1);LED6(1);LED7(0);LED8(0);
	}
	else if(yaw>22.5f&&yaw<67.5f)
	{
		LED1(0);LED2(1);LED3(0);LED4(0);LED5(1);LED6(1);LED7(1);LED8(0);
	}
	else if(yaw>67.5f&&yaw<112.5f)
	{
		LED1(0);LED2(0);LED3(1);LED4(0);LED5(0);LED6(1);LED7(1);LED8(1);
	}
	else if(yaw>112.5f&&yaw<157.5f)
	{
		LED1(1);LED2(0);LED3(0);LED4(1);LED5(0);LED6(0);LED7(1);LED8(1);
	}
	else if(yaw>157.5f||yaw<-157.5f)
	{
		LED1(1);LED2(1);LED3(0);LED4(0);LED5(1);LED6(0);LED7(0);LED8(1);
	}
	else if(yaw>-157.5f&&yaw<-112.5f)
	{
		LED1(1);LED2(1);LED3(1);LED4(0);LED5(0);LED6(1);LED7(0);LED8(0);
	}
	else if(yaw>-112.5f&&yaw<-67.5f)
	{
		LED1(0);LED2(1);LED3(1);LED4(1);LED5(0);LED6(0);LED7(1);LED8(0);
	}
	else if(yaw>-67.5f&&yaw<-22.5f)
	{
		LED1(0);LED2(0);LED3(1);LED4(1);LED5(1);LED6(0);LED7(0);LED8(1);
	}
}
/******************************************************************************/
//
/******************************************************************************/
static u8 sta;
u16 Led_Flash_Normal(void)
{
	static u8 cnt = 0;
	u16 _return;
	if(sta!=0)
	{
		sta = 0;
		cnt = 0;
	}
	switch(cnt)
	{
		case 0:
			cnt++;
			Led_Control(9,1);
			_return = RT_TICK_PER_SECOND/15;
			break;
		case 1:
			cnt++;
			Led_Control(9,0);
			_return = RT_TICK_PER_SECOND/15;
			break;
		case 2:
			cnt++;
			Led_Control(9,1);
			_return = RT_TICK_PER_SECOND/15;
			break;
		case 3:
			cnt++;
			Led_Control(9,0);
			_return = RT_TICK_PER_SECOND/15;
			break;
		case 4:
			cnt++;
			Led_Control(9,1);
			_return = RT_TICK_PER_SECOND/15;
			break;
		case 5:
			cnt++;
			Led_Control(9,0);
			_return = RT_TICK_PER_SECOND;
			break;
		default:
			cnt = 0;
			break;
	}
	
	return _return;
}
u16 Led_Flash_CalMAG(void)
{
	static u8 cnt = 0;
	u16 _return;
	if(sta!=1)
	{
		sta = 1;
		cnt = 0;
	}
	switch(cnt)
	{
		case 0:
			cnt++;
			Led_Control(9,1);
			_return = RT_TICK_PER_SECOND/15;
			break;
		case 1:
			cnt++;
			Led_Control(9,0);
			_return = RT_TICK_PER_SECOND/15;
			break;
		case 2:
			cnt++;
			Led_Control(9,1);
			_return = RT_TICK_PER_SECOND/15;
			break;
		case 3:
			cnt++;
			Led_Control(9,0);
			_return = RT_TICK_PER_SECOND/15;
			break;
		case 4:
			cnt++;
			Led_Control(9,1);
			_return = RT_TICK_PER_SECOND/15;
			break;
		case 5:
			cnt = 0;
			Led_Control(9,0);
			_return = RT_TICK_PER_SECOND/15;
			break;
		default:
			cnt = 0;
			break;
	}
	
	return _return;
}


