#include "nrf24.h"
//***************************************NRF24L01Ĵָ*******************************************************
#define NRF_READ_REG        0x00  	// Ĵָ
#define NRF_WRITE_REG       0x20 	// дĴָ
#define R_RX_PL_WID   	0x60
#define RD_RX_PLOAD     0x61  	// ȡָ
#define WR_TX_PLOAD     0xA0  	// дָ
#define FLUSH_TX        0xE1 	// ϴ FIFOָ
#define FLUSH_RX        0xE2  	// ϴ FIFOָ
#define REUSE_TX_PL     0xE3  	// ظװָ
#define NOP             0xFF  	// 
//*************************************SPI(nRF24L01)Ĵַ****************************************************
#define CONFIG          0x00  // շ״̬CRCУģʽԼշ״̬Ӧʽ
#define EN_AA           0x01  // ԶӦ
#define EN_RXADDR       0x02  // ŵ
#define SETUP_AW        0x03  // շַ
#define SETUP_RETR      0x04  // Զط
#define RF_CH           0x05  // Ƶ
#define RF_SETUP        0x06  // ʡĹ
#define NRFRegSTATUS    0x07  // ״̬Ĵ
#define OBSERVE_TX      0x08  // ͼ⹦
#define CD              0x09  // ַ           
#define RX_ADDR_P0      0x0A  // Ƶ0ݵַ
#define RX_ADDR_P1      0x0B  // Ƶ1ݵַ
#define RX_ADDR_P2      0x0C  // Ƶ2ݵַ
#define RX_ADDR_P3      0x0D  // Ƶ3ݵַ
#define RX_ADDR_P4      0x0E  // Ƶ4ݵַ
#define RX_ADDR_P5      0x0F  // Ƶ5ݵַ
#define TX_ADDR         0x10  // ͵ַĴ
#define RX_PW_P0        0x11  // Ƶ0ݳ
#define RX_PW_P1        0x12  // Ƶ1ݳ
#define RX_PW_P2        0x13  // Ƶ2ݳ
#define RX_PW_P3        0x14  // Ƶ3ݳ
#define RX_PW_P4        0x15  // Ƶ4ݳ
#define RX_PW_P5        0x16  // Ƶ5ݳ
#define FIFO_STATUS     0x17  // FIFOջջ״̬Ĵ
//**************************************************************************************
//*********************************************NRF24L01*************************************
#define RX_DR				6		//жϱ־
#define TX_DS				5
#define MAX_RT			4

#define SPI_CE_H()   GPIO_SetBits(GPIOC, GPIO_Pin_0) 
#define SPI_CE_L()   GPIO_ResetBits(GPIOC, GPIO_Pin_0)

#define SPI_CSN_H()  GPIO_SetBits(GPIOA, GPIO_Pin_4)
#define SPI_CSN_L()  GPIO_ResetBits(GPIOA, GPIO_Pin_4)

void Spi1_Init(void)
{
	SPI_InitTypeDef SPI_InitStructure; 
	GPIO_InitTypeDef GPIO_InitStructure;
	
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOA, ENABLE);
	RCC_APB1PeriphClockCmd(RCC_AHB1Periph_GPIOC, ENABLE);
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_SPI1, ENABLE);
	
	GPIO_PinAFConfig(GPIOA, GPIO_PinSource5, GPIO_AF_SPI1);
  GPIO_PinAFConfig(GPIOA, GPIO_PinSource6, GPIO_AF_SPI1);
  GPIO_PinAFConfig(GPIOA, GPIO_PinSource7, GPIO_AF_SPI1);
	
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd  = GPIO_PuPd_DOWN;
	
	/*!< SPI SCK pin configuration */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_5;
  GPIO_Init(GPIOA, &GPIO_InitStructure);

  /*!< SPI MOSI pin configuration */
  GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_7;
  GPIO_Init(GPIOA, &GPIO_InitStructure);

  /*!< SPI MISO pin configuration */
  GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_6;
  GPIO_Init(GPIOA, &GPIO_InitStructure);
	
	 /*!< Configure sFLASH Card CS pin in output pushpull mode ********************/
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_4;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_Init(GPIOA, &GPIO_InitStructure);
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_Init(GPIOC, &GPIO_InitStructure);
	
	SPI_CSN_H();
	
	SPI_InitStructure.SPI_Direction = SPI_Direction_2Lines_FullDuplex; //˫ȫ˫ 
	SPI_InitStructure.SPI_Mode = SPI_Mode_Master; //ģʽ 
	SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b; //ݴС8λ 
	SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low; //ʱӼԣʱΪ 
	SPI_InitStructure.SPI_CPHA = SPI_CPHA_1Edge; //1ЧΪʱ 
	SPI_InitStructure.SPI_NSS = SPI_NSS_Soft; //NSSź 
	SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_4; // 
	SPI_InitStructure.SPI_FirstBit = SPI_FirstBit_MSB; //λǰ 
	SPI_InitStructure.SPI_CRCPolynomial = 7; 
	SPI_Init(SPI1, &SPI_InitStructure); 
	/* Enable SPI1 */ 
	SPI_Cmd(SPI1, ENABLE);
}
u8 Spi_RW(u8 dat) 
{ 
	/*  SPIͻǿʱȴ */ 
	while (SPI_I2S_GetFlagStatus(SPI1, SPI_I2S_FLAG_TXE) == RESET); 
	/* ͨ SPI2һֽ */ 
	SPI_I2S_SendData(SPI1, dat); 
	/* SPIջΪʱȴ */ 
	while (SPI_I2S_GetFlagStatus(SPI1, SPI_I2S_FLAG_RXNE) == RESET); 
	/* Return the byte read from the SPI bus */ 
	return SPI_I2S_ReceiveData(SPI1); 
}
/////////////////////////////////////////////////////////////////////////////////////////////
uint8_t NRF24L01_RXDATA[RX_PLOAD_WIDTH];//nrf24l01յ
uint8_t NRF24L01_TXDATA[RX_PLOAD_WIDTH];//nrf24l01Ҫ͵
u8  TX_ADDRESS[TX_ADR_WIDTH]= {0xE1,0xE2,0xE3,0xE4,0xE5};	//صַ
u8  RX_ADDRESS[RX_ADR_WIDTH]= {0xE1,0xE2,0xE3,0xE4,0xE5};	//յַ

/*
*****************************************************************
* дĴ
*****************************************************************
*/
uint8_t NRF_Write_Reg(uint8_t reg, uint8_t value)
{
	uint8_t status;
	SPI_CSN_L();					  /* ѡͨ */
	status = Spi_RW(reg);  /* дĴַ */
	Spi_RW(value);		  /* д */
	SPI_CSN_H();					  /* ֹ */
  return 	status;
}
/*
*****************************************************************
* Ĵ
*****************************************************************
*/
uint8_t NRF_Read_Reg(uint8_t reg)
{
	uint8_t reg_val;
	SPI_CSN_L();					  /* ѡͨ */
	Spi_RW(reg);			  /* дĴַ */
	reg_val = Spi_RW(0);	  /* ȡüĴ */
	SPI_CSN_H();					  /* ֹ */
    return 	reg_val;
}
/*
*****************************************************************
*
* д
*
*****************************************************************
*/
uint8_t NRF_Write_Buf(uint8_t reg, uint8_t *pBuf, uint8_t uchars)
{
	uint8_t i;
	uint8_t status;
	SPI_CSN_L();				        /* ѡͨ */
	status = Spi_RW(reg);	/* дĴַ */
	for(i=0; i<uchars; i++)
	{
		Spi_RW(pBuf[i]);		/* д */
	}
	SPI_CSN_H();						/* ֹ */
    return 	status;	
}
/*
*****************************************************************
* 
*****************************************************************
*/
uint8_t NRF_Read_Buf(uint8_t reg, uint8_t *pBuf, uint8_t uchars)
{
	uint8_t i;
	uint8_t status;
	SPI_CSN_L();						/* ѡͨ */
	status = Spi_RW(reg);	/* дĴַ */
	for(i=0; i<uchars; i++)
	{
		pBuf[i] = Spi_RW(0); /* ȡ */ 	
	}
	SPI_CSN_H();						/* ֹ */
    return 	status;
}
/*
*****************************************************************
* дݰ
*****************************************************************
*/
void NRF_TxPacket(uint8_t * tx_buf, uint8_t len)
{	
	SPI_CE_L();		 //StandBy Iģʽ	
	
	NRF_Write_Buf(NRF_WRITE_REG + RX_ADDR_P0, TX_ADDRESS, TX_ADR_WIDTH); // װؽն˵ַ
	NRF_Write_Buf(WR_TX_PLOAD, tx_buf, len); 			 // װ	
	SPI_CE_H();		 //øCEݷ
}
void NRF_TxPacket_AP(uint8_t * tx_buf, uint8_t len)
{	
	SPI_CE_L();		 //StandBy Iģʽ	
	NRF_Write_Buf(0xa8, tx_buf, len); 			 // װ
	SPI_CE_H();		 //øCE
}
u8 Nrf24l01_Check(void)
{ 
	u8 buf1[5]; 
	u8 i; 
	/*д5ֽڵĵַ. */ 
	NRF_Write_Buf(NRF_WRITE_REG+TX_ADDR,TX_ADDRESS,5); 
	/*дĵַ */ 
	NRF_Read_Buf(TX_ADDR,buf1,5); 
	/*Ƚ*/ 
	for(i=0;i<5;i++) 
	{ 
		if(buf1[i]!=TX_ADDRESS[i]) 
			break; 
	} 
	if(i==5)
		return SUCCESS ; //MCUNRFɹ 
	else
		return ERROR ; //MCUNRF 
}
void Nrf24l01_Init(u8 model, u8 ch)
{
	SPI_CE_L();
	NRF_Write_Buf(NRF_WRITE_REG+RX_ADDR_P0,RX_ADDRESS,RX_ADR_WIDTH);	//дRXڵַ 
	NRF_Write_Buf(NRF_WRITE_REG+TX_ADDR,TX_ADDRESS,TX_ADR_WIDTH); 		//дTXڵַ  
	NRF_Write_Reg(NRF_WRITE_REG+EN_AA,0x01); 													//ʹͨ0ԶӦ 
	NRF_Write_Reg(NRF_WRITE_REG+EN_RXADDR,0x01);											//ʹͨ0Ľյַ 
	NRF_Write_Reg(NRF_WRITE_REG+SETUP_RETR,0x1a);											//Զطʱ:500us;Զط:10 
	NRF_Write_Reg(NRF_WRITE_REG+RF_CH,40);														//RFͨΪCHANAL
	NRF_Write_Reg(NRF_WRITE_REG+RF_SETUP,0x0f); 												//TX,0db,2Mbps,濪
	//NRF_Write_Reg(NRF_WRITE_REG+RF_SETUP,0x07); 												//TX,0db,1Mbps,濪
/////////////////////////////////////////////////////////
	if(model==1)				//RX
	{
		NRF_Write_Reg(NRF_WRITE_REG+RX_PW_P0,RX_PLOAD_WIDTH);								//ѡͨ0Чݿ 
		NRF_Write_Reg(NRF_WRITE_REG + CONFIG, 0x0f);   		 // IRQշжϿ,16λCRC,
	}
	else if(model==2)		//TX
	{
		NRF_Write_Reg(NRF_WRITE_REG+RX_PW_P0,RX_PLOAD_WIDTH);								//ѡͨ0Чݿ 
		NRF_Write_Reg(NRF_WRITE_REG + CONFIG, 0x0e);   		 // IRQշжϿ,16λCRC,
	}
	else if(model==3)		//RX2
	{
		NRF_Write_Reg(FLUSH_TX,0xff);
		NRF_Write_Reg(FLUSH_RX,0xff);
		NRF_Write_Reg(NRF_WRITE_REG + CONFIG, 0x0f);   		 // IRQշжϿ,16λCRC,
		
		Spi_RW(0x50);
		Spi_RW(0x73);
		NRF_Write_Reg(NRF_WRITE_REG+0x1c,0x01);
		NRF_Write_Reg(NRF_WRITE_REG+0x1d,0x06);
	}
	else								//TX2
	{
		NRF_Write_Reg(NRF_WRITE_REG + CONFIG, 0x7e);   		 // IRQշжϿ,16λCRC,
		NRF_Write_Reg(FLUSH_TX,0xff);
		NRF_Write_Reg(FLUSH_RX,0xff);
		
		Spi_RW(0x50);
		Spi_RW(0x73);
		NRF_Write_Reg(NRF_WRITE_REG+0x1c,0x01);
		NRF_Write_Reg(NRF_WRITE_REG+0x1d,0x06);
	}
	SPI_CE_H();
}
u8 Nrf_Get_Sta(void)
{
	return NRF_Read_Reg(NRF_READ_REG + NRFRegSTATUS);
}
u8 Nrf_Get_FIFOSta(void)
{
	return NRF_Read_Reg(NRF_READ_REG + FIFO_STATUS);
}
void Nrf_Check_Event(void)
{
	u8 sta = Nrf_Get_Sta();
	////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////
	if(sta & (1<<RX_DR))
	{
		u8 rx_len = NRF_Read_Reg(R_RX_PL_WID);
		NRF_Read_Buf(RD_RX_PLOAD,NRF24L01_RXDATA,rx_len);
		Data_Receive_Anl(NRF24L01_RXDATA,rx_len);
	}
	////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////
	if(sta & (1<<TX_DS))
	{
	}
	////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////
	if((sta & (1<<MAX_RT))||(sta & 0x01))//??????????
	{
			NRF_Write_Reg(FLUSH_TX,0xff);
	}
	////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////
	NRF_Write_Reg(NRF_WRITE_REG + NRFRegSTATUS, sta);
}
