#include "Tim_Pwm_In.h"
#include <rtthread.h>

static u16 Rc_Pwm_In[10];
T_RC_Data Rc_Data;//1000~2000

static void Rc_DataAnl(void)
{
	Rc_Data.THROTTLE		=	Rc_Pwm_In[9];
	Rc_Data.YAW				=	Rc_Pwm_In[8];
	Rc_Data.ROLL			=	Rc_Pwm_In[7];
	Rc_Data.PITCH			=	Rc_Pwm_In[6];
	Rc_Data.AUX1			=	Rc_Pwm_In[1];
	Rc_Data.AUX2			=	Rc_Pwm_In[0];
	Rc_Data.AUX3			=	Rc_Pwm_In[5];
	Rc_Data.AUX4			=	Rc_Pwm_In[2];
	Rc_Data.AUX5			=	Rc_Pwm_In[3];
	Rc_Data.AUX6			=	Rc_Pwm_In[4];
	rt_event_send(&Evt_Sys,EVT_RC_GET);
}
void Rc_GetValue(T_RC_Data *temp)
{
	temp->THROTTLE	= Rc_Data.THROTTLE;
	temp->YAW		= Rc_Data.YAW;
	temp->ROLL		= Rc_Data.ROLL;
	temp->PITCH		= Rc_Data.PITCH;
	temp->AUX1		= Rc_Data.AUX1;
	temp->AUX2		= Rc_Data.AUX2;
	temp->AUX3		= Rc_Data.AUX3;
	temp->AUX4		= Rc_Data.AUX4;
	temp->AUX5		= Rc_Data.AUX5;
	temp->AUX6		= Rc_Data.AUX6;
	
}

void Tim_Pwm_In_Init(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;
  TIM_ICInitTypeDef  TIM_ICInitStructure;
	
  RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM2|RCC_APB1Periph_TIM3, ENABLE);
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_TIM9|RCC_APB2Periph_TIM10|RCC_APB2Periph_TIM11, ENABLE);

  RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOB|RCC_AHB1Periph_GPIOA|RCC_AHB1Periph_GPIOE, ENABLE);
//////////////////////////////////////////////////////////////////////////////////////////////
  GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_4|GPIO_Pin_5|GPIO_Pin_0|GPIO_Pin_1;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_Init(GPIOB, &GPIO_InitStructure);

  GPIO_PinAFConfig(GPIOB, GPIO_PinSource4, GPIO_AF_TIM3);
	GPIO_PinAFConfig(GPIOB, GPIO_PinSource5, GPIO_AF_TIM3);
	GPIO_PinAFConfig(GPIOB, GPIO_PinSource0, GPIO_AF_TIM3);
	GPIO_PinAFConfig(GPIOB, GPIO_PinSource1, GPIO_AF_TIM3);
  
	TIM3->PSC = (168/2)-1;
	
	TIM_ICInitStructure.TIM_Channel = TIM_Channel_1;
  TIM_ICInitStructure.TIM_ICPolarity = TIM_ICPolarity_BothEdge;
  TIM_ICInitStructure.TIM_ICSelection = TIM_ICSelection_DirectTI;
  TIM_ICInitStructure.TIM_ICPrescaler = TIM_ICPSC_DIV1;
  TIM_ICInitStructure.TIM_ICFilter = 0x0;
  TIM_ICInit(TIM3, &TIM_ICInitStructure);
	TIM_ICInitStructure.TIM_Channel = TIM_Channel_2;
  TIM_ICInitStructure.TIM_ICPolarity = TIM_ICPolarity_BothEdge;
  TIM_ICInitStructure.TIM_ICSelection = TIM_ICSelection_DirectTI;
  TIM_ICInitStructure.TIM_ICPrescaler = TIM_ICPSC_DIV1;
  TIM_ICInitStructure.TIM_ICFilter = 0x0;
  TIM_ICInit(TIM3, &TIM_ICInitStructure);
	TIM_ICInitStructure.TIM_Channel = TIM_Channel_3;
  TIM_ICInitStructure.TIM_ICPolarity = TIM_ICPolarity_BothEdge;
  TIM_ICInitStructure.TIM_ICSelection = TIM_ICSelection_DirectTI;
  TIM_ICInitStructure.TIM_ICPrescaler = TIM_ICPSC_DIV1;
  TIM_ICInitStructure.TIM_ICFilter = 0x0;
  TIM_ICInit(TIM3, &TIM_ICInitStructure);
	TIM_ICInitStructure.TIM_Channel = TIM_Channel_4;
  TIM_ICInitStructure.TIM_ICPolarity = TIM_ICPolarity_BothEdge;
  TIM_ICInitStructure.TIM_ICSelection = TIM_ICSelection_DirectTI;
  TIM_ICInitStructure.TIM_ICPrescaler = TIM_ICPSC_DIV1;
  TIM_ICInitStructure.TIM_ICFilter = 0x0;
  TIM_ICInit(TIM3, &TIM_ICInitStructure);
  
  /* TIM enable counter */
  TIM_Cmd(TIM3, ENABLE);

  /* Enable the CC2 Interrupt Request */
  TIM_ITConfig(TIM3, TIM_IT_CC1, ENABLE);
	TIM_ITConfig(TIM3, TIM_IT_CC2, ENABLE);
	TIM_ITConfig(TIM3, TIM_IT_CC3, ENABLE);
	TIM_ITConfig(TIM3, TIM_IT_CC4, ENABLE);
/////////////////////////////////////////////////////////////////////////////////////////////
	GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_15;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_Init(GPIOA, &GPIO_InitStructure);
	GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_3;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_Init(GPIOB, &GPIO_InitStructure);

  GPIO_PinAFConfig(GPIOA, GPIO_PinSource15, GPIO_AF_TIM2);
	GPIO_PinAFConfig(GPIOB, GPIO_PinSource3, GPIO_AF_TIM2);
	
	TIM2->PSC = (168/2)-1;
	
	TIM_ICInitStructure.TIM_Channel = TIM_Channel_1;
  TIM_ICInitStructure.TIM_ICPolarity = TIM_ICPolarity_BothEdge;
  TIM_ICInitStructure.TIM_ICSelection = TIM_ICSelection_DirectTI;
  TIM_ICInitStructure.TIM_ICPrescaler = TIM_ICPSC_DIV1;
  TIM_ICInitStructure.TIM_ICFilter = 0x0;
  TIM_ICInit(TIM2, &TIM_ICInitStructure);
	TIM_ICInitStructure.TIM_Channel = TIM_Channel_2;
  TIM_ICInitStructure.TIM_ICPolarity = TIM_ICPolarity_BothEdge;
  TIM_ICInitStructure.TIM_ICSelection = TIM_ICSelection_DirectTI;
  TIM_ICInitStructure.TIM_ICPrescaler = TIM_ICPSC_DIV1;
  TIM_ICInitStructure.TIM_ICFilter = 0x0;
  TIM_ICInit(TIM2, &TIM_ICInitStructure);
	
	/* TIM enable counter */
  TIM_Cmd(TIM2, ENABLE);

  /* Enable the CC2 Interrupt Request */
  TIM_ITConfig(TIM2, TIM_IT_CC1, ENABLE);
	TIM_ITConfig(TIM2, TIM_IT_CC2, ENABLE);
	TIM2->EGR = 1;
/////////////////////////////////////////////////////////////////////////////////////////////
	GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_5|GPIO_Pin_6;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_Init(GPIOE, &GPIO_InitStructure);
	
	GPIO_PinAFConfig(GPIOE, GPIO_PinSource5, GPIO_AF_TIM9);
	GPIO_PinAFConfig(GPIOE, GPIO_PinSource6, GPIO_AF_TIM9);
	
	TIM9->PSC = 168-1;
	
	TIM_ICInitStructure.TIM_Channel = TIM_Channel_1;
  TIM_ICInitStructure.TIM_ICPolarity = TIM_ICPolarity_BothEdge;
  TIM_ICInitStructure.TIM_ICSelection = TIM_ICSelection_DirectTI;
  TIM_ICInitStructure.TIM_ICPrescaler = TIM_ICPSC_DIV1;
  TIM_ICInitStructure.TIM_ICFilter = 0x0;
  TIM_ICInit(TIM9, &TIM_ICInitStructure);
	TIM_ICInitStructure.TIM_Channel = TIM_Channel_2;
  TIM_ICInitStructure.TIM_ICPolarity = TIM_ICPolarity_BothEdge;
  TIM_ICInitStructure.TIM_ICSelection = TIM_ICSelection_DirectTI;
  TIM_ICInitStructure.TIM_ICPrescaler = TIM_ICPSC_DIV1;
  TIM_ICInitStructure.TIM_ICFilter = 0x0;
  TIM_ICInit(TIM9, &TIM_ICInitStructure);
	
	/* TIM enable counter */
  TIM_Cmd(TIM9, ENABLE);

  /* Enable the CC2 Interrupt Request */
  TIM_ITConfig(TIM9, TIM_IT_CC1, ENABLE);
	TIM_ITConfig(TIM9, TIM_IT_CC2, ENABLE);
/////////////////////////////////////////////////////////////////////////////////////////////
	GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_8;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_Init(GPIOB, &GPIO_InitStructure);
	
	GPIO_PinAFConfig(GPIOB, GPIO_PinSource8, GPIO_AF_TIM10);
	
	TIM10->PSC = 168-1;
	
	TIM_ICInitStructure.TIM_Channel = TIM_Channel_1;
  TIM_ICInitStructure.TIM_ICPolarity = TIM_ICPolarity_BothEdge;
  TIM_ICInitStructure.TIM_ICSelection = TIM_ICSelection_DirectTI;
  TIM_ICInitStructure.TIM_ICPrescaler = TIM_ICPSC_DIV1;
  TIM_ICInitStructure.TIM_ICFilter = 0x0;
  TIM_ICInit(TIM10, &TIM_ICInitStructure);
	
	/* TIM enable counter */
  TIM_Cmd(TIM10, ENABLE);

  /* Enable the CC2 Interrupt Request */
  TIM_ITConfig(TIM10, TIM_IT_CC1, ENABLE);
/////////////////////////////////////////////////////////////////////////////////////////////
	GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_9;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_Init(GPIOB, &GPIO_InitStructure);
	
	GPIO_PinAFConfig(GPIOB, GPIO_PinSource9, GPIO_AF_TIM11);
	
	TIM11->PSC = 168-1;
	
	TIM_ICInitStructure.TIM_Channel = TIM_Channel_1;
  TIM_ICInitStructure.TIM_ICPolarity = TIM_ICPolarity_BothEdge;
  TIM_ICInitStructure.TIM_ICSelection = TIM_ICSelection_DirectTI;
  TIM_ICInitStructure.TIM_ICPrescaler = TIM_ICPSC_DIV1;
  TIM_ICInitStructure.TIM_ICFilter = 0x0;
  TIM_ICInit(TIM11, &TIM_ICInitStructure);
	
	/* TIM enable counter */
  TIM_Cmd(TIM11, ENABLE);

  /* Enable the CC2 Interrupt Request */
  TIM_ITConfig(TIM11, TIM_IT_CC1, ENABLE);
}
void Tim3_Pwm_In_Irq(void)
{
	static u16 temp_cnt1,temp_cnt1_2,temp_cnt2,temp_cnt2_2,temp_cnt3,temp_cnt3_2,temp_cnt4,temp_cnt4_2;
	
	if(TIM3->SR & TIM_IT_CC1) 
	{
		TIM3->SR = ~TIM_IT_CC1;//TIM_ClearITPendingBit(TIM3, TIM_IT_CC1);
		TIM3->SR = ~TIM_FLAG_CC1OF;
		if(GPIOB->IDR & GPIO_Pin_4)
		{
			temp_cnt1 = TIM_GetCapture1(TIM3);
		}
		else
		{
			temp_cnt1_2 = TIM_GetCapture1(TIM3);
			if(temp_cnt1_2>=temp_cnt1)
				Rc_Pwm_In[0] = temp_cnt1_2-temp_cnt1;
			else
				Rc_Pwm_In[0] = 0xffff-temp_cnt1+temp_cnt1_2;
		}
	}
	if(TIM3->SR & TIM_IT_CC2) 
	{
		TIM3->SR = ~TIM_IT_CC2;
		TIM3->SR = ~TIM_FLAG_CC2OF;
		if(GPIOB->IDR & GPIO_Pin_5)
		{
			temp_cnt2 = TIM_GetCapture2(TIM3);
		}
		else
		{
			temp_cnt2_2 = TIM_GetCapture2(TIM3);
			if(temp_cnt2_2>=temp_cnt2)
				Rc_Pwm_In[1] = temp_cnt2_2-temp_cnt2;
			else
				Rc_Pwm_In[1] = 0xffff-temp_cnt2+temp_cnt2_2;
		}
	}
	if(TIM3->SR & TIM_IT_CC3) 
	{
		TIM3->SR = ~TIM_IT_CC3;
		TIM3->SR = ~TIM_FLAG_CC3OF;
		if(GPIOB->IDR & GPIO_Pin_0)
		{
			temp_cnt3 = TIM_GetCapture3(TIM3);
		}
		else
		{
			temp_cnt3_2 = TIM_GetCapture3(TIM3);
			if(temp_cnt3_2>=temp_cnt3)
				Rc_Pwm_In[2] = temp_cnt3_2-temp_cnt3;
			else
				Rc_Pwm_In[2] = 0xffff-temp_cnt3+temp_cnt3_2;
		}
	}
	if(TIM3->SR & TIM_IT_CC4) 
	{
		TIM3->SR = ~TIM_IT_CC4;
		TIM3->SR = ~TIM_FLAG_CC4OF;
		if(GPIOB->IDR & GPIO_Pin_1)
		{
			temp_cnt4 = TIM_GetCapture4(TIM3);
		}
		else
		{
			temp_cnt4_2 = TIM_GetCapture4(TIM3);
			if(temp_cnt4_2>=temp_cnt4)
				Rc_Pwm_In[3] = temp_cnt4_2-temp_cnt4;
			else
				Rc_Pwm_In[3] = 0xffff-temp_cnt4+temp_cnt4_2;
		}
	}
}
void Tim2_Pwm_In_Irq(void)
{
	static u16 temp_cnt1,temp_cnt1_2,temp_cnt2,temp_cnt2_2;
	
	if(TIM2->SR & TIM_IT_CC1) 
	{
		TIM2->SR = ~TIM_IT_CC1;//TIM_ClearITPendingBit(TIM3, TIM_IT_CC1);
		TIM2->SR = ~TIM_FLAG_CC1OF;
		if(GPIOA->IDR & GPIO_Pin_15)
		{
			temp_cnt1 = TIM_GetCapture1(TIM2);
		}
		else
		{
			temp_cnt1_2 = TIM_GetCapture1(TIM2);
			if(temp_cnt1_2>=temp_cnt1)
				Rc_Pwm_In[4] = temp_cnt1_2-temp_cnt1;
			else
				Rc_Pwm_In[4] = 0xffff-temp_cnt1+temp_cnt1_2;
		}
	}
	if(TIM2->SR & TIM_IT_CC2) 
	{
		TIM2->SR = ~TIM_IT_CC2;
		TIM2->SR = ~TIM_FLAG_CC2OF;
		if(GPIOB->IDR & GPIO_Pin_3)
		{
			temp_cnt2 = TIM_GetCapture2(TIM2);
		}
		else
		{
			temp_cnt2_2 = TIM_GetCapture2(TIM2);
			if(temp_cnt2_2>=temp_cnt2)
				Rc_Pwm_In[5] = temp_cnt2_2-temp_cnt2;
			else
				Rc_Pwm_In[5] = 0xffff-temp_cnt2+temp_cnt2_2;
		}
	}
}
void Tim9_Pwm_In_Irq(void)
{
	static u16 temp_cnt1,temp_cnt1_2,temp_cnt2,temp_cnt2_2;
	
	if(TIM9->SR & TIM_IT_CC1) 
	{
		TIM9->SR = ~TIM_IT_CC1;//TIM_ClearITPendingBit(TIM3, TIM_IT_CC1);
		TIM9->SR = ~TIM_FLAG_CC1OF;
		if(GPIOE->IDR & GPIO_Pin_5)
		{
			temp_cnt1 = TIM_GetCapture1(TIM9);
		}
		else
		{
			temp_cnt1_2 = TIM_GetCapture1(TIM9);
			if(temp_cnt1_2>=temp_cnt1)
				Rc_Pwm_In[6] = temp_cnt1_2-temp_cnt1;
			else
				Rc_Pwm_In[6] = 0xffff-temp_cnt1+temp_cnt1_2;
		}
	}
	if(TIM9->SR & TIM_IT_CC2) 
	{
		TIM9->SR = ~TIM_IT_CC2;
		TIM9->SR = ~TIM_FLAG_CC2OF;
		if(GPIOE->IDR & GPIO_Pin_6)
		{
			temp_cnt2 = TIM_GetCapture2(TIM9);
		}
		else
		{
			temp_cnt2_2 = TIM_GetCapture2(TIM9);
			if(temp_cnt2_2>=temp_cnt2)
				Rc_Pwm_In[7] = temp_cnt2_2-temp_cnt2;
			else
				Rc_Pwm_In[7] = 0xffff-temp_cnt2+temp_cnt2_2;
		}
	}
}
void Tim10_Pwm_In_Irq(void)
{
	static u16 temp_cnt1,temp_cnt1_2;
	
	if(TIM10->SR & TIM_IT_CC1) 
	{
		TIM10->SR = ~TIM_IT_CC1;//TIM_ClearITPendingBit(TIM3, TIM_IT_CC1);
		TIM10->SR = ~TIM_FLAG_CC1OF;
		if(GPIOB->IDR & GPIO_Pin_8)
		{
			temp_cnt1 = TIM_GetCapture1(TIM10);
		}
		else
		{
			temp_cnt1_2 = TIM_GetCapture1(TIM10);
			if(temp_cnt1_2>=temp_cnt1)
				Rc_Pwm_In[8] = temp_cnt1_2-temp_cnt1;
			else
				Rc_Pwm_In[8] = 0xffff-temp_cnt1+temp_cnt1_2;
//			Rc_Pwm_In_Ready = 1;
			Rc_DataAnl();///////////////////////////////////////////////////////
		}
	}
}
void Tim11_Pwm_In_Irq(void)
{
	static u16 temp_cnt1,temp_cnt1_2;
	
	if(TIM11->SR & TIM_IT_CC1) 
	{
		TIM11->SR = ~TIM_IT_CC1;//TIM_ClearITPendingBit(TIM3, TIM_IT_CC1);
		TIM11->SR = ~TIM_FLAG_CC1OF;
		if(GPIOB->IDR & GPIO_Pin_9)
		{
			temp_cnt1 = TIM_GetCapture1(TIM11);
		}
		else
		{
			temp_cnt1_2 = TIM_GetCapture1(TIM11);
			if(temp_cnt1_2>=temp_cnt1)
				Rc_Pwm_In[9] = temp_cnt1_2-temp_cnt1;
			else
				Rc_Pwm_In[9] = 0xffff-temp_cnt1+temp_cnt1_2;
		}
	}
}
